/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.wso2.andes.server.cluster.coordination.CoordinationConstants;
import org.wso2.andes.server.cluster.coordination.CoordinationException;

public class ZooKeeperAgent
implements Watcher {
    private ZooKeeper zk;
    private int sesstionTimeOut = 1200000;
    private static Log log = LogFactory.getLog(ZooKeeper.class);

    public ZooKeeperAgent(String connectionString) throws IOException {
        log.debug((Object)("Starting Zookeeper agent for host : " + connectionString));
        this.zk = new ZooKeeper(connectionString, this.sesstionTimeOut, (Watcher)this);
        log.debug((Object)("ZooKeeper agent started successfully and connected to  " + connectionString));
    }

    public void process(WatchedEvent watchedEvent) {
    }

    public void initQueueWorkerCoordination() throws CoordinationException {
        try {
            if (this.zk.exists(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT, false) == null) {
                this.zk.create(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            } else if (this.zk.getChildren(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT, false) == null || this.zk.getChildren(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT, false).size() == 0) {
                this.zk.delete(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT, -1);
                this.zk.create(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception e) {
            String msg = "Error while creating Queue worker coordination parent at " + CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT;
            log.error((Object)msg, (Throwable)e);
            throw new CoordinationException(msg, e);
        }
    }

    public void initQueueFailOverMCProcess(String queue) throws CoordinationException {
        try {
            if (this.zk.exists(CoordinationConstants.QUEUE_FAIL_OVER_HANDLING_PARENT + "_" + queue, false) == null) {
                this.zk.create(CoordinationConstants.QUEUE_FAIL_OVER_HANDLING_PARENT + "_" + queue, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            } else if (this.zk.getChildren(CoordinationConstants.QUEUE_FAIL_OVER_HANDLING_PARENT + "_" + queue, false) == null || this.zk.getChildren(CoordinationConstants.QUEUE_FAIL_OVER_HANDLING_PARENT + "_" + queue, false).size() == 0) {
                this.zk.delete(CoordinationConstants.QUEUE_FAIL_OVER_HANDLING_PARENT + "_" + queue, -1);
                this.zk.create(CoordinationConstants.QUEUE_FAIL_OVER_HANDLING_PARENT + "_" + queue, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception e) {
            String msg = "Error while creating Queue worker coordination parent at " + CoordinationConstants.QUEUE_FAIL_OVER_HANDLING_PARENT + "_" + queue;
            throw new CoordinationException(msg, e);
        }
    }

    public void initQueueResourceLockCoordination(String queue) throws CoordinationException {
        try {
            if (this.zk.exists(CoordinationConstants.QUEUE_RESOURCE_LOCK_PARENT + "_" + queue, false) == null) {
                this.zk.create(CoordinationConstants.QUEUE_RESOURCE_LOCK_PARENT + "_" + queue, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception e) {
            String msg = "Error while creating Queue worker coordination parent at " + CoordinationConstants.QUEUE_RESOURCE_LOCK_PARENT + "_" + queue;
            throw new CoordinationException(msg, e);
        }
    }

    public void initSubscriptionCoordination() throws CoordinationException {
        try {
            if (this.zk.exists("/subscription_coordination_parent", false) == null) {
                this.zk.create("/subscription_coordination_parent", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception e) {
            String msg = "Error while creating Subscription coordination parent at /subscription_coordination_parent";
            throw new CoordinationException(msg, e);
        }
    }

    public ZooKeeper getZooKeeper() {
        return this.zk;
    }
}

