/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cassandra;

import java.util.LinkedList;

class ThreadPool
extends ThreadGroup {
    private boolean isAlive;
    private LinkedList taskQueue;
    private int threadID;
    private static int threadPoolID;

    public ThreadPool(int numThreads) {
        super("ThreadPool-" + threadPoolID++);
        this.setDaemon(true);
        this.isAlive = true;
        this.taskQueue = new LinkedList();
        for (int i = 0; i < numThreads; ++i) {
            new PooledThread().start();
        }
    }

    public synchronized void runTask(Runnable task) {
        if (!this.isAlive) {
            throw new IllegalStateException();
        }
        if (task != null) {
            this.taskQueue.add(task);
            this.notify();
        }
    }

    protected synchronized Runnable getTask() throws InterruptedException {
        while (this.taskQueue.size() == 0) {
            if (!this.isAlive) {
                return null;
            }
            this.wait();
        }
        return (Runnable)this.taskQueue.removeFirst();
    }

    public synchronized void close() {
        if (this.isAlive) {
            this.isAlive = false;
            this.taskQueue.clear();
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.isAlive = false;
            this.notifyAll();
        }
        Thread[] threads = new Thread[this.activeCount()];
        int count = this.enumerate(threads);
        for (int i = 0; i < count; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    private class PooledThread
    extends Thread {
        public PooledThread() {
            super((ThreadGroup)ThreadPool.this, "PooledThread-" + ThreadPool.this.threadID++);
        }

        public void run() {
            while (!this.isInterrupted()) {
                Runnable task = null;
                try {
                    task = ThreadPool.this.getTask();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (task == null) {
                    return;
                }
                try {
                    task.run();
                }
                catch (Throwable t) {
                    ThreadPool.this.uncaughtException(this, t);
                }
            }
        }
    }
}

