/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cassandra;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQStoreException;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cassandra.CassandraMessageFlusher;
import org.wso2.andes.server.cassandra.CassandraQueueMessage;
import org.wso2.andes.server.cassandra.CassandraSubscription;
import org.wso2.andes.server.cassandra.ClusteringEnabledSubscriptionManager;
import org.wso2.andes.server.cassandra.QueueBrowserFlusher;
import org.wso2.andes.server.cassandra.QueueSubscriptionAcknowledgementHandler;
import org.wso2.andes.server.cluster.ClusterManager;
import org.wso2.andes.server.cluster.coordination.SubscriptionCoordinationManager;
import org.wso2.andes.server.cluster.coordination.SubscriptionListener;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.store.CassandraMessageStore;
import org.wso2.andes.server.subscription.SubscriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClusteringEnabledSubscriptionManager
implements ClusteringEnabledSubscriptionManager {
    private static Log log = LogFactory.getLog(DefaultClusteringEnabledSubscriptionManager.class);
    private Map<String, CassandraMessageFlusher> workMap = new ConcurrentHashMap<String, CassandraMessageFlusher>();
    private Map<String, Map<String, CassandraSubscription>> subscriptionMap = new ConcurrentHashMap<String, Map<String, CassandraSubscription>>();
    private HashMap<String, List<String>> userQueuesMap = new HashMap();
    private ExecutorService executor = null;
    private Map<AMQChannel, Map<Long, Semaphore>> unAckedMessagelocks = new ConcurrentHashMap<AMQChannel, Map<Long, Semaphore>>();
    private Map<AMQChannel, QueueSubscriptionAcknowledgementHandler> acknowledgementHandlerMap = new ConcurrentHashMap<AMQChannel, QueueSubscriptionAcknowledgementHandler>();

    @Override
    public void init() {
        this.executor = Executors.newFixedThreadPool(ClusterResourceHolder.getInstance().getClusterConfiguration().getSubscriptionPoolSize());
        this.executor.submit(new CassandraSubscriptionsSynchronizer());
        SubscriptionCoordinationManager subscriptionCoordinationManager = ClusterResourceHolder.getInstance().getSubscriptionCoordinationManager();
        subscriptionCoordinationManager.registerSubscriptionListener(new SubscriptionListener(){

            public void subscriptionsChanged() {
                try {
                    DefaultClusteringEnabledSubscriptionManager.this.syncUserQueues();
                }
                catch (Exception e) {
                    log.error((Object)"Error while Syncing Subscriptions ", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscription(AMQQueue queue, CassandraSubscription subscription) {
        if (subscription.getSubscription() instanceof SubscriptionImpl.BrowserSubscription) {
            try {
                ClusterResourceHolder.getInstance().getCassandraMessageStore().addUserQueueToGlobalQueue(queue.getResourceName());
            }
            catch (AMQStoreException e) {
                e.printStackTrace();
            }
            QueueBrowserFlusher flusher = new QueueBrowserFlusher(subscription.getSubscription(), queue, subscription.getSession());
            flusher.send();
        } else {
            Map<String, CassandraSubscription> subscriptions = this.subscriptionMap.get(queue.getResourceName());
            if (subscriptions == null || subscriptions.size() == 0) {
                Map<String, Map<String, CassandraSubscription>> map = this.subscriptionMap;
                synchronized (map) {
                    subscriptions = this.subscriptionMap.get(queue.getResourceName());
                    if (subscriptions == null || subscriptions.size() == 0) {
                        subscriptions = this.subscriptionMap.get(queue.getResourceName());
                        if (subscriptions == null) {
                            subscriptions = new ConcurrentHashMap<String, CassandraSubscription>();
                            subscriptions.put(subscription.getSubscription().getSubscriptionID() + "", subscription);
                            this.subscriptionMap.put(queue.getResourceName(), subscriptions);
                            this.handleSubscription(queue, subscriptions);
                        } else if (subscriptions.size() == 0) {
                            subscriptions.put(subscription.getSubscription().getSubscriptionID() + "", subscription);
                            this.handleSubscription(queue, subscriptions);
                        }
                    } else {
                        subscriptions.put(subscription.getSubscription().getSubscriptionID() + "", subscription);
                    }
                }
            } else {
                subscriptions.put(subscription.getSubscription().getSubscriptionID() + "", subscription);
            }
        }
        try {
            ClusterResourceHolder.getInstance().getSubscriptionCoordinationManager().handleSubscriptionChange();
        }
        catch (Exception e) {
            log.error((Object)"Error while notifying Subscription change");
        }
    }

    @Override
    public void removeSubscription(String queue, String subId) {
        try {
            Map<String, CassandraSubscription> subs = this.subscriptionMap.get(queue);
            if (subs != null && subs.containsKey(subId)) {
                subs.remove(subId);
                if (subs.size() == 0) {
                    CassandraMessageFlusher flusher = this.workMap.remove(queue);
                    flusher.stopFlusher();
                    log.debug((Object)"Executing subscription removal handler to minimize message losses");
                    ClusterManager cm = ClusterResourceHolder.getInstance().getClusterManager();
                    this.handleMessageRemoval(queue + "_" + cm.getNodeId(), queue);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while removing subscription for queue: " + queue), (Throwable)e);
        }
        try {
            ClusterResourceHolder.getInstance().getSubscriptionCoordinationManager().handleSubscriptionChange();
        }
        catch (Exception e) {
            log.error((Object)"Error while notifying Subscription change");
        }
    }

    private void handleMessageRemoval(String userQueue, String globalQueue) throws AMQStoreException {
        CassandraMessageStore messageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
        messageStore.removeUserQueueFromQpidQueue(userQueue);
        List<CassandraQueueMessage> messages = messageStore.getMessagesFromUserQueue(userQueue, globalQueue, 40);
        while (messages.size() != 0) {
            for (CassandraQueueMessage msg : messages) {
                messageStore.removeMessageFromUserQueue(userQueue, msg.getMessageId());
                try {
                    messageStore.addMessageToGlobalQueue(globalQueue, msg.getMessageId(), msg.getMessage());
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            messages = messageStore.getMessagesFromUserQueue(userQueue, globalQueue, 40);
        }
    }

    private void handleSubscription(AMQQueue queue, Map<String, CassandraSubscription> cassandraSubscriptions) {
        try {
            ClusterResourceHolder.getInstance().getCassandraMessageStore().addUserQueueToGlobalQueue(queue.getResourceName());
            CassandraMessageFlusher work = new CassandraMessageFlusher(queue, cassandraSubscriptions);
            this.workMap.put(queue.getResourceName(), work);
            this.executor.execute(work);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Error while adding subscription to queue :" + queue), (Throwable)e);
        }
    }

    public void markSubscriptionForRemovel(String queue) {
        CassandraMessageFlusher work = this.workMap.get(queue);
        if (work != null) {
            work.stopFlusher();
        }
    }

    public Map<String, CassandraMessageFlusher> getWorkMap() {
        return this.workMap;
    }

    public List<String> getUserQueues(String amqpQueueName) {
        return this.userQueuesMap.get(amqpQueueName);
    }

    @Override
    public Map<AMQChannel, Map<Long, Semaphore>> getUnAcknowledgedMessageLocks() {
        return this.unAckedMessagelocks;
    }

    @Override
    public Map<AMQChannel, QueueSubscriptionAcknowledgementHandler> getAcknowledgementHandlerMap() {
        return this.acknowledgementHandlerMap;
    }

    private void syncUserQueues() throws Exception {
        CassandraMessageStore messageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
        List<String> globalQueueList = messageStore.getGlobalQueues();
        for (String globalQueue : globalQueueList) {
            List<String> userQueueList = messageStore.getUserQueues(globalQueue);
            this.userQueuesMap.put(globalQueue, userQueueList);
        }
    }

    private class CassandraSubscriptionsSynchronizer
    implements Runnable {
        private CassandraSubscriptionsSynchronizer() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        DefaultClusteringEnabledSubscriptionManager.this.syncUserQueues();
                        Thread.sleep(ClusterResourceHolder.getInstance().getClusterConfiguration().getVirtualHostSyncTaskInterval() * 1000);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error while polling for data ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

