/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.qmf;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.wso2.andes.AMQException;
import org.wso2.andes.common.Closeable;
import org.wso2.andes.qmf.CompletionCode;
import org.wso2.andes.qmf.QMFClass;
import org.wso2.andes.qmf.QMFObject;
import org.wso2.andes.qmf.QMFObjectClass;
import org.wso2.andes.qmf.QMFPackage;
import org.wso2.andes.qmf.schema.BrokerSchema;
import org.wso2.andes.server.configuration.BindingConfig;
import org.wso2.andes.server.configuration.BindingConfigType;
import org.wso2.andes.server.configuration.BridgeConfig;
import org.wso2.andes.server.configuration.BridgeConfigType;
import org.wso2.andes.server.configuration.BrokerConfig;
import org.wso2.andes.server.configuration.BrokerConfigType;
import org.wso2.andes.server.configuration.ConfigObjectType;
import org.wso2.andes.server.configuration.ConfigStore;
import org.wso2.andes.server.configuration.ConfiguredObject;
import org.wso2.andes.server.configuration.ConnectionConfig;
import org.wso2.andes.server.configuration.ConnectionConfigType;
import org.wso2.andes.server.configuration.ExchangeConfig;
import org.wso2.andes.server.configuration.ExchangeConfigType;
import org.wso2.andes.server.configuration.LinkConfig;
import org.wso2.andes.server.configuration.LinkConfigType;
import org.wso2.andes.server.configuration.QueueConfig;
import org.wso2.andes.server.configuration.QueueConfigType;
import org.wso2.andes.server.configuration.SessionConfig;
import org.wso2.andes.server.configuration.SessionConfigType;
import org.wso2.andes.server.configuration.SubscriptionConfig;
import org.wso2.andes.server.configuration.SubscriptionConfigType;
import org.wso2.andes.server.configuration.SystemConfig;
import org.wso2.andes.server.configuration.SystemConfigType;
import org.wso2.andes.server.configuration.VirtualHostConfig;
import org.wso2.andes.server.configuration.VirtualHostConfigType;
import org.wso2.andes.server.registry.IApplicationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QMFService
implements ConfigStore.ConfigEventListener,
Closeable {
    private IApplicationRegistry _applicationRegistry;
    private ConfigStore _configStore;
    private final Map<String, QMFPackage> _supportedSchemas = new HashMap<String, QMFPackage>();
    private static final Map<String, ConfigObjectType> _qmfClassMapping = new HashMap<String, ConfigObjectType>();
    private final Map<ConfigObjectType, ConfigObjectAdapter> _adapterMap = new HashMap<ConfigObjectType, ConfigObjectAdapter>();
    private final Map<ConfigObjectType, QMFClass> _classMap = new HashMap<ConfigObjectType, QMFClass>();
    private final ConcurrentHashMap<QMFClass, ConcurrentHashMap<ConfiguredObject, QMFObject>> _managedObjects = new ConcurrentHashMap();
    private final ConcurrentHashMap<QMFClass, ConcurrentHashMap<UUID, QMFObject>> _managedObjectsById = new ConcurrentHashMap();
    private static final BrokerSchema PACKAGE;
    private final CopyOnWriteArrayList<Listener> _listeners = new CopyOnWriteArrayList();
    private ConfigObjectAdapter<BrokerSchema.SystemObject, BrokerSchema.SystemClass, BrokerSchema.SystemDelegate, SystemConfigType, SystemConfig> _systemObjectAdapter = new ConfigObjectAdapter<BrokerSchema.SystemObject, BrokerSchema.SystemClass, BrokerSchema.SystemDelegate, SystemConfigType, SystemConfig>(SystemConfigType.getInstance(), PACKAGE.getQMFClassInstance(BrokerSchema.SystemClass.class)){

        @Override
        public BrokerSchema.SystemObject createQMFObject(SystemConfig configObject) {
            return (BrokerSchema.SystemObject)this.newInstance(new SystemDelegate(configObject));
        }
    };
    private ConfigObjectAdapter<BrokerSchema.BrokerObject, BrokerSchema.BrokerClass, BrokerSchema.BrokerDelegate, BrokerConfigType, BrokerConfig> _brokerObjectAdapter = new ConfigObjectAdapter<BrokerSchema.BrokerObject, BrokerSchema.BrokerClass, BrokerSchema.BrokerDelegate, BrokerConfigType, BrokerConfig>(BrokerConfigType.getInstance(), PACKAGE.getQMFClassInstance(BrokerSchema.BrokerClass.class)){

        @Override
        public BrokerSchema.BrokerObject createQMFObject(BrokerConfig configObject) {
            return (BrokerSchema.BrokerObject)this.newInstance(new BrokerDelegate(configObject));
        }
    };
    private ConfigObjectAdapter<BrokerSchema.VhostObject, BrokerSchema.VhostClass, BrokerSchema.VhostDelegate, VirtualHostConfigType, VirtualHostConfig> _vhostObjectAdapter = new ConfigObjectAdapter<BrokerSchema.VhostObject, BrokerSchema.VhostClass, BrokerSchema.VhostDelegate, VirtualHostConfigType, VirtualHostConfig>(VirtualHostConfigType.getInstance(), PACKAGE.getQMFClassInstance(BrokerSchema.VhostClass.class)){

        @Override
        public BrokerSchema.VhostObject createQMFObject(VirtualHostConfig configObject) {
            return (BrokerSchema.VhostObject)this.newInstance(new VhostDelegate(configObject));
        }
    };
    private ConfigObjectAdapter<BrokerSchema.ExchangeObject, BrokerSchema.ExchangeClass, BrokerSchema.ExchangeDelegate, ExchangeConfigType, ExchangeConfig> _exchangeObjectAdapter = new ConfigObjectAdapter<BrokerSchema.ExchangeObject, BrokerSchema.ExchangeClass, BrokerSchema.ExchangeDelegate, ExchangeConfigType, ExchangeConfig>(ExchangeConfigType.getInstance(), PACKAGE.getQMFClassInstance(BrokerSchema.ExchangeClass.class)){

        @Override
        public BrokerSchema.ExchangeObject createQMFObject(ExchangeConfig configObject) {
            return (BrokerSchema.ExchangeObject)this.newInstance(new ExchangeDelegate(configObject));
        }
    };
    private ConfigObjectAdapter<BrokerSchema.QueueObject, BrokerSchema.QueueClass, BrokerSchema.QueueDelegate, QueueConfigType, QueueConfig> _queueObjectAdapter = new ConfigObjectAdapter<BrokerSchema.QueueObject, BrokerSchema.QueueClass, BrokerSchema.QueueDelegate, QueueConfigType, QueueConfig>(QueueConfigType.getInstance(), PACKAGE.getQMFClassInstance(BrokerSchema.QueueClass.class)){

        @Override
        public BrokerSchema.QueueObject createQMFObject(QueueConfig configObject) {
            return (BrokerSchema.QueueObject)this.newInstance(new QueueDelegate(configObject));
        }
    };
    private ConfigObjectAdapter<BrokerSchema.BindingObject, BrokerSchema.BindingClass, BrokerSchema.BindingDelegate, BindingConfigType, BindingConfig> _bindingObjectAdapter = new ConfigObjectAdapter<BrokerSchema.BindingObject, BrokerSchema.BindingClass, BrokerSchema.BindingDelegate, BindingConfigType, BindingConfig>(BindingConfigType.getInstance(), PACKAGE.getQMFClassInstance(BrokerSchema.BindingClass.class)){

        @Override
        public BrokerSchema.BindingObject createQMFObject(BindingConfig configObject) {
            return (BrokerSchema.BindingObject)this.newInstance(new BindingDelegate(configObject));
        }
    };
    private ConfigObjectAdapter<BrokerSchema.ConnectionObject, BrokerSchema.ConnectionClass, BrokerSchema.ConnectionDelegate, ConnectionConfigType, ConnectionConfig> _connectionObjectAdapter = new ConfigObjectAdapter<BrokerSchema.ConnectionObject, BrokerSchema.ConnectionClass, BrokerSchema.ConnectionDelegate, ConnectionConfigType, ConnectionConfig>(ConnectionConfigType.getInstance(), PACKAGE.getQMFClassInstance(BrokerSchema.ConnectionClass.class)){

        @Override
        public BrokerSchema.ConnectionObject createQMFObject(ConnectionConfig configObject) {
            return (BrokerSchema.ConnectionObject)this.newInstance(new ConnectionDelegate(configObject));
        }
    };
    private ConfigObjectAdapter<BrokerSchema.SessionObject, BrokerSchema.SessionClass, BrokerSchema.SessionDelegate, SessionConfigType, SessionConfig> _sessionObjectAdapter = new ConfigObjectAdapter<BrokerSchema.SessionObject, BrokerSchema.SessionClass, BrokerSchema.SessionDelegate, SessionConfigType, SessionConfig>(SessionConfigType.getInstance(), PACKAGE.getQMFClassInstance(BrokerSchema.SessionClass.class)){

        @Override
        public BrokerSchema.SessionObject createQMFObject(SessionConfig configObject) {
            return (BrokerSchema.SessionObject)this.newInstance(new SessionDelegate(configObject));
        }
    };
    private ConfigObjectAdapter<BrokerSchema.SubscriptionObject, BrokerSchema.SubscriptionClass, BrokerSchema.SubscriptionDelegate, SubscriptionConfigType, SubscriptionConfig> _subscriptionObjectAdapter = new ConfigObjectAdapter<BrokerSchema.SubscriptionObject, BrokerSchema.SubscriptionClass, BrokerSchema.SubscriptionDelegate, SubscriptionConfigType, SubscriptionConfig>(SubscriptionConfigType.getInstance(), PACKAGE.getQMFClassInstance(BrokerSchema.SubscriptionClass.class)){

        @Override
        public BrokerSchema.SubscriptionObject createQMFObject(SubscriptionConfig configObject) {
            return (BrokerSchema.SubscriptionObject)this.newInstance(new SubscriptionDelegate(configObject));
        }
    };
    private ConfigObjectAdapter<BrokerSchema.LinkObject, BrokerSchema.LinkClass, BrokerSchema.LinkDelegate, LinkConfigType, LinkConfig> _linkObjectAdapter = new ConfigObjectAdapter<BrokerSchema.LinkObject, BrokerSchema.LinkClass, BrokerSchema.LinkDelegate, LinkConfigType, LinkConfig>(LinkConfigType.getInstance(), PACKAGE.getQMFClassInstance(BrokerSchema.LinkClass.class)){

        @Override
        public BrokerSchema.LinkObject createQMFObject(LinkConfig configObject) {
            return (BrokerSchema.LinkObject)this.newInstance(new LinkDelegate(configObject));
        }
    };
    private ConfigObjectAdapter<BrokerSchema.BridgeObject, BrokerSchema.BridgeClass, BrokerSchema.BridgeDelegate, BridgeConfigType, BridgeConfig> _bridgeObjectAdapter = new ConfigObjectAdapter<BrokerSchema.BridgeObject, BrokerSchema.BridgeClass, BrokerSchema.BridgeDelegate, BridgeConfigType, BridgeConfig>(BridgeConfigType.getInstance(), PACKAGE.getQMFClassInstance(BrokerSchema.BridgeClass.class)){

        @Override
        public BrokerSchema.BridgeObject createQMFObject(BridgeConfig configObject) {
            return (BrokerSchema.BridgeObject)this.newInstance(new BridgeDelegate(configObject));
        }
    };

    public QMFService(ConfigStore configStore, IApplicationRegistry applicationRegistry) {
        this._configStore = configStore;
        this._applicationRegistry = applicationRegistry;
        this.registerSchema(PACKAGE);
        for (ConfigObjectType v : _qmfClassMapping.values()) {
            configStore.addConfigEventListener(v, this);
        }
        this.init();
    }

    @Override
    public void close() {
        for (ConfigObjectType v : _qmfClassMapping.values()) {
            this._configStore.removeConfigEventListener(v, this);
        }
        this._listeners.clear();
        this._managedObjects.clear();
        this._managedObjectsById.clear();
        this._classMap.clear();
        this._adapterMap.clear();
        this._supportedSchemas.clear();
    }

    public void registerSchema(QMFPackage qmfPackage) {
        this._supportedSchemas.put(qmfPackage.getName(), qmfPackage);
    }

    public Collection<QMFPackage> getSupportedSchemas() {
        return this._supportedSchemas.values();
    }

    public QMFPackage getPackage(String aPackage) {
        return this._supportedSchemas.get(aPackage);
    }

    public void onEvent(ConfiguredObject object, ConfigStore.Event evt) {
        switch (evt) {
            case CREATED: {
                this.manageObject(object);
                break;
            }
            case DELETED: {
                this.unmanageObject(object);
            }
        }
    }

    public QMFObject getObjectById(QMFClass qmfclass, UUID id) {
        ConcurrentHashMap<UUID, QMFObject> map = this._managedObjectsById.get(qmfclass);
        if (map != null) {
            return map.get(id);
        }
        return null;
    }

    private void unmanageObject(ConfiguredObject object) {
        QMFObject qmfObject;
        QMFClass qmfClass = this._classMap.get(object.getConfigType());
        if (qmfClass == null) {
            return;
        }
        ConcurrentHashMap<ConfiguredObject, QMFObject> classObjects = this._managedObjects.get(qmfClass);
        if (classObjects != null && (qmfObject = classObjects.remove(object)) != null) {
            this._managedObjectsById.get(qmfClass).remove(object.getId());
            this.objectRemoved(qmfObject);
        }
    }

    private void manageObject(ConfiguredObject object) {
        ConcurrentHashMap classObjectsById;
        ConfigObjectAdapter adapter = this._adapterMap.get(object.getConfigType());
        Object qmfObject = adapter.createQMFObject(object);
        Object qmfClass = ((QMFObject)qmfObject).getQMFClass();
        ConcurrentHashMap classObjects = this._managedObjects.get(qmfClass);
        if (classObjects == null && this._managedObjects.putIfAbsent((QMFClass)qmfClass, classObjects = new ConcurrentHashMap()) != null) {
            classObjects = this._managedObjects.get(qmfClass);
        }
        if ((classObjectsById = this._managedObjectsById.get(qmfClass)) == null && this._managedObjectsById.putIfAbsent((QMFClass)qmfClass, classObjectsById = new ConcurrentHashMap()) != null) {
            classObjectsById = this._managedObjectsById.get(qmfClass);
        }
        classObjectsById.put(object.getId(), (QMFObject)qmfObject);
        if (classObjects.putIfAbsent(object, qmfObject) == null) {
            this.objectAdded((QMFObject)qmfObject);
        }
    }

    private void objectRemoved(QMFObject qmfObject) {
        qmfObject.setDeleteTime();
        for (Listener l : this._listeners) {
            l.objectDeleted(qmfObject);
        }
    }

    private void objectAdded(QMFObject qmfObject) {
        for (Listener l : this._listeners) {
            l.objectCreated(qmfObject);
        }
    }

    public void addListener(Listener l) {
        this._listeners.add(l);
    }

    public void removeListener(Listener l) {
        this._listeners.remove(l);
    }

    private void init() {
        for (QMFClass qmfClass : PACKAGE.getClasses()) {
            ConfigObjectType configType = this.getConfigType(qmfClass);
            if (configType == null) continue;
            Collection objects = this._configStore.getConfiguredObjects(configType);
            for (ConfiguredObject object : objects) {
                this.manageObject(object);
            }
        }
    }

    public Collection<QMFObject> getObjects(QMFClass qmfClass) {
        ConcurrentHashMap<ConfiguredObject, QMFObject> classObjects = this._managedObjects.get(qmfClass);
        if (classObjects != null) {
            return classObjects.values();
        }
        return Collections.EMPTY_SET;
    }

    private QMFObject adapt(ConfiguredObject object) {
        QMFObject qmfObject;
        if (object == null) {
            return null;
        }
        QMFClass qmfClass = this._classMap.get(object.getConfigType());
        ConcurrentHashMap<ConfiguredObject, QMFObject> classObjects = this._managedObjects.get(qmfClass);
        if (classObjects != null && (qmfObject = classObjects.get(object)) != null) {
            return qmfObject;
        }
        return this._adapterMap.get(object.getConfigType()).createQMFObject(object);
    }

    private ConfigObjectType getConfigType(QMFClass qmfClass) {
        return _qmfClassMapping.get(qmfClass.getName());
    }

    static {
        _qmfClassMapping.put("system", SystemConfigType.getInstance());
        _qmfClassMapping.put("broker", BrokerConfigType.getInstance());
        _qmfClassMapping.put("vhost", VirtualHostConfigType.getInstance());
        _qmfClassMapping.put("exchange", ExchangeConfigType.getInstance());
        _qmfClassMapping.put("queue", QueueConfigType.getInstance());
        _qmfClassMapping.put("binding", BindingConfigType.getInstance());
        _qmfClassMapping.put("connection", ConnectionConfigType.getInstance());
        _qmfClassMapping.put("session", SessionConfigType.getInstance());
        _qmfClassMapping.put("subscription", SubscriptionConfigType.getInstance());
        _qmfClassMapping.put("link", LinkConfigType.getInstance());
        _qmfClassMapping.put("bridge", BridgeConfigType.getInstance());
        PACKAGE = BrokerSchema.getPackage();
    }

    private class LinkDelegate
    implements BrokerSchema.LinkDelegate {
        private final LinkConfig _obj;

        private LinkDelegate(LinkConfig obj) {
            this._obj = obj;
        }

        public BrokerSchema.VhostObject getVhostRef() {
            return (BrokerSchema.VhostObject)QMFService.this.adapt(this._obj.getVirtualHost());
        }

        public String getHost() {
            return this._obj.getHost();
        }

        public Integer getPort() {
            return this._obj.getPort();
        }

        public String getTransport() {
            return this._obj.getTransport();
        }

        public Boolean getDurable() {
            return this._obj.isDurable();
        }

        public String getState() {
            return "";
        }

        public String getLastError() {
            return "";
        }

        public BrokerSchema.LinkClass.CloseMethodResponseCommand close(BrokerSchema.LinkClass.CloseMethodResponseCommandFactory factory) {
            this._obj.close();
            return factory.createResponseCommand();
        }

        public BrokerSchema.LinkClass.BridgeMethodResponseCommand bridge(BrokerSchema.LinkClass.BridgeMethodResponseCommandFactory factory, Boolean durable, String src, String dest, String key, String tag, String excludes, Boolean srcIsQueue, Boolean srcIsLocal, Boolean dynamic, Integer sync) {
            this._obj.createBridge(durable, dynamic, srcIsQueue, srcIsLocal, src, dest, key, tag, excludes);
            return factory.createResponseCommand();
        }

        public UUID getId() {
            return this._obj.getId();
        }

        public long getCreateTime() {
            return this._obj.getCreateTime();
        }
    }

    private class BridgeDelegate
    implements BrokerSchema.BridgeDelegate {
        private final BridgeConfig _obj;

        private BridgeDelegate(BridgeConfig obj) {
            this._obj = obj;
        }

        public BrokerSchema.LinkObject getLinkRef() {
            return (BrokerSchema.LinkObject)QMFService.this.adapt(this._obj.getLink());
        }

        public Integer getChannelId() {
            return this._obj.getChannelId();
        }

        public Boolean getDurable() {
            return this._obj.isDurable();
        }

        public String getSrc() {
            return this._obj.getSource();
        }

        public String getDest() {
            return this._obj.getDestination();
        }

        public String getKey() {
            return this._obj.getKey();
        }

        public Boolean getSrcIsQueue() {
            return this._obj.isQueueBridge();
        }

        public Boolean getSrcIsLocal() {
            return this._obj.isLocalSource();
        }

        public String getTag() {
            return this._obj.getTag();
        }

        public String getExcludes() {
            return this._obj.getExcludes();
        }

        public Boolean getDynamic() {
            return this._obj.isDynamic();
        }

        public Integer getSync() {
            return this._obj.getAckBatching();
        }

        public BrokerSchema.BridgeClass.CloseMethodResponseCommand close(BrokerSchema.BridgeClass.CloseMethodResponseCommandFactory factory) {
            return null;
        }

        public UUID getId() {
            return this._obj.getId();
        }

        public long getCreateTime() {
            return this._obj.getCreateTime();
        }
    }

    private class SubscriptionDelegate
    implements BrokerSchema.SubscriptionDelegate {
        private final SubscriptionConfig _obj;

        private SubscriptionDelegate(SubscriptionConfig obj) {
            this._obj = obj;
        }

        public BrokerSchema.SessionObject getSessionRef() {
            return (BrokerSchema.SessionObject)QMFService.this.adapt(this._obj.getSessionConfig());
        }

        public BrokerSchema.QueueObject getQueueRef() {
            return (BrokerSchema.QueueObject)QMFService.this.adapt(this._obj.getQueue());
        }

        public String getName() {
            return this._obj.getName();
        }

        public Boolean getBrowsing() {
            return this._obj.isBrowsing();
        }

        public Boolean getAcknowledged() {
            return this._obj.isExplicitAcknowledge();
        }

        public Boolean getExclusive() {
            return this._obj.isExclusive();
        }

        public String getCreditMode() {
            return this._obj.getCreditMode();
        }

        public Map getArguments() {
            return this._obj.getArguments();
        }

        public Long getDelivered() {
            return this._obj.getDelivered();
        }

        public UUID getId() {
            return this._obj.getId();
        }

        public long getCreateTime() {
            return this._obj.getCreateTime();
        }
    }

    private class SessionDelegate
    implements BrokerSchema.SessionDelegate {
        private final SessionConfig _obj;

        public SessionDelegate(SessionConfig obj) {
            this._obj = obj;
        }

        public BrokerSchema.VhostObject getVhostRef() {
            return (BrokerSchema.VhostObject)QMFService.this.adapt(this._obj.getVirtualHost());
        }

        public String getName() {
            return this._obj.getSessionName();
        }

        public Integer getChannelId() {
            return this._obj.getChannel();
        }

        public BrokerSchema.ConnectionObject getConnectionRef() {
            return (BrokerSchema.ConnectionObject)QMFService.this.adapt(this._obj.getConnectionConfig());
        }

        public Long getDetachedLifespan() {
            return this._obj.getDetachedLifespan();
        }

        public Boolean getAttached() {
            return this._obj.isAttached();
        }

        public Long getExpireTime() {
            return this._obj.getExpiryTime();
        }

        public Long getMaxClientRate() {
            return this._obj.getMaxClientRate();
        }

        public Long getFramesOutstanding() {
            return 0L;
        }

        public Long getTxnStarts() {
            return this._obj.getTxnStarts();
        }

        public Long getTxnCommits() {
            return this._obj.getTxnCommits();
        }

        public Long getTxnRejects() {
            return this._obj.getTxnRejects();
        }

        public Long getTxnCount() {
            return this._obj.getTxnCount();
        }

        public Long getClientCredit() {
            return 0L;
        }

        public BrokerSchema.SessionClass.SolicitAckMethodResponseCommand solicitAck(BrokerSchema.SessionClass.SolicitAckMethodResponseCommandFactory factory) {
            return factory.createResponseCommand(CompletionCode.NOT_IMPLEMENTED);
        }

        public BrokerSchema.SessionClass.DetachMethodResponseCommand detach(BrokerSchema.SessionClass.DetachMethodResponseCommandFactory factory) {
            return factory.createResponseCommand(CompletionCode.NOT_IMPLEMENTED);
        }

        public BrokerSchema.SessionClass.ResetLifespanMethodResponseCommand resetLifespan(BrokerSchema.SessionClass.ResetLifespanMethodResponseCommandFactory factory) {
            return factory.createResponseCommand(CompletionCode.NOT_IMPLEMENTED);
        }

        public BrokerSchema.SessionClass.CloseMethodResponseCommand close(BrokerSchema.SessionClass.CloseMethodResponseCommandFactory factory) {
            try {
                this._obj.mgmtClose();
            }
            catch (AMQException e) {
                return factory.createResponseCommand(CompletionCode.EXCEPTION, e.getMessage());
            }
            return factory.createResponseCommand();
        }

        public UUID getId() {
            return this._obj.getId();
        }

        public long getCreateTime() {
            return this._obj.getCreateTime();
        }
    }

    private class ConnectionDelegate
    implements BrokerSchema.ConnectionDelegate {
        private final ConnectionConfig _obj;

        public ConnectionDelegate(ConnectionConfig obj) {
            this._obj = obj;
        }

        public BrokerSchema.VhostObject getVhostRef() {
            return (BrokerSchema.VhostObject)QMFService.this.adapt(this._obj.getVirtualHost());
        }

        public String getAddress() {
            return this._obj.getAddress();
        }

        public Boolean getIncoming() {
            return this._obj.isIncoming();
        }

        public Boolean getSystemConnection() {
            return this._obj.isSystemConnection();
        }

        public Boolean getFederationLink() {
            return this._obj.isFederationLink();
        }

        public String getAuthIdentity() {
            return this._obj.getAuthId();
        }

        public String getRemoteProcessName() {
            return this._obj.getRemoteProcessName();
        }

        public Long getRemotePid() {
            Integer remotePID = this._obj.getRemotePID();
            return remotePID == null ? null : Long.valueOf(remotePID.intValue());
        }

        public Long getRemoteParentPid() {
            Integer remotePPID = this._obj.getRemoteParentPID();
            return remotePPID == null ? null : Long.valueOf(remotePPID.intValue());
        }

        public Boolean getClosing() {
            return false;
        }

        public Long getFramesFromClient() {
            return 0L;
        }

        public Long getFramesToClient() {
            return 0L;
        }

        public Long getBytesFromClient() {
            return 0L;
        }

        public Long getBytesToClient() {
            return 0L;
        }

        public Long getMsgsFromClient() {
            return 0L;
        }

        public Long getMsgsToClient() {
            return 0L;
        }

        public BrokerSchema.ConnectionClass.CloseMethodResponseCommand close(BrokerSchema.ConnectionClass.CloseMethodResponseCommandFactory factory) {
            this._obj.mgmtClose();
            return factory.createResponseCommand();
        }

        public UUID getId() {
            return this._obj.getId();
        }

        public long getCreateTime() {
            return this._obj.getCreateTime();
        }

        public Boolean getShadow() {
            return this._obj.isShadow();
        }

        public Boolean getUserProxyAuth() {
            return false;
        }
    }

    private class BindingDelegate
    implements BrokerSchema.BindingDelegate {
        private final BindingConfig _obj;

        public BindingDelegate(BindingConfig obj) {
            this._obj = obj;
        }

        public BrokerSchema.ExchangeObject getExchangeRef() {
            return (BrokerSchema.ExchangeObject)QMFService.this.adapt(this._obj.getExchange());
        }

        public BrokerSchema.QueueObject getQueueRef() {
            return (BrokerSchema.QueueObject)QMFService.this.adapt(this._obj.getQueue());
        }

        public String getBindingKey() {
            return this._obj.getBindingKey();
        }

        public Map getArguments() {
            return this._obj.getArguments();
        }

        public String getOrigin() {
            return this._obj.getOrigin();
        }

        public Long getMsgMatched() {
            return this._obj.getMatches();
        }

        public UUID getId() {
            return this._obj.getId();
        }

        public long getCreateTime() {
            return this._obj.getCreateTime();
        }
    }

    private class QueueDelegate
    implements BrokerSchema.QueueDelegate {
        private final QueueConfig _obj;

        public QueueDelegate(QueueConfig obj) {
            this._obj = obj;
        }

        public BrokerSchema.VhostObject getVhostRef() {
            return (BrokerSchema.VhostObject)QMFService.this.adapt(this._obj.getVirtualHost());
        }

        public String getName() {
            return this._obj.getName();
        }

        public Boolean getDurable() {
            return this._obj.isDurable();
        }

        public Boolean getAutoDelete() {
            return this._obj.isAutoDelete();
        }

        public Boolean getExclusive() {
            return this._obj.isExclusive();
        }

        public BrokerSchema.ExchangeObject getAltExchange() {
            if (this._obj.getAlternateExchange() != null) {
                return (BrokerSchema.ExchangeObject)QMFService.this.adapt(this._obj.getAlternateExchange());
            }
            return null;
        }

        public Long getMsgTotalEnqueues() {
            return this._obj.getReceivedMessageCount();
        }

        public Long getMsgTotalDequeues() {
            return this._obj.getMessageDequeueCount();
        }

        public Long getMsgTxnEnqueues() {
            return this._obj.getMsgTxnEnqueues();
        }

        public Long getMsgTxnDequeues() {
            return this._obj.getMsgTxnDequeues();
        }

        public Long getMsgPersistEnqueues() {
            return this._obj.getPersistentMsgEnqueues();
        }

        public Long getMsgPersistDequeues() {
            return this._obj.getPersistentMsgDequeues();
        }

        public Long getMsgDepth() {
            return this._obj.getMessageCount();
        }

        public Long getByteDepth() {
            return this._obj.getQueueDepth();
        }

        public Long getByteTotalEnqueues() {
            return this._obj.getTotalEnqueueSize();
        }

        public Long getByteTotalDequeues() {
            return this._obj.getTotalDequeueSize();
        }

        public Long getByteTxnEnqueues() {
            return this._obj.getByteTxnEnqueues();
        }

        public Long getByteTxnDequeues() {
            return this._obj.getByteTxnDequeues();
        }

        public Long getBytePersistEnqueues() {
            return this._obj.getPersistentByteEnqueues();
        }

        public Long getBytePersistDequeues() {
            return this._obj.getPersistentByteDequeues();
        }

        public Long getConsumerCount() {
            return this._obj.getConsumerCount();
        }

        public Long getConsumerCountHigh() {
            return this._obj.getConsumerCountHigh();
        }

        public Long getConsumerCountLow() {
            return 0L;
        }

        public Long getBindingCount() {
            return this._obj.getBindingCount();
        }

        public Long getBindingCountHigh() {
            return this._obj.getBindingCountHigh();
        }

        public Long getBindingCountLow() {
            return 0L;
        }

        public Long getUnackedMessages() {
            return this._obj.getUnackedMessageCount();
        }

        public Long getUnackedMessagesHigh() {
            return this._obj.getUnackedMessageCountHigh();
        }

        public Long getUnackedMessagesLow() {
            return 0L;
        }

        public Long getMessageLatencySamples() {
            return 0L;
        }

        public Long getMessageLatencyMin() {
            return 0L;
        }

        public Long getMessageLatencyMax() {
            return 0L;
        }

        public Long getMessageLatencyAverage() {
            return 0L;
        }

        public Boolean getFlowStopped() {
            return Boolean.FALSE;
        }

        public Long getFlowStoppedCount() {
            return 0L;
        }

        public BrokerSchema.QueueClass.PurgeMethodResponseCommand purge(BrokerSchema.QueueClass.PurgeMethodResponseCommandFactory factory, Long request) {
            try {
                this._obj.purge(request);
            }
            catch (AMQException e) {
                throw new RuntimeException();
            }
            return factory.createResponseCommand();
        }

        public BrokerSchema.QueueClass.RerouteMethodResponseCommand reroute(BrokerSchema.QueueClass.RerouteMethodResponseCommandFactory factory, Long request, Boolean useAltExchange, String exchange) {
            return factory.createResponseCommand(CompletionCode.NOT_IMPLEMENTED);
        }

        public Map getArguments() {
            return this._obj.getArguments();
        }

        public UUID getId() {
            return this._obj.getId();
        }

        public long getCreateTime() {
            return this._obj.getCreateTime();
        }
    }

    private class ExchangeDelegate
    implements BrokerSchema.ExchangeDelegate {
        private final ExchangeConfig _obj;

        public ExchangeDelegate(ExchangeConfig obj) {
            this._obj = obj;
        }

        public BrokerSchema.VhostObject getVhostRef() {
            return (BrokerSchema.VhostObject)QMFService.this.adapt(this._obj.getVirtualHost());
        }

        public String getName() {
            return this._obj.getName();
        }

        public String getType() {
            return this._obj.getType().getName().toString();
        }

        public Boolean getDurable() {
            return this._obj.isDurable();
        }

        public Boolean getAutoDelete() {
            return this._obj.isAutoDelete();
        }

        public BrokerSchema.ExchangeObject getAltExchange() {
            if (this._obj.getAlternateExchange() != null) {
                return (BrokerSchema.ExchangeObject)QMFService.this.adapt(this._obj.getAlternateExchange());
            }
            return null;
        }

        public Map getArguments() {
            return this._obj.getArguments();
        }

        public Long getProducerCount() {
            return 0L;
        }

        public Long getProducerCountHigh() {
            return 0L;
        }

        public Long getProducerCountLow() {
            return 0L;
        }

        public Long getBindingCount() {
            return this._obj.getBindingCount();
        }

        public Long getBindingCountHigh() {
            return this._obj.getBindingCountHigh();
        }

        public Long getBindingCountLow() {
            return 0L;
        }

        public Long getMsgReceives() {
            return this._obj.getMsgReceives();
        }

        public Long getMsgDrops() {
            return this.getMsgReceives() - this.getMsgRoutes();
        }

        public Long getMsgRoutes() {
            return this._obj.getMsgRoutes();
        }

        public Long getByteReceives() {
            return this._obj.getByteReceives();
        }

        public Long getByteDrops() {
            return this.getByteReceives() - this.getByteRoutes();
        }

        public Long getByteRoutes() {
            return this._obj.getByteRoutes();
        }

        public UUID getId() {
            return this._obj.getId();
        }

        public long getCreateTime() {
            return this._obj.getCreateTime();
        }
    }

    private class VhostDelegate
    implements BrokerSchema.VhostDelegate {
        private final VirtualHostConfig _obj;

        public VhostDelegate(VirtualHostConfig obj) {
            this._obj = obj;
        }

        public BrokerSchema.BrokerObject getBrokerRef() {
            return (BrokerSchema.BrokerObject)QMFService.this.adapt(this._obj.getBroker());
        }

        public String getName() {
            return this._obj.getName();
        }

        public String getFederationTag() {
            return this._obj.getFederationTag();
        }

        public UUID getId() {
            return this._obj.getId();
        }

        public long getCreateTime() {
            return this._obj.getCreateTime();
        }
    }

    private class BrokerDelegate
    implements BrokerSchema.BrokerDelegate {
        private final BrokerConfig _obj;

        public BrokerDelegate(BrokerConfig obj) {
            this._obj = obj;
        }

        public BrokerSchema.SystemObject getSystemRef() {
            return (BrokerSchema.SystemObject)QMFService.this.adapt(this._obj.getSystem());
        }

        public String getName() {
            return "amqp-broker";
        }

        public Integer getPort() {
            return this._obj.getPort();
        }

        public Integer getWorkerThreads() {
            return this._obj.getWorkerThreads();
        }

        public Integer getMaxConns() {
            return this._obj.getMaxConnections();
        }

        public Integer getConnBacklog() {
            return this._obj.getConnectionBacklogLimit();
        }

        public Long getStagingThreshold() {
            return this._obj.getStagingThreshold();
        }

        public Integer getMgmtPubInterval() {
            return this._obj.getManagementPublishInterval();
        }

        public String getVersion() {
            return this._obj.getVersion();
        }

        public String getDataDir() {
            return this._obj.getDataDirectory();
        }

        public Long getUptime() {
            return (System.currentTimeMillis() - this._obj.getCreateTime()) * 1000000L;
        }

        public BrokerSchema.BrokerClass.EchoMethodResponseCommand echo(BrokerSchema.BrokerClass.EchoMethodResponseCommandFactory factory, Long sequence, String body) {
            return factory.createResponseCommand(sequence, body);
        }

        public BrokerSchema.BrokerClass.ConnectMethodResponseCommand connect(BrokerSchema.BrokerClass.ConnectMethodResponseCommandFactory factory, String host, Long port, Boolean durable, String authMechanism, String username, String password, String transport) {
            this._obj.createBrokerConnection(transport, host, port.intValue(), durable, authMechanism, username, password);
            return factory.createResponseCommand();
        }

        public BrokerSchema.BrokerClass.QueueMoveMessagesMethodResponseCommand queueMoveMessages(BrokerSchema.BrokerClass.QueueMoveMessagesMethodResponseCommandFactory factory, String srcQueue, String destQueue, Long qty) {
            return factory.createResponseCommand(CompletionCode.NOT_IMPLEMENTED);
        }

        public BrokerSchema.BrokerClass.GetLogLevelMethodResponseCommand getLogLevel(BrokerSchema.BrokerClass.GetLogLevelMethodResponseCommandFactory factory) {
            return factory.createResponseCommand(CompletionCode.NOT_IMPLEMENTED);
        }

        public BrokerSchema.BrokerClass.SetLogLevelMethodResponseCommand setLogLevel(BrokerSchema.BrokerClass.SetLogLevelMethodResponseCommandFactory factory, String level) {
            return factory.createResponseCommand(CompletionCode.NOT_IMPLEMENTED);
        }

        public BrokerSchema.BrokerClass.CreateMethodResponseCommand create(BrokerSchema.BrokerClass.CreateMethodResponseCommandFactory factory, String type, String name, Map properties, Boolean lenient) {
            return factory.createResponseCommand(CompletionCode.NOT_IMPLEMENTED);
        }

        public BrokerSchema.BrokerClass.DeleteMethodResponseCommand delete(BrokerSchema.BrokerClass.DeleteMethodResponseCommandFactory factory, String type, String name, Map options) {
            return factory.createResponseCommand(CompletionCode.NOT_IMPLEMENTED);
        }

        public UUID getId() {
            return this._obj.getId();
        }

        public long getCreateTime() {
            return this._obj.getCreateTime();
        }
    }

    private static class SystemDelegate
    implements BrokerSchema.SystemDelegate {
        private final SystemConfig _obj;

        public SystemDelegate(SystemConfig obj) {
            this._obj = obj;
        }

        public UUID getSystemId() {
            return this._obj.getId();
        }

        public String getOsName() {
            return this._obj.getOperatingSystemName();
        }

        public String getNodeName() {
            return this._obj.getNodeName();
        }

        public String getRelease() {
            return this._obj.getOSRelease();
        }

        public String getVersion() {
            return this._obj.getOSVersion();
        }

        public String getMachine() {
            return this._obj.getOSArchitecture();
        }

        public UUID getId() {
            return this._obj.getId();
        }

        public long getCreateTime() {
            return this._obj.getCreateTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ConfigObjectAdapter<Q extends QMFObject<S, D>, S extends QMFObjectClass<Q, D>, D extends QMFObject.Delegate, T extends ConfigObjectType<T, C>, C extends ConfiguredObject<T, C>> {
        private final T _type;
        private final S _qmfClass;
        final /* synthetic */ QMFService this$0;

        protected ConfigObjectAdapter(T type, S qmfClass) {
            this.this$0 = var1_1;
            this._type = type;
            this._qmfClass = qmfClass;
            ((QMFService)var1_1)._adapterMap.put(type, this);
            ((QMFService)var1_1)._classMap.put(type, qmfClass);
        }

        public T getType() {
            return this._type;
        }

        public S getQMFClass() {
            return this._qmfClass;
        }

        protected final Q newInstance(D delegate) {
            return (Q)((QMFObjectClass)this._qmfClass).newInstance(delegate);
        }

        public abstract Q createQMFObject(C var1);
    }

    public static interface Listener {
        public void objectCreated(QMFObject var1);

        public void objectDeleted(QMFObject var1);
    }
}

