/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.qmf;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.wso2.andes.qmf.QMFMethodInvocation;
import org.wso2.andes.qmf.QMFObject;
import org.wso2.andes.qmf.QMFType;
import org.wso2.andes.transport.codec.BBDecoder;
import org.wso2.andes.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QMFMethod<T extends QMFObject> {
    private final LinkedHashMap<String, Object> _map = new LinkedHashMap();
    private final List<Argument> _arguments = new ArrayList<Argument>();
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String REF_PACKAGE = "refPackage";
    private static final String REF_CLASS = "refClass";
    private static final String UNIT = "unit";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String MAX_LENGTH = "maxlen";
    private static final String DESCRIPTION = "desc";
    private static final String DEFAULT = "default";
    private static final String DIRECTION = "dir";
    private static final String ARG_COUNT = "argCount";

    public QMFMethod(String name, String description) {
        this._map.put(NAME, name);
        this._map.put(ARG_COUNT, 0);
        if (description != null) {
            this._map.put(DESCRIPTION, description);
        }
    }

    public abstract QMFMethodInvocation<T> parse(BBDecoder var1);

    protected void addArgument(Argument arg) {
        this._arguments.add(arg);
        this._map.put(ARG_COUNT, this._arguments.size());
    }

    public void encode(Encoder encoder) {
        encoder.writeMap(this._map);
        for (Argument arg : this._arguments) {
            arg.encode(encoder);
        }
    }

    public String getName() {
        return (String)this._map.get(NAME);
    }

    public class Argument {
        private final LinkedHashMap<String, Object> _map = new LinkedHashMap();

        public Argument(String name, QMFType type) {
            this._map.put(QMFMethod.NAME, name);
            this._map.put(QMFMethod.TYPE, type.codeValue());
        }

        public void setRefPackage(String refPackage) {
            this._map.put(QMFMethod.REF_PACKAGE, refPackage);
        }

        public void setRefClass(String refClass) {
            this._map.put(QMFMethod.REF_CLASS, refClass);
        }

        public void setUnit(String unit) {
            this._map.put(QMFMethod.UNIT, unit);
        }

        public void setMax(Number max) {
            this._map.put(QMFMethod.MAX, max);
        }

        public void setMin(Number min) {
            this._map.put(QMFMethod.MIN, min);
        }

        public void setMaxLength(int len) {
            this._map.put(QMFMethod.MAX_LENGTH, len);
        }

        public void setDefault(Object dflt) {
            this._map.put(QMFMethod.DEFAULT, dflt);
        }

        public void setDescription(String desc) {
            this._map.put(QMFMethod.DESCRIPTION, desc);
        }

        public void setDirection(Direction direction) {
            this._map.put(QMFMethod.DIRECTION, direction.toString());
        }

        public void encode(Encoder encoder) {
            encoder.writeMap(this._map);
        }

        public String getName() {
            return (String)this._map.get(QMFMethod.NAME);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        I,
        O,
        IO;

    }
}

