/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.management.common.sasl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class PlainSaslClient
implements SaslClient {
    private boolean completed = false;
    private CallbackHandler cbh;
    private String authorizationID;
    private String authenticationID;
    private byte[] password;
    private static byte SEPARATOR = 0;

    public PlainSaslClient(String authorizationID, CallbackHandler cbh) throws SaslException {
        this.cbh = cbh;
        Object[] userInfo = this.getUserInfo();
        this.authorizationID = authorizationID;
        this.authenticationID = (String)userInfo[0];
        this.password = (byte[])userInfo[1];
        if (this.authenticationID == null || this.password == null) {
            throw new SaslException("PLAIN: authenticationID and password must be specified");
        }
    }

    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN: authentication already completed");
        }
        this.completed = true;
        try {
            byte[] authzid = this.authorizationID == null ? null : this.authorizationID.getBytes("UTF8");
            byte[] authnid = this.authenticationID.getBytes("UTF8");
            byte[] response = new byte[this.password.length + authnid.length + 2 + (authzid != null ? authzid.length : 0)];
            int size = 0;
            if (authzid != null) {
                System.arraycopy(authzid, 0, response, 0, authzid.length);
                size = authzid.length;
            }
            response[size++] = SEPARATOR;
            System.arraycopy(authnid, 0, response, size, authnid.length);
            size += authnid.length;
            response[size++] = SEPARATOR;
            System.arraycopy(this.password, 0, response, size, this.password.length);
            this.clearPassword();
            return response;
        }
        catch (UnsupportedEncodingException e) {
            throw new SaslException("PLAIN: Cannot get UTF-8 encoding of ids", e);
        }
    }

    public String getMechanismName() {
        return "PLAIN";
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN: this mechanism supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN: authentication not completed");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN: this mechanism supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN: authentication not completed");
    }

    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            if (propName.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new IllegalStateException("PLAIN: authentication not completed");
    }

    private void clearPassword() {
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 0;
            }
            this.password = null;
        }
    }

    public void dispose() throws SaslException {
        this.clearPassword();
    }

    protected void finalize() {
        this.clearPassword();
    }

    private Object[] getUserInfo() throws SaslException {
        try {
            byte[] pwbytes;
            String userPrompt = "PLAIN authentication id: ";
            String pwPrompt = "PLAIN password: ";
            NameCallback nameCb = new NameCallback("PLAIN authentication id: ");
            PasswordCallback passwordCb = new PasswordCallback("PLAIN password: ", false);
            this.cbh.handle(new Callback[]{nameCb, passwordCb});
            String userid = nameCb.getName();
            char[] pwchars = passwordCb.getPassword();
            if (pwchars != null) {
                pwbytes = new String(pwchars).getBytes("UTF8");
                passwordCb.clearPassword();
            } else {
                pwbytes = null;
            }
            return new Object[]{userid, pwbytes};
        }
        catch (IOException e) {
            throw new SaslException("Cannot get password", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Cannot get userid/password", e);
        }
    }
}

