/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ExchangeBoundBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_8_0.AMQMethodBody_8_0;
import org.wso2.andes.framing.amqp_8_0.MethodDispatcher_8_0;

public class ExchangeBoundBodyImpl
extends AMQMethodBody_8_0
implements ExchangeBoundBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new ExchangeBoundBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 40;
    public static final int METHOD_ID = 22;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final AMQShortString _queue;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ExchangeBoundBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
        this._queue = this.readAMQShortString(buffer);
    }

    public ExchangeBoundBodyImpl(AMQShortString exchange, AMQShortString routingKey, AMQShortString queue) {
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._queue = queue;
    }

    public int getClazz() {
        return 40;
    }

    public int getMethod() {
        return 22;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._routingKey);
        return size += this.getSizeOf(this._queue);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeAMQShortString(buffer, this._queue);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchExchangeBound(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ExchangeBoundBodyImpl: ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append("]");
        return buf.toString();
    }
}

