/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.cluster.mgt.internal.registry;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.wso2.carbon.andes.cluster.mgt.NodeDetail;
import org.wso2.carbon.andes.cluster.mgt.Queue;
import org.wso2.carbon.andes.cluster.mgt.Topic;
import org.wso2.carbon.andes.cluster.mgt.internal.ClusterMgtException;

public class ClusterManagementBeans {
    public String getZookeeperAddressAndPort() throws ClusterMgtException {
        String result = "";
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=127.0.0.1");
            Object MBeanResultForPort = mBeanServer.getAttribute(objectName, "ZkServerPort");
            Object MBeanResultForAddress = mBeanServer.getAttribute(objectName, "ZkServerAddress");
            if (MBeanResultForPort != null && MBeanResultForAddress != null) {
                int ZkPort = (Integer)MBeanResultForPort;
                String ZkAddress = (String)MBeanResultForAddress;
                result = ZkAddress + ":" + ZkPort;
            }
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterMgtException("Cannot find the MBean for Zookeeper Port and Address");
        }
        catch (InstanceNotFoundException e) {
            result = "Cannot receive information";
            return result;
        }
        catch (ReflectionException e) {
            throw new ClusterMgtException("Cannot find the MBean for Zookeeper Port and Address");
        }
        catch (AttributeNotFoundException e) {
            throw new ClusterMgtException("Cannot find the MBean for Zookeeper Port and Address");
        }
        catch (MBeanException e) {
            throw new ClusterMgtException("Cannot find the MBean for Zookeeper Port and Address");
        }
        return result;
    }

    public String getCassandraAddressAndPort() {
        return "";
    }

    public ArrayList<NodeDetail> getNodesWithZookeeperID() throws ClusterMgtException {
        ArrayList<NodeDetail> nodeDetailsList = new ArrayList<NodeDetail>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=ClusterManagementInformation");
            Object result = mBeanServer.getAttribute(objectName, "ZkNodes");
            if (result != null) {
                List ZkIDList = (List)result;
                for (Integer zKID : ZkIDList) {
                    String zKIDString = Integer.toString(zKID);
                    NodeDetail aNodeDetail = new NodeDetail();
                    aNodeDetail.setZookeeperID(zKIDString);
                    aNodeDetail.setHostName(zKIDString);
                    aNodeDetail.setNumOfQueues(this.getQueuesRunningInNode(zKIDString).size());
                    aNodeDetail.setNumOfTopics(this.getTopicList().size());
                    nodeDetailsList.add(aNodeDetail);
                }
            }
            return nodeDetailsList;
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterMgtException("Cannot access Zookeeper nodes");
        }
        catch (InstanceNotFoundException e) {
            throw new ClusterMgtException("Cannot access Zookeeper nodes");
        }
        catch (ReflectionException e) {
            throw new ClusterMgtException("Cannot access Zookeeper nodes");
        }
        catch (AttributeNotFoundException e) {
            throw new ClusterMgtException("Cannot access Zookeeper nodes");
        }
        catch (MBeanException e) {
            throw new ClusterMgtException("Cannot access Zookeeper nodes");
        }
    }

    public ArrayList<Topic> getTopicList() throws ClusterMgtException {
        ArrayList<Topic> topicDetailsList = new ArrayList<Topic>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=ClusterManagementInformation");
            Object result = mBeanServer.getAttribute(objectName, "Topics");
            if (result != null) {
                List TopicNamesList = (List)result;
                for (String topicName : TopicNamesList) {
                    Topic aTopic = new Topic();
                    aTopic.setName(topicName);
                    aTopic.setNumberOfSubscribers(this.getNumOfSubscribersForTopic(topicName));
                    topicDetailsList.add(aTopic);
                }
            }
            return topicDetailsList;
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterMgtException("Cannot access topic information");
        }
        catch (InstanceNotFoundException e) {
            throw new ClusterMgtException("Cannot access topic information");
        }
        catch (ReflectionException e) {
            throw new ClusterMgtException("Cannot access topic information");
        }
        catch (AttributeNotFoundException e) {
            throw new ClusterMgtException("Cannot access topic information");
        }
        catch (MBeanException e) {
            throw new ClusterMgtException("Cannot access topic information");
        }
    }

    public ArrayList<Queue> getQueuesRunningInNode(String nodeName) throws ClusterMgtException {
        int nodeId = Integer.parseInt(nodeName);
        ArrayList<Queue> queueDetailsList = new ArrayList<Queue>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=ClusterManagementInformation");
            String operationName = "getQueues";
            Object[] parameters = new Object[]{nodeId};
            String[] signature = new String[]{Integer.TYPE.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (result != null) {
                String[] queueNamesArray;
                for (String queueName : queueNamesArray = (String[])result) {
                    Queue aQueue = new Queue();
                    aQueue.setQueueName(queueName);
                    aQueue.setMessageCount(this.getNumberOfAllMessagesForQueue(queueName));
                    queueDetailsList.add(aQueue);
                }
            }
            return queueDetailsList;
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterMgtException("Cannot access topic subscriber information");
        }
        catch (ReflectionException e) {
            throw new ClusterMgtException("Cannot access topic subscriber information");
        }
        catch (MBeanException e) {
            throw new ClusterMgtException("Cannot access topic subscriber information");
        }
        catch (InstanceNotFoundException e) {
            throw new ClusterMgtException("Cannot access topic subscriber information for node");
        }
    }

    public int getNumOfSubscribersForTopic(String topicName) throws ClusterMgtException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=ClusterManagementInformation");
            String operationName = "getSubscriberCount";
            Object[] parameters = new Object[]{topicName};
            String[] signature = new String[]{String.class.getName()};
            int numberOfSubscribers = (Integer)mBeanServer.invoke(objectName, operationName, parameters, signature);
            return numberOfSubscribers;
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterMgtException("Cannot access topic subscriber information");
        }
        catch (ReflectionException e) {
            throw new ClusterMgtException("Cannot access topic subscriber information");
        }
        catch (MBeanException e) {
            throw new ClusterMgtException("Cannot access topic subscriber information");
        }
        catch (InstanceNotFoundException e) {
            throw new ClusterMgtException("Cannot access topic subscriber information");
        }
    }

    public int getNumberOfAllMessagesForQueue(String queueName) throws ClusterMgtException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=ClusterManagementInformation");
            String operationName = "getMessageCount";
            Object[] parameters = new Object[]{queueName};
            String[] signature = new String[]{String.class.getName()};
            int numberOfMessages = (Integer)mBeanServer.invoke(objectName, operationName, parameters, signature);
            return numberOfMessages;
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterMgtException("Cannot access queue information");
        }
        catch (ReflectionException e) {
            throw new ClusterMgtException("Cannot access queue information");
        }
        catch (MBeanException e) {
            throw new ClusterMgtException("Cannot access queue information");
        }
        catch (InstanceNotFoundException e) {
            throw new ClusterMgtException("Cannot access queue information");
        }
    }
}

