/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.cluster.mgt;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.cluster.mgt.ClusterMgtAdminException;
import org.wso2.carbon.andes.cluster.mgt.NodeDetail;
import org.wso2.carbon.andes.cluster.mgt.Queue;
import org.wso2.carbon.andes.cluster.mgt.Topic;
import org.wso2.carbon.andes.cluster.mgt.internal.ClusterManagementDataHolder;
import org.wso2.carbon.andes.cluster.mgt.internal.registry.ClusterManagementBeans;

public class ClusterManagerService {
    private static final Log log = LogFactory.getLog(ClusterManagerService.class);

    public int getNumOfNodes() throws ClusterMgtAdminException {
        try {
            ClusterManagementBeans clusterManagementBeans = new ClusterManagementBeans();
            ArrayList<NodeDetail> nodeDetailList = clusterManagementBeans.getNodesWithZookeeperID();
            return nodeDetailList.size();
        }
        catch (Exception e) {
            throw new ClusterMgtAdminException("cannot access MBean information for node detail");
        }
    }

    public Queue[] getAllQueuesForNode(String hostName, int startingIndex, int maxQueueCount) throws ClusterMgtAdminException {
        try {
            int resultSetSize = maxQueueCount;
            ClusterManagementBeans clusterManagementBeans = new ClusterManagementBeans();
            ArrayList<Queue> resultList = clusterManagementBeans.getQueuesRunningInNode(hostName);
            if (resultList.size() - startingIndex < maxQueueCount) {
                resultSetSize = resultList.size() - startingIndex;
            }
            Queue[] queueDetailsArray = new Queue[resultSetSize];
            int index = 0;
            int queueDetailsIndex = 0;
            for (Queue queueDetail : resultList) {
                if (startingIndex == index || startingIndex < index) {
                    queueDetailsArray[queueDetailsIndex] = new Queue();
                    queueDetailsArray[queueDetailsIndex].setQueueName(queueDetail.getQueueName());
                    queueDetailsArray[queueDetailsIndex].setMessageCount(queueDetail.getMessageCount());
                    if (++queueDetailsIndex == maxQueueCount) break;
                }
                ++index;
            }
            return queueDetailsArray;
        }
        catch (Exception e) {
            throw new ClusterMgtAdminException("Can not get the queue manager ", e);
        }
    }

    public Topic[] getAllTopicsForNode(int startingIndex, int maxTopicCount) throws ClusterMgtAdminException {
        try {
            ClusterManagementBeans clusterManagementBeans = new ClusterManagementBeans();
            ArrayList<Topic> temp = clusterManagementBeans.getTopicList();
            int resultSetSize = maxTopicCount;
            if (temp.size() - startingIndex < maxTopicCount) {
                resultSetSize = temp.size() - startingIndex;
            }
            Topic[] topicDetailsArray = new Topic[resultSetSize];
            int index = 0;
            int topicDetailDetailsIndex = 0;
            for (Topic topicDetail : temp) {
                if (startingIndex == index || startingIndex < index) {
                    topicDetailsArray[topicDetailDetailsIndex] = new Topic();
                    topicDetailsArray[topicDetailDetailsIndex].setNumberOfSubscribers(topicDetail.getNumberOfSubscribers());
                    topicDetailsArray[topicDetailDetailsIndex].setName(topicDetail.getName());
                    if (++topicDetailDetailsIndex == maxTopicCount) break;
                }
                ++index;
            }
            return topicDetailsArray;
        }
        catch (Exception e) {
            throw new ClusterMgtAdminException("Can not access MBean information for topics ", e);
        }
    }

    public NodeDetail[] getAllNodeDetail(int startingIndex, int maxNodesCount) throws ClusterMgtAdminException {
        try {
            ClusterManagementBeans clusterManagementBeans = new ClusterManagementBeans();
            ArrayList<NodeDetail> nodeDetailList = clusterManagementBeans.getNodesWithZookeeperID();
            int resultSetSize = maxNodesCount;
            if (nodeDetailList.size() - startingIndex < maxNodesCount) {
                resultSetSize = nodeDetailList.size() - startingIndex;
            }
            NodeDetail[] nodeDetailArray = new NodeDetail[resultSetSize];
            int index = 0;
            int nodeDetailsIndex = 0;
            for (NodeDetail nodeDetail : nodeDetailList) {
                if (startingIndex == index || startingIndex < index) {
                    nodeDetailArray[nodeDetailsIndex] = new NodeDetail();
                    nodeDetailArray[nodeDetailsIndex].setHostName(nodeDetail.getHostName());
                    nodeDetailArray[nodeDetailsIndex].setIpAddress(nodeDetail.getIpAddress());
                    nodeDetailArray[nodeDetailsIndex].setNodeId(nodeDetail.getNodeId());
                    nodeDetailArray[nodeDetailsIndex].setZookeeperID(nodeDetail.getZookeeperID());
                    nodeDetailArray[nodeDetailsIndex].setMessagesReceivedLastFiveMin(nodeDetail.getMessagesReceivedLastFiveMin());
                    nodeDetailArray[nodeDetailsIndex].setMessagesReceivedLastHalfMin(nodeDetail.getMessagesReceivedLastHalfMin());
                    nodeDetailArray[nodeDetailsIndex].setMessagesReceivedLastHour(nodeDetail.getMessagesReceivedLastHour());
                    nodeDetailArray[nodeDetailsIndex].setMemoryUsage(nodeDetail.getMemoryUsage());
                    nodeDetailArray[nodeDetailsIndex].setNumOfQueues(nodeDetail.getNumOfQueues());
                    nodeDetailArray[nodeDetailsIndex].setNumOfTopics(nodeDetail.getNumOfTopics());
                    if (++nodeDetailsIndex == maxNodesCount) break;
                }
                ++index;
            }
            return nodeDetailArray;
        }
        catch (Exception e) {
            throw new ClusterMgtAdminException("Can not access MBean information for nodes", e);
        }
    }

    public long getThroughputForNode(String hostname) throws ClusterMgtAdminException {
        return 0L;
    }

    public long getMemoryUsage(String hostname) throws ClusterMgtAdminException {
        return 0L;
    }

    public long getNumberOfTopics() throws ClusterMgtAdminException {
        try {
            long result = 0L;
            ClusterManagementBeans clusterManagementBeans = new ClusterManagementBeans();
            ArrayList<Topic> topicList = clusterManagementBeans.getTopicList();
            result = topicList.size();
            return result;
        }
        catch (Exception e) {
            throw new ClusterMgtAdminException("Cannot access MBean information for topics");
        }
    }

    public long getNumberOfQueues(String hostName) throws ClusterMgtAdminException {
        try {
            long result = 0L;
            ClusterManagementBeans clusterManagementBeans = new ClusterManagementBeans();
            result = clusterManagementBeans.getQueuesRunningInNode(hostName).size();
            return result;
        }
        catch (Exception e) {
            throw new ClusterMgtAdminException("Cannot get the queue manager ", e);
        }
    }

    public long getNumberofSubscriptionsForTopic(String topicName) throws ClusterMgtAdminException {
        try {
            long numOfSubscribers = 0L;
            ClusterManagementBeans clusterManagementBeans = new ClusterManagementBeans();
            numOfSubscribers = clusterManagementBeans.getNumOfSubscribersForTopic(topicName);
            return numOfSubscribers;
        }
        catch (Exception e) {
            throw new ClusterMgtAdminException("Cannot access MBean information for topics", e);
        }
    }

    public long getNumberOfMessagesForQueue(String queueName) throws ClusterMgtAdminException {
        try {
            long numOfMessages = 0L;
            ClusterManagementBeans clusterManagementBeans = new ClusterManagementBeans();
            numOfMessages = clusterManagementBeans.getNumberOfAllMessagesForQueue(queueName);
            return numOfMessages;
        }
        catch (Exception e) {
            throw new ClusterMgtAdminException("Cannot access MBean information for queues", e);
        }
    }

    public String getCassandraConnection() throws ClusterMgtAdminException {
        return ClusterManagementDataHolder.getClusterManagementDataHolder().getQpidService().getCassandraConnectionString();
    }

    public String getZookeeperConnection() throws ClusterMgtAdminException {
        return ClusterManagementDataHolder.getClusterManagementDataHolder().getQpidService().getZookeeperConnectionString();
    }

    public boolean updateWorkerForQueue(String queueToUpdate, String newNodeToAssign) {
        return true;
    }
}

