/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authorization.service.andes;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.wso2.andes.server.configuration.plugins.ConfigurationPlugin;
import org.wso2.andes.server.security.AbstractPlugin;
import org.wso2.andes.server.security.Result;
import org.wso2.andes.server.security.SecurityManager;
import org.wso2.andes.server.security.SecurityPluginFactory;
import org.wso2.andes.server.security.access.ObjectProperties;
import org.wso2.andes.server.security.access.ObjectType;
import org.wso2.andes.server.security.access.Operation;
import org.wso2.carbon.andes.authorization.andes.QpidAuthorizationHandler;
import org.wso2.carbon.andes.authorization.internal.AuthorizationServiceDataHolder;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class QpidAuthorizationPlugin
extends AbstractPlugin {
    private static final Logger logger = Logger.getLogger(QpidAuthorizationPlugin.class);
    private static final String DOMAIN_NAME_SEPARATOR = "!";
    public static final SecurityPluginFactory<QpidAuthorizationPlugin> FACTORY = new SecurityPluginFactory<QpidAuthorizationPlugin>(){

        public QpidAuthorizationPlugin newInstance(ConfigurationPlugin config) throws ConfigurationException {
            QpidAuthorizationPlugin plugin = new QpidAuthorizationPlugin();
            return plugin;
        }

        public String getPluginName() {
            return QpidAuthorizationPlugin.class.getName();
        }

        public Class<QpidAuthorizationPlugin> getPluginClass() {
            return QpidAuthorizationPlugin.class;
        }
    };

    public Result access(ObjectType objectType, Object instance) {
        try {
            Subject subject = SecurityManager.getThreadSubject();
            Principal principal = (Principal)subject.getPrincipals().toArray()[0];
            if (principal == null) {
                return this.getDefault();
            }
            if (objectType == ObjectType.VIRTUALHOST) {
                return Result.ALLOWED;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Result.DENIED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result authorise(Operation operation, ObjectType objectType, ObjectProperties properties) {
        try {
            SuperTenantCarbonContext.startTenantFlow();
            switch (operation) {
                case UNBIND: {
                    Result result = QpidAuthorizationHandler.handleUnbindQueue(properties);
                    return result;
                }
                case DELETE: {
                    if (ObjectType.EXCHANGE == objectType) {
                        Result result = Result.ALLOWED;
                        return result;
                    }
                    if (ObjectType.QUEUE != objectType) break;
                    Result result = QpidAuthorizationHandler.handleDeleteQueue(properties);
                    return result;
                }
            }
            Subject subject = SecurityManager.getThreadSubject();
            Principal principal = null;
            if (subject != null) {
                principal = (Principal)subject.getPrincipals().toArray()[0];
            }
            if (principal == null) {
                Result result = this.getDefault();
                return result;
            }
            String username = principal.getName();
            UserRealm userRealm = QpidAuthorizationPlugin.getUserRealm(username);
            if (username.indexOf(DOMAIN_NAME_SEPARATOR) > -1) {
                String tenantDomain = username.substring(username.indexOf(DOMAIN_NAME_SEPARATOR) + 1);
                SuperTenantCarbonContext.getCurrentContext().setTenantDomain(tenantDomain);
                SuperTenantCarbonContext.getCurrentContext().getTenantId(true);
            } else {
                SuperTenantCarbonContext.getCurrentContext().setTenantId(0);
            }
            int domainNameSeparatorIndex = username.indexOf(DOMAIN_NAME_SEPARATOR);
            if (-1 != domainNameSeparatorIndex) {
                username = username.substring(0, domainNameSeparatorIndex);
            }
            switch (operation) {
                case CREATE: {
                    if (ObjectType.EXCHANGE == objectType) {
                        Result result = Result.ALLOWED;
                        return result;
                    }
                    if (ObjectType.QUEUE == objectType) {
                        Result result = QpidAuthorizationHandler.handleCreateQueue(username, userRealm, properties);
                        return result;
                    }
                }
                case BIND: {
                    Result result = QpidAuthorizationHandler.handleBindQueue(username, userRealm, properties);
                    return result;
                }
                case PUBLISH: {
                    Result result = QpidAuthorizationHandler.handlePublishToExchange(username, userRealm, properties);
                    return result;
                }
                case CONSUME: {
                    Result result = QpidAuthorizationHandler.handleConsumeQueue(username, userRealm, properties);
                    return result;
                }
            }
            return Result.DENIED;
        }
        catch (Exception e) {
            logger.error((Object)"Error while invoking QpidAuthorizationHandler", (Throwable)e);
            return Result.DENIED;
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    private String getRawQueueName(String queueName) {
        return queueName.substring(queueName.indexOf(":") + 1, queueName.length());
    }

    private static UserRealm getUserRealm(String username) {
        UserRealm userRealm = null;
        RealmService realmService = AuthorizationServiceDataHolder.getInstance().getRealmService();
        if (null != realmService) {
            try {
                int tenantID = -1234;
                int domainNameSeparatorIndex = username.indexOf(DOMAIN_NAME_SEPARATOR);
                if (-1 != domainNameSeparatorIndex) {
                    String domainName = username.substring(domainNameSeparatorIndex + 1);
                    tenantID = realmService.getTenantManager().getTenantId(domainName);
                }
                userRealm = realmService.getTenantUserRealm(tenantID);
            }
            catch (UserStoreException e) {
                logger.warn((Object)("Error while getting tenant user realm for user " + username));
            }
            catch (NullPointerException e) {
                logger.error((Object)("Error while accessing the realm service : " + e.getMessage()));
            }
        }
        return userRealm;
    }
}

