/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authorization.andes;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.server.security.Result;
import org.wso2.andes.server.security.access.ObjectProperties;
import org.wso2.carbon.andes.authorization.andes.QpidAuthorizationHandlerException;
import org.wso2.carbon.andes.commons.CommonsUtil;
import org.wso2.carbon.andes.commons.registry.RegistryClient;
import org.wso2.carbon.andes.commons.registry.RegistryClientException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.authorization.TreeNode;

public class QpidAuthorizationHandler {
    private static final Log log = LogFactory.getLog(QpidAuthorizationHandler.class);
    private static final String DEFAULT_EXCHANGE = "default";
    private static final String DIRECT_EXCHANGE = "amq.direct";
    private static final String TOPIC_EXCHANGE = "amq.topic";
    private static final String PERMISSION_CHANGE_PERMISSION = "changePermission";
    private static final String ADMIN_ROLE = "admin";
    private static final String AT_REPLACE_CHAR = "_";

    public static Result handleCreateQueue(String username, UserRealm userRealm, ObjectProperties properties) throws QpidAuthorizationHandlerException {
        try {
            if (null != userRealm) {
                String queueName = QpidAuthorizationHandler.getRawQueueName((String)properties.get((Object)ObjectProperties.Property.NAME));
                String newQname = queueName.replace("@", AT_REPLACE_CHAR);
                RegistryClient.createQueue((String)newQname, (String)username);
                String queueID = CommonsUtil.getQueueID((String)queueName);
                userRealm.getAuthorizationManager().authorizeUser(username, queueID, TreeNode.Permission.CONSUME.toString().toLowerCase());
                userRealm.getAuthorizationManager().authorizeUser(username, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase());
                userRealm.getAuthorizationManager().authorizeUser(username, queueID, PERMISSION_CHANGE_PERMISSION);
                return Result.ALLOWED;
            }
        }
        catch (RegistryClientException e) {
            throw new QpidAuthorizationHandlerException(e);
        }
        catch (UserStoreException e) {
            throw new QpidAuthorizationHandlerException(e);
        }
        return Result.DENIED;
    }

    public static Result handleConsumeQueue(String username, UserRealm userRealm, ObjectProperties properties) throws QpidAuthorizationHandlerException {
        try {
            if (null != userRealm) {
                String queueName = QpidAuthorizationHandler.getRawQueueName((String)properties.get((Object)ObjectProperties.Property.NAME));
                String queueID = CommonsUtil.getQueueID((String)queueName);
                if (QpidAuthorizationHandler.isAdminUser(username, userRealm)) {
                    return Result.ALLOWED;
                }
                if (userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.CONSUME.toString().toLowerCase())) {
                    return Result.ALLOWED;
                }
            }
        }
        catch (UserStoreException e) {
            throw new QpidAuthorizationHandlerException(e);
        }
        return Result.DENIED;
    }

    public static Result handleBindQueue(String username, UserRealm userRealm, ObjectProperties properties) throws QpidAuthorizationHandlerException {
        try {
            if (null != userRealm) {
                String exchangeName = QpidAuthorizationHandler.getRawExchangeName((String)properties.get((Object)ObjectProperties.Property.NAME));
                String queueName = QpidAuthorizationHandler.getRawQueueName((String)properties.get((Object)ObjectProperties.Property.QUEUE_NAME));
                String routingKey = QpidAuthorizationHandler.getRawRoutingKey((String)properties.get((Object)ObjectProperties.Property.ROUTING_KEY));
                if (DEFAULT_EXCHANGE.equals(exchangeName)) {
                    String queueID = CommonsUtil.getQueueID((String)queueName);
                    if (QpidAuthorizationHandler.isAdminUser(username, userRealm)) {
                        return Result.ALLOWED;
                    }
                    if (userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.CONSUME.toString().toLowerCase())) {
                        return Result.ALLOWED;
                    }
                } else if (DIRECT_EXCHANGE.equals(exchangeName)) {
                    String queueID = CommonsUtil.getQueueID((String)queueName);
                    if (QpidAuthorizationHandler.isAdminUser(username, userRealm)) {
                        return Result.ALLOWED;
                    }
                    if (userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.CONSUME.toString().toLowerCase())) {
                        return Result.ALLOWED;
                    }
                } else if (TOPIC_EXCHANGE.equals(exchangeName)) {
                    if (CarbonContext.getCurrentContext().getTenantId() > 0) {
                        String tenantDomain = CarbonContext.getCurrentContext().getTenantDomain();
                        routingKey = routingKey.substring(tenantDomain.length() + 1);
                    }
                    String topicID = CommonsUtil.getTopicID((String)routingKey);
                    String newRoutingKey = routingKey.replace("@", AT_REPLACE_CHAR);
                    String newQName = queueName.replace("@", AT_REPLACE_CHAR);
                    if (QpidAuthorizationHandler.isAdminUser(username, userRealm)) {
                        RegistryClient.createSubscription((String)newRoutingKey, (String)newQName, (String)username);
                        return Result.ALLOWED;
                    }
                    if (userRealm.getAuthorizationManager().isUserAuthorized(username, topicID, TreeNode.Permission.SUBSCRIBE.toString().toLowerCase())) {
                        RegistryClient.createSubscription((String)newRoutingKey, (String)newQName, (String)username);
                        return Result.ALLOWED;
                    }
                }
            }
        }
        catch (UserStoreException e) {
            throw new QpidAuthorizationHandlerException(e);
        }
        catch (RegistryClientException e) {
            throw new QpidAuthorizationHandlerException(e);
        }
        return Result.DENIED;
    }

    public static Result handlePublishToExchange(String username, UserRealm userRealm, ObjectProperties properties) throws QpidAuthorizationHandlerException {
        try {
            if (null != userRealm) {
                String exchangeName = QpidAuthorizationHandler.getRawExchangeName((String)properties.get((Object)ObjectProperties.Property.NAME));
                String routingKey = QpidAuthorizationHandler.getRawRoutingKey((String)properties.get((Object)ObjectProperties.Property.ROUTING_KEY));
                if (DIRECT_EXCHANGE.equals(exchangeName)) {
                    String queueID = CommonsUtil.getQueueID((String)routingKey);
                    if (QpidAuthorizationHandler.isAdminUser(username, userRealm)) {
                        return Result.ALLOWED;
                    }
                    if (userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase())) {
                        return Result.ALLOWED;
                    }
                } else if (TOPIC_EXCHANGE.equals(exchangeName)) {
                    if (CarbonContext.getCurrentContext().getTenantId() > 0) {
                        String tenantDomain = CarbonContext.getCurrentContext().getTenantDomain();
                        routingKey = routingKey.substring(tenantDomain.length() + 1);
                    }
                    String permissionID = CommonsUtil.getTopicID((String)routingKey);
                    if (QpidAuthorizationHandler.isAdminUser(username, userRealm)) {
                        return Result.ALLOWED;
                    }
                    if (userRealm.getAuthorizationManager().isUserAuthorized(username, permissionID, TreeNode.Permission.PUBLISH.toString().toLowerCase())) {
                        return Result.ALLOWED;
                    }
                } else if (DEFAULT_EXCHANGE.equals(exchangeName)) {
                    String queueID = CommonsUtil.getQueueID((String)routingKey);
                    if (QpidAuthorizationHandler.isAdminUser(username, userRealm)) {
                        return Result.ALLOWED;
                    }
                    if (userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase())) {
                        return Result.ALLOWED;
                    }
                }
            }
        }
        catch (UserStoreException e) {
            throw new QpidAuthorizationHandlerException(e);
        }
        return Result.DENIED;
    }

    public static Result handleUnbindQueue(ObjectProperties properties) throws QpidAuthorizationHandlerException {
        try {
            String exchangeName = QpidAuthorizationHandler.getRawExchangeName((String)properties.get((Object)ObjectProperties.Property.NAME));
            String queueName = QpidAuthorizationHandler.getRawQueueName((String)properties.get((Object)ObjectProperties.Property.QUEUE_NAME));
            String routingKey = QpidAuthorizationHandler.getRawRoutingKey((String)properties.get((Object)ObjectProperties.Property.ROUTING_KEY));
            String newRoutingKey = routingKey.replace("@", AT_REPLACE_CHAR);
            String newQName = queueName.replace("@", AT_REPLACE_CHAR);
            if (TOPIC_EXCHANGE.equals(exchangeName)) {
                RegistryClient.deleteSubscription((String)routingKey, (String)queueName);
            }
            return Result.ALLOWED;
        }
        catch (RegistryClientException e) {
            throw new QpidAuthorizationHandlerException(e);
        }
    }

    public static Result handleDeleteQueue(ObjectProperties properties) throws QpidAuthorizationHandlerException {
        try {
            String queueName = QpidAuthorizationHandler.getRawQueueName((String)properties.get((Object)ObjectProperties.Property.NAME));
            String newQName = queueName.replace("@", AT_REPLACE_CHAR);
            RegistryClient.deleteQueue((String)queueName);
            return Result.ALLOWED;
        }
        catch (RegistryClientException e) {
            throw new QpidAuthorizationHandlerException(e);
        }
    }

    private static String getRawQueueName(String queueName) {
        if (queueName.indexOf(";") > -1) {
            queueName = queueName.substring(0, queueName.indexOf(";"));
        }
        return queueName.substring(queueName.indexOf(":") + 1, queueName.length());
    }

    private static String getRawRoutingKey(String routingKey) {
        return routingKey.substring(routingKey.indexOf(":") + 1, routingKey.length());
    }

    private static String getRawExchangeName(String exchangeName) {
        return exchangeName.equals("<<default>>") ? DEFAULT_EXCHANGE : exchangeName;
    }

    private static boolean isAdminUser(String username, UserRealm userRealm) {
        try {
            String[] userRoles;
            for (String userRole : userRoles = userRealm.getUserStoreManager().getRoleListOfUser(username)) {
                if (!ADMIN_ROLE.equals(userRole)) continue;
                return true;
            }
        }
        catch (UserStoreException userStoreException) {
            // empty catch block
        }
        return false;
    }
}

