/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authentication.internal;

import java.util.UUID;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.andes.authentication.internal.AuthenticationServiceDataHolder;
import org.wso2.carbon.andes.authentication.service.AuthenticationService;
import org.wso2.carbon.andes.authentication.service.AuthenticationServiceImpl;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

public class AuthenticationServiceComponent {
    private ServiceRegistration authenticationService = null;

    protected void activate(ComponentContext ctx) {
        String accessKey = UUID.randomUUID().toString();
        AuthenticationServiceDataHolder.getInstance().setAccessKey(accessKey);
        this.authenticationService = ctx.getBundleContext().registerService(AuthenticationService.class.getName(), (Object)new AuthenticationServiceImpl(accessKey), null);
    }

    protected void deactivate(ComponentContext ctx) {
        if (null != this.authenticationService) {
            this.authenticationService.unregister();
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        AuthenticationServiceDataHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        AuthenticationServiceDataHolder.getInstance().setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        AuthenticationServiceDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        AuthenticationServiceDataHolder.getInstance().setRealmService(null);
    }
}

