/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.hive.ui.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.hive.stub.HiveExecutionServiceHiveExecutionException;
import org.wso2.carbon.analytics.hive.ui.client.HiveExecutionClient;
import org.wso2.carbon.analytics.hive.ui.servlet.SaveScriptProcessor;
import org.wso2.carbon.ui.CarbonUIUtil;

public class SaveHiveConfiguration
extends HttpServlet {
    private static Log log = LogFactory.getLog(SaveScriptProcessor.class);

    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)this.getServletContext(), (HttpSession)request.getSession());
        ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)request.getSession().getAttribute("wso2carbon.admin.service.cookie");
        String driver = request.getParameter("driver");
        String url = request.getParameter("url");
        String username = request.getParameter("hiveusername");
        String password = request.getParameter("hivepassword");
        try {
            HiveExecutionClient client = new HiveExecutionClient(cookie, serverURL, configContext);
            PrintWriter writer = response.getWriter();
            if (!client.saveConfiguration(driver, url, username, password)) {
                writer.print("Configuration is not correct! couldn't connect to hive with provided configuration.\n Try Again!");
            } else {
                writer.print("Successfully updated the configuration");
            }
        }
        catch (HiveExecutionServiceHiveExecutionException e) {
            log.error((Object)"exception while updating the configuration", (Throwable)e);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"exception while updating the configuration", (Throwable)axisFault);
        }
        catch (RemoteException e) {
            log.error((Object)"exception while updating the configuration", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"exception while updating the configuration", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(SaveScriptProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(SaveScriptProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "used to save the configuration";
    }
}

