/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.hive.ui.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.hive.ui.cron.CronExpressionBuilder;
import org.wso2.carbon.analytics.hive.ui.servlet.SaveScriptProcessor;

public class SaveCronExpression
extends HttpServlet {
    private static Log log = LogFactory.getLog(SaveCronExpression.class);

    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        String cronExpression = "";
        String message = "";
        if (request.getParameter("optionCron").equalsIgnoreCase("selectUI")) {
            HashMap<String, String> cronVals = new HashMap<String, String>();
            cronVals.put("year", request.getParameter("yearSelected"));
            cronVals.put("month", request.getParameter("monthSelected"));
            if (request.getParameter("selectDay").equalsIgnoreCase("selectDayMonth")) {
                cronVals.put("day_of_month", request.getParameter("dayMonthSelected"));
            } else {
                cronVals.put("day_of_week", request.getParameter("dayWeekSelected"));
            }
            cronVals.put("hour", request.getParameter("hoursSelected"));
            cronVals.put("minute", request.getParameter("minutesSelected"));
            CronExpressionBuilder cronBuilder = CronExpressionBuilder.getInstance();
            cronExpression = cronBuilder.getCronExpression(cronVals);
            message = "Successfully updated the script scheduling.# cron expression: #" + cronExpression;
        } else if (request.getParameter("optionCron").equalsIgnoreCase("customCron")) {
            cronExpression = request.getParameter("customCron");
            message = "Successfully updated the script scheduling.# cron expression: #" + cronExpression;
        } else {
            message = "Interval wise scheduling is not supported yet";
        }
        log.info((Object)cronExpression);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            writer.print(message);
        }
        catch (IOException e) {
            log.error((Object)"Error while setting the cronExpression");
            writer.print("Error while scheduling the script");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(SaveScriptProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(SaveScriptProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "used to save the Hive script";
    }
}

