/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.hive.ui.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.hive.stub.HiveScriptStoreServiceHiveScriptStoreException;
import org.wso2.carbon.analytics.hive.ui.client.HiveScriptStoreClient;
import org.wso2.carbon.ui.CarbonUIUtil;

public class SaveScriptProcessor
extends HttpServlet {
    private static Log log = LogFactory.getLog(SaveScriptProcessor.class);

    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)this.getServletContext(), (HttpSession)request.getSession());
        ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)request.getSession().getAttribute("wso2carbon.admin.service.cookie");
        String scriptName = request.getParameter("scriptName");
        String scriptContent = request.getParameter("queries");
        String cron = request.getParameter("cronExp");
        if (null == cron) {
            cron = "";
        }
        PrintWriter out = null;
        try {
            out = response.getWriter();
            try {
                HiveScriptStoreClient client = new HiveScriptStoreClient(cookie, serverURL, configContext);
                client.saveScript(scriptName, scriptContent, cron);
                out.println("Successfully updated the Hive script " + scriptName);
            }
            catch (AxisFault axisFault) {
                out.println("Error while updating the script");
            }
            catch (RemoteException e) {
                out.println("Error while updating the script");
            }
            catch (HiveScriptStoreServiceHiveScriptStoreException e) {
                out.println("Error while updating the script");
            }
            catch (IOException e) {
                out.println("Error while updating the script");
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while writing to the response..", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(SaveScriptProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(SaveScriptProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "used to save the Hive script";
    }
}

