/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.hive.ui.cron;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CronExpressionBuilder {
    private static CronExpressionBuilder instance = new CronExpressionBuilder();

    private CronExpressionBuilder() {
    }

    public static CronExpressionBuilder getInstance() {
        return instance;
    }

    public String getCronExpression(HashMap<String, String> cronValues) {
        String dateCron = this.getDate(cronValues);
        String timeCron = this.getTime(cronValues, dateCron);
        return timeCron + " " + dateCron;
    }

    private String getTime(HashMap<String, String> cronValues, String dateCron) {
        String cronMinute = this.getCronText(cronValues.get("minute"));
        String cronHour = this.getCronText(cronValues.get("hour"));
        String tempCron = cronMinute + " " + cronHour + " " + dateCron;
        String cronSec = "";
        boolean isNumberExists = false;
        Pattern pattern = Pattern.compile("\\d");
        Matcher matcher = pattern.matcher(tempCron);
        if (matcher.find()) {
            isNumberExists = true;
        }
        cronSec = !isNumberExists ? "1" : "0";
        return cronSec + " " + cronMinute + " " + cronHour;
    }

    private String getCronText(String text) {
        if (text.equalsIgnoreCase("All")) {
            return "*";
        }
        return text;
    }

    private String getDate(HashMap<String, String> cronValues) {
        String dayMonth = cronValues.get("day_of_month");
        String cronDayMonth = "";
        String cronDayWeek = "";
        String cronMonth = "";
        String cronYear = "";
        if (null != dayMonth && !dayMonth.equals("")) {
            cronDayMonth = this.getCronText(dayMonth);
            cronDayWeek = "?";
        } else {
            String dayWeek = cronValues.get("day_of_week");
            cronDayWeek = this.getCronText(dayWeek);
            cronDayMonth = "?";
        }
        cronMonth = this.getCronText(cronValues.get("month"));
        cronYear = this.getCronText(cronValues.get("year"));
        String dateCron = cronDayMonth + " " + cronMonth + " " + cronDayWeek + " " + cronYear;
        return dateCron;
    }
}

