/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.hive.ui.client;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.hive.stub.HiveExecutionServiceHiveExecutionException;
import org.wso2.carbon.analytics.hive.stub.HiveExecutionServiceStub;

public class HiveExecutionClient {
    private static Log log = LogFactory.getLog(HiveExecutionClient.class);
    private HiveExecutionServiceStub stub;

    public HiveExecutionClient(String cookie, String backEndServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backEndServerURL + "HiveExecutionService";
        this.stub = new HiveExecutionServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        int timeout = 600000;
        this.stub._getServiceClient().getOptions().setTimeOutInMilliSeconds((long)timeout);
        this.stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)timeout);
        this.stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)timeout);
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setTimeOutInMilliSeconds((long)timeout);
        option.setProperty("Cookie", (Object)cookie);
    }

    public boolean saveConfiguration(String driver, String url, String username, String password) throws RemoteException, HiveExecutionServiceHiveExecutionException {
        try {
            return this.stub.setConnectionParameters(driver, url, username, password);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            throw e;
        }
        catch (HiveExecutionServiceHiveExecutionException e) {
            log.error((Object)e);
            throw e;
        }
    }

    public HiveExecutionServiceStub.QueryResult[] executeScript(String script) throws RemoteException, HiveExecutionServiceHiveExecutionException {
        try {
            HiveExecutionServiceStub.QueryResult[] res = this.stub.executeHiveScript(script);
            return res;
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (HiveExecutionServiceHiveExecutionException e) {
            log.error((Object)e.getFaultMessage().getHiveExecutionException().getExceptionMessage(), (Throwable)e);
            throw new HiveExecutionServiceHiveExecutionException(e.getFaultMessage().getHiveExecutionException().getExceptionMessage());
        }
    }
}

