/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage.utils;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DatabaseProperties;
import org.wso2.carbon.hadoop.hive.jdbc.storage.utils.ConfigurationUtils;

public class Commons {
    private static final Logger log = LoggerFactory.getLogger(Commons.class);

    public static Object getObjectFromWritable(Writable w) {
        if (w instanceof IntWritable) {
            return ((IntWritable)w).get();
        }
        if (w instanceof ShortWritable) {
            return ((ShortWritable)w).get();
        }
        if (w instanceof ByteWritable) {
            return ((ByteWritable)w).get();
        }
        if (w instanceof BooleanWritable) {
            return ((BooleanWritable)w).get();
        }
        if (w instanceof LongWritable) {
            return ((LongWritable)w).get();
        }
        if (w instanceof FloatWritable) {
            return Float.valueOf(((FloatWritable)w).get());
        }
        if (w instanceof DoubleWritable) {
            return ((DoubleWritable)w).get();
        }
        if (w instanceof NullWritable) {
            return null;
        }
        return w.toString();
    }

    public static PreparedStatement assignCorrectObjectType(Object value, int position, PreparedStatement statement) {
        try {
            if (value instanceof Integer) {
                statement.setInt(position, (Integer)value);
            } else if (value instanceof Short) {
                statement.setShort(position, (Short)value);
            } else if (value instanceof Byte) {
                statement.setByte(position, (Byte)value);
            } else if (value instanceof Boolean) {
                statement.setBoolean(position, (Boolean)value);
            } else if (value instanceof Long) {
                statement.setLong(position, (Long)value);
            } else if (value instanceof Float) {
                statement.setFloat(position, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                statement.setDouble(position, (Double)value);
            } else {
                statement.setString(position, value.toString());
            }
        }
        catch (SQLException e) {
            log.error("Failed to assign value to statement for position: " + position, (Throwable)e);
        }
        return statement;
    }

    public static final String extractingTableNameFromQuery(String createTableQuery) {
        String tableName = null;
        if (createTableQuery != null) {
            List<String> queryList = Arrays.asList(createTableQuery.split(" "));
            Iterator<String> iterator = queryList.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equalsIgnoreCase("create")) continue;
                while (iterator.hasNext()) {
                    if (!iterator.next().equalsIgnoreCase("table")) continue;
                    while (iterator.hasNext()) {
                        String nextString = iterator.next();
                        if (nextString.equalsIgnoreCase("")) continue;
                        tableName = nextString.split("\\(")[0];
                        return tableName;
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("You should provide at least mapred.jdbc.output.table.name or hive.jdbc.table.create.query property.");
        }
        return tableName;
    }

    public static final String extractFieldNames(String selectQuery) {
        String fields = "";
        List<String> queryList = Arrays.asList(selectQuery.split(" "));
        Iterator<String> iterator = queryList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equalsIgnoreCase("select")) continue;
            while (iterator.hasNext()) {
                String nextString = iterator.next();
                if (nextString.equalsIgnoreCase("from")) {
                    return fields;
                }
                fields = fields + nextString;
            }
        }
        return fields;
    }

    public static DatabaseProperties getDbPropertiesObj(JobConf conf) {
        DatabaseProperties dbProperties = new DatabaseProperties();
        String connectionUrl = ConfigurationUtils.getConnectionUrl((Configuration)conf);
        connectionUrl = connectionUrl.replaceAll(" ", "");
        dbProperties.setConnectionUrl(connectionUrl);
        dbProperties.setDriverClass(ConfigurationUtils.getDriverClass((Configuration)conf));
        dbProperties.setUserName(ConfigurationUtils.getDatabaseUserName((Configuration)conf));
        dbProperties.setPassword(ConfigurationUtils.getDatabasePassword((Configuration)conf));
        return dbProperties;
    }
}

