/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage.input;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DBManager;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DBOperation;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DatabaseProperties;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.QueryConstructor;
import org.wso2.carbon.hadoop.hive.jdbc.storage.utils.ConfigurationUtils;

public class JDBCSplit
extends FileSplit
implements InputSplit {
    private static final Logger log = LoggerFactory.getLogger(JDBCSplit.class);
    private static final String[] EMPTY_ARRAY = new String[0];
    private long start;
    private long end;
    private boolean isLastSplit = false;

    public JDBCSplit() {
        super((Path)null, 0L, 0L, EMPTY_ARRAY);
    }

    public JDBCSplit(long start, long end, Path dummyPath) {
        super(dummyPath, 0L, 0L, EMPTY_ARRAY);
        this.start = start;
        this.end = end;
    }

    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.start = input.readLong();
        this.end = input.readLong();
    }

    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.writeLong(this.start);
        output.writeLong(this.end);
    }

    public String[] getLocations() throws IOException {
        return EMPTY_ARRAY;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean isLastSplit() {
        return this.isLastSplit;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public long getLength() {
        return this.end - this.start;
    }

    public static JDBCSplit[] getSplits(JobConf conf, int numSplits) {
        DatabaseProperties dbProperties = new DatabaseProperties();
        dbProperties.setTableName(ConfigurationUtils.getInputTableName((Configuration)conf));
        dbProperties.setUserName(ConfigurationUtils.getDatabaseUserName((Configuration)conf));
        dbProperties.setPassword(ConfigurationUtils.getDatabasePassword((Configuration)conf));
        dbProperties.setConnectionUrl(ConfigurationUtils.getConnectionUrl((Configuration)conf));
        dbProperties.setDriverClass(ConfigurationUtils.getDriverClass((Configuration)conf));
        dbProperties.setFieldsNames(ConfigurationUtils.getInputFieldNames((Configuration)conf));
        QueryConstructor queryConstructor = new QueryConstructor();
        String sql = queryConstructor.constructCountQuery(dbProperties);
        DBManager dbManager = new DBManager();
        dbManager.createConnection(conf);
        JDBCSplit[] splits = null;
        try {
            Connection connection = dbManager.getConnection();
            DBOperation operation = new DBOperation();
            long total = operation.getTotalCount(sql, connection);
            long splitSize = total / (long)numSplits;
            splits = new JDBCSplit[numSplits];
            Path[] tablePaths = FileInputFormat.getInputPaths((JobConf)conf);
            for (int i = 0; i < numSplits; ++i) {
                if (i + 1 == numSplits) {
                    splits[i] = new JDBCSplit((long)i * splitSize, total, tablePaths[0]);
                    splits[i].setLastSplit();
                    continue;
                }
                splits[i] = new JDBCSplit((long)i * splitSize, (long)(i + 1) * splitSize, tablePaths[0]);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to get sql connection", (Throwable)e);
        }
        catch (SQLException e) {
            log.error("Failed to get total rows count", (Throwable)e);
        }
        return splits;
    }

    private void setLastSplit() {
        this.isLastSplit = true;
    }
}

