/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage.db;

import java.util.List;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DatabaseProperties;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DatabaseType;
import org.wso2.carbon.hadoop.hive.jdbc.storage.input.JDBCSplit;

public class QueryConstructor {
    public String constructUpdateQuery(String tableName, List<String> fieldNames, String[] primaryFields) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("Field names may not be null");
        }
        StringBuilder query = new StringBuilder();
        query.append("UPDATE ").append(tableName).append(" SET ");
        if (primaryFields == null || primaryFields.length == 0) {
            primaryFields = new String[]{fieldNames.get(0)};
        }
        boolean isFirstFieldAppended = false;
        for (int fieldCount = 0; fieldCount < fieldNames.size(); ++fieldCount) {
            boolean isPrimaryField = false;
            for (int primaryFieldCount = 0; primaryFieldCount < primaryFields.length; ++primaryFieldCount) {
                if (!fieldNames.get(fieldCount).equals(primaryFields[primaryFieldCount])) continue;
                isPrimaryField = true;
                break;
            }
            if (isPrimaryField) continue;
            if (!isFirstFieldAppended) {
                query.append(fieldNames.get(fieldCount)).append("=").append("?");
                isFirstFieldAppended = true;
                continue;
            }
            query.append(",").append(fieldNames.get(fieldCount)).append("=").append("?");
        }
        query.append(" WHERE ");
        for (int primaryKeyCount = 0; primaryKeyCount < primaryFields.length; ++primaryKeyCount) {
            if (primaryKeyCount == 0) {
                query.append(primaryFields[primaryKeyCount]).append("=").append("?");
                continue;
            }
            query.append(" AND ").append(primaryFields[primaryKeyCount]).append("=").append("?");
        }
        return query.toString();
    }

    public String constructSelectQuery(String tableName, List<String> fieldNames, String[] primaryFields) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("Field names may not be null");
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ").append(tableName).append(" WHERE ");
        if (primaryFields != null && primaryFields.length > 0) {
            for (int i = 0; i < primaryFields.length; ++i) {
                if (i > 0) {
                    query.append(" AND ").append(primaryFields[i]).append("=").append("?");
                    continue;
                }
                query.append(primaryFields[i]).append("=").append("?");
            }
        } else {
            query.append(fieldNames.get(0)).append("=").append("?");
        }
        return query.toString();
    }

    public String constructInsertQuery(String table, String[] fieldNames) {
        int i;
        if (fieldNames == null) {
            throw new IllegalArgumentException("Field names may not be null");
        }
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO ").append(table);
        if (fieldNames[0] != null || fieldNames.length > 0) {
            query.append(" (");
            for (i = 0; i < fieldNames.length; ++i) {
                query.append(fieldNames[i]);
                if (i == fieldNames.length - 1) continue;
                query.append(",");
            }
            query.append(")");
        }
        query.append(" VALUES (");
        for (i = 0; i < fieldNames.length; ++i) {
            query.append("?");
            if (i == fieldNames.length - 1) continue;
            query.append(",");
        }
        query.append(")");
        return query.toString();
    }

    public String constructCountQuery(DatabaseProperties dbProperties) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT COUNT(");
        if (dbProperties.getFieldsNames() != null) {
            query.append(dbProperties.getFieldsNames()[0]);
        } else {
            query.append("*");
        }
        query.append(") FROM ").append(dbProperties.getTableName());
        return query.toString();
    }

    public String constructSelectQueryForReading(DatabaseProperties dbProperties, JDBCSplit split, DatabaseType databaseType) {
        String query = null;
        switch (databaseType) {
            case MYSQL: 
            case H2: 
            case POSTGRESQL: {
                query = this.getQueryForMySql(dbProperties, split);
                break;
            }
            case ORACLE: {
                query = this.getQueryForOracle(dbProperties, split);
                break;
            }
            case SQLSERVER: {
                query = this.getQueryForMsSql(dbProperties, split);
            }
        }
        return query;
    }

    private String getQueryForMsSql(DatabaseProperties dbProperties, JDBCSplit split) {
        String[] fieldNames = dbProperties.getFieldsNames();
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ( ");
        query.append("SELECT TOP ").append(split.getLength()).append(" * FROM ( ");
        query.append("SELECT TOP ").append(split.getEnd()).append(" ");
        for (int i = 0; i < fieldNames.length; ++i) {
            query.append(fieldNames[i]);
            if (i == fieldNames.length - 1) continue;
            query.append(", ");
        }
        query.append(" FROM ");
        query.append(dbProperties.getTableName());
        query.append(" ORDER BY ").append(fieldNames[0]).append(" ASC ").append(")");
        query.append(" ORDER BY ").append(fieldNames[0]).append(" DESC ").append(")");
        query.append(" ORDER BY ").append(fieldNames[0]).append(" ASC");
        return query.toString();
    }

    private String getQueryForMySql(DatabaseProperties dbProperties, JDBCSplit split) {
        StringBuilder query = new StringBuilder();
        String[] fieldNames = dbProperties.getFieldsNames();
        query.append("SELECT ");
        for (int i = 0; i < fieldNames.length; ++i) {
            query.append(fieldNames[i]);
            if (i == fieldNames.length - 1) continue;
            query.append(", ");
        }
        query.append(" FROM ").append(dbProperties.getTableName());
        query.append(" LIMIT ").append(split.getLength());
        query.append(" OFFSET ").append(split.getStart());
        return query.toString();
    }

    private String getQueryForOracle(DatabaseProperties dbProperties, JDBCSplit split) {
        String[] fieldNames = dbProperties.getFieldsNames();
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ( SELECT ROW_NUMBER() OVER( ORDER BY ");
        query.append(fieldNames[0]);
        query.append(" ) LINENUM, ");
        for (int i = 0; i < fieldNames.length; ++i) {
            query.append(fieldNames[i]);
            if (i == fieldNames.length - 1) continue;
            query.append(", ");
        }
        query.append(" FROM ");
        query.append(dbProperties.getTableName());
        query.append(" ORDER BY ");
        query.append(fieldNames[0]);
        query.append(" )");
        query.append(" WHERE LINENUM BETWEEN ");
        query.append(split.getStart());
        query.append(" AND ");
        query.append(split.getEnd());
        return query.toString();
    }
}

