/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DBManager;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DBOperation;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DatabaseProperties;

public class DBRecordWriter
implements FileSinkOperator.RecordWriter {
    private static final Logger log = LoggerFactory.getLogger(DBRecordWriter.class);
    Connection connection = null;
    DatabaseProperties dbProperties;
    DBManager dbManager;

    public DBRecordWriter(DatabaseProperties databaseProperties, DBManager dbManager) throws ClassNotFoundException, SQLException {
        this.dbProperties = databaseProperties;
        this.dbManager = dbManager;
        this.connection = dbManager.getConnection();
    }

    @Override
    public void write(Writable writable) throws IOException {
        MapWritable map = (MapWritable)writable;
        DBOperation operation = null;
        try {
            operation = new DBOperation(this.dbProperties, this.connection);
            operation.writeToDB(map);
        }
        catch (SQLException e) {
            log.error("Failed to write data to the table: " + this.dbProperties.getTableName(), (Throwable)e);
        }
    }

    @Override
    public void close(boolean b) throws IOException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                log.error("Failed to close the connection", (Throwable)e);
            }
        }
    }
}

