/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyDouble
extends LazyPrimitive<LazyDoubleObjectInspector, DoubleWritable> {
    private static final Log LOG = LogFactory.getLog(LazyDouble.class);

    public LazyDouble(LazyDoubleObjectInspector oi) {
        super(oi);
        this.data = new DoubleWritable();
    }

    public LazyDouble(LazyDouble copy) {
        super(copy);
        this.data = new DoubleWritable(((DoubleWritable)copy.data).get());
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String byteData = null;
        try {
            byteData = Text.decode((byte[])bytes.getData(), (int)start, (int)length);
            ((DoubleWritable)this.data).set(Double.parseDouble(byteData));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            double value = ByteBuffer.wrap(bytes.getData(), start, length).asDoubleBuffer().get();
            ((DoubleWritable)this.data).set(value);
            this.isNull = false;
            LOG.debug((Object)"Handling number format exception", (Throwable)e);
        }
        catch (CharacterCodingException e) {
            this.isNull = true;
            LOG.debug((Object)"Data not in the Double data type range so converted to null.", (Throwable)e);
        }
    }
}

