/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Writable;

public abstract class CassandraLazyPrimitive<OI extends ObjectInspector, T extends Writable>
extends LazyPrimitive<OI, T> {
    protected int primitiveSize;

    CassandraLazyPrimitive(OI oi) {
        super(oi);
    }

    protected CassandraLazyPrimitive(CassandraLazyPrimitive<OI, T> copy) {
        super(copy.getInspector());
        this.isNull = copy.isNull;
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        this.setPrimitiveSize();
        if (this.checkSize(length)) {
            try {
                this.parsePrimitiveBytes(bytes, start, length);
                return;
            }
            catch (IndexOutOfBoundsException ie) {
                // empty catch block
            }
        }
        try {
            this.parseBytes(bytes, start, length);
        }
        catch (NumberFormatException e) {
            this.isNull = true;
        }
    }

    public boolean checkSize(int length) {
        return this.primitiveSize == length;
    }

    public abstract void setPrimitiveSize();

    public abstract void parsePrimitiveBytes(ByteArrayRef var1, int var2, int var3);

    public abstract void parseBytes(ByteArrayRef var1, int var2, int var3);
}

