/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.DeleteResourceProcessor;
import org.apache.hadoop.hive.ql.processors.DfsProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class CommandProcessorFactory {
    static Map<HiveConf, Driver> mapDrivers = new HashMap<HiveConf, Driver>();

    private CommandProcessorFactory() {
    }

    public static CommandProcessor get(String cmd) {
        return CommandProcessorFactory.get(cmd, null);
    }

    public static CommandProcessor get(String cmd, HiveConf conf) {
        String cmdl = cmd.toLowerCase();
        if ("set".equals(cmdl)) {
            return new SetProcessor();
        }
        if ("dfs".equals(cmdl)) {
            SessionState ss = SessionState.get();
            return new DfsProcessor(ss.getConf());
        }
        if ("add".equals(cmdl)) {
            return new AddResourceProcessor();
        }
        if ("delete".equals(cmdl)) {
            return new DeleteResourceProcessor();
        }
        if (!StringUtils.isBlank((String)cmd)) {
            if (conf == null) {
                return new Driver();
            }
            Driver drv = mapDrivers.get((Object)conf);
            if (drv == null) {
                drv = new Driver();
                mapDrivers.put(conf, drv);
            }
            drv.init();
            return drv;
        }
        return null;
    }

    public static void clean(HiveConf conf) {
        Driver drv = mapDrivers.get((Object)conf);
        if (drv != null) {
            drv.destroy();
        }
        mapDrivers.remove((Object)conf);
    }
}

