/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create Role")
public class RoleDDLDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private PrincipalType principalType;
    private boolean group;
    private RoleOperation operation;
    private String resFile;
    private String roleOwnerName;

    public RoleDDLDesc() {
    }

    public RoleDDLDesc(String roleName, RoleOperation operation) {
        this(roleName, PrincipalType.USER, operation, null);
    }

    public RoleDDLDesc(String principalName, PrincipalType principalType, RoleOperation operation, String roleOwnerName) {
        this.name = principalName;
        this.principalType = principalType;
        this.operation = operation;
        this.roleOwnerName = roleOwnerName;
    }

    @Explain(displayName="name")
    public String getName() {
        return this.name;
    }

    public void setName(String roleName) {
        this.name = roleName;
    }

    @Explain(displayName="role operation")
    public RoleOperation getOperation() {
        return this.operation;
    }

    public void setOperation(RoleOperation operation) {
        this.operation = operation;
    }

    public PrincipalType getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(PrincipalType principalType) {
        this.principalType = principalType;
    }

    public boolean getGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public String getResFile() {
        return this.resFile;
    }

    public void setResFile(String resFile) {
        this.resFile = resFile;
    }

    public String getRoleOwnerName() {
        return this.roleOwnerName;
    }

    public void setRoleOwnerName(String roleOwnerName) {
        this.roleOwnerName = roleOwnerName;
    }

    public static enum RoleOperation {
        DROP_ROLE("drop_role"),
        CREATE_ROLE("create_role"),
        SHOW_ROLE_GRANT("show_roles");

        private String operationName;

        private RoleOperation() {
        }

        private RoleOperation(String operationName) {
            this.operationName = operationName;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public String toString() {
            return this.operationName;
        }
    }
}

