/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.index.IndexMetadataChangeTask;
import org.apache.hadoop.hive.ql.index.IndexMetadataChangeWork;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.physical.index.IndexWhereProcessor;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public final class IndexUtils {
    private static final Log LOG = LogFactory.getLog((String)IndexWhereProcessor.class.getName());
    private static final Map<Index, Table> indexToIndexTable = new HashMap<Index, Table>();

    private IndexUtils() {
    }

    public static Set<Partition> checkPartitionsCoveredByIndex(TableScanOperator tableScan, ParseContext pctx, Map<Table, List<Index>> indexes) throws HiveException {
        Hive hive = Hive.get(pctx.getConf());
        Set<Partition> queryPartitions = null;
        PrunedPartitionList queryPartitionList = pctx.getOpToPartList().get(tableScan);
        if (queryPartitionList.getConfirmedPartns() != null && !queryPartitionList.getConfirmedPartns().isEmpty()) {
            queryPartitions = queryPartitionList.getConfirmedPartns();
        } else if (queryPartitionList.getUnknownPartns() != null && !queryPartitionList.getUnknownPartns().isEmpty()) {
            queryPartitions = queryPartitionList.getUnknownPartns();
        }
        for (Partition part : queryPartitions) {
            List<Table> sourceIndexTables = IndexUtils.getIndexTables(hive, part, indexes);
            if (IndexUtils.containsPartition(hive, part, indexes)) continue;
            return null;
        }
        return queryPartitions;
    }

    private List<Table> getIndexTables(Hive hive, Table table, Map<Table, List<Index>> indexes) throws HiveException {
        ArrayList<Table> indexTables = new ArrayList<Table>();
        if (indexes == null || indexes.get(table) == null) {
            return indexTables;
        }
        for (Index index : indexes.get(table)) {
            Table indexTable = hive.getTable(index.getIndexTableName());
            indexToIndexTable.put(index, indexTable);
            indexTables.add(indexTable);
        }
        return indexTables;
    }

    private static List<Table> getIndexTables(Hive hive, Partition part, Map<Table, List<Index>> indexes) throws HiveException {
        ArrayList<Table> indexTables = new ArrayList<Table>();
        Table partitionedTable = part.getTable();
        if (indexes == null || indexes.get(partitionedTable) == null) {
            return indexTables;
        }
        for (Index index : indexes.get(partitionedTable)) {
            Table indexTable = hive.getTable(index.getIndexTableName());
            indexToIndexTable.put(index, indexTable);
            indexTables.add(indexTable);
        }
        return indexTables;
    }

    private static boolean containsPartition(Hive hive, Partition part, Map<Table, List<Index>> indexes) throws HiveException {
        LinkedHashMap<String, String> partSpec = part.getSpec();
        if (indexes == null || indexes.get(part.getTable()) == null) {
            return false;
        }
        if (partSpec.isEmpty()) {
            return IndexUtils.isIndexTableFresh(hive, indexes.get(part.getTable()), part.getTable());
        }
        for (Index index : indexes.get(part.getTable())) {
            Table indexTable = indexToIndexTable.get(index);
            List<Partition> matchingPartitions = hive.getPartitions(indexTable, partSpec);
            if (matchingPartitions == null || matchingPartitions.size() == 0) {
                LOG.info((Object)("Index table " + indexTable + "did not contain built partition that matched " + partSpec));
                return false;
            }
            if (IndexUtils.isIndexPartitionFresh(hive, index, part)) continue;
            return false;
        }
        return true;
    }

    private static boolean isIndexPartitionFresh(Hive hive, Index index, Partition part) throws HiveException {
        LOG.info((Object)"checking index staleness...");
        try {
            FileSystem partFs = part.getPartitionPath().getFileSystem((Configuration)hive.getConf());
            FileStatus partFss = partFs.getFileStatus(part.getPartitionPath());
            String ts = index.getParameters().get(part.getSpec().toString());
            if (ts == null) {
                return false;
            }
            long indexTs = Long.parseLong(ts);
            LOG.info((Object)partFss.getModificationTime());
            LOG.info((Object)ts);
            if (partFss.getModificationTime() > indexTs) {
                LOG.info((Object)("index is stale on the partitions that matched " + part.getSpec()));
                return false;
            }
        }
        catch (IOException e) {
            LOG.info((Object)"failed to grab timestamp info");
            throw new HiveException(e);
        }
        return true;
    }

    private static boolean isIndexTableFresh(Hive hive, List<Index> indexes, Table src) throws HiveException {
        if (indexes == null || indexes.size() == 0) {
            return false;
        }
        for (Index index : indexes) {
            LOG.info((Object)"checking index staleness...");
            try {
                FileSystem srcFs = src.getPath().getFileSystem((Configuration)hive.getConf());
                FileStatus srcFss = srcFs.getFileStatus(src.getPath());
                String ts = index.getParameters().get("base_timestamp");
                if (ts == null) {
                    return false;
                }
                long indexTs = Long.parseLong(ts);
                LOG.info((Object)srcFss.getModificationTime());
                LOG.info((Object)ts);
                if (srcFss.getModificationTime() <= indexTs) continue;
                LOG.info((Object)"index is stale ");
                return false;
            }
            catch (IOException e) {
                LOG.info((Object)"failed to grab timestamp info");
                throw new HiveException(e);
            }
        }
        return true;
    }

    public static List<Index> getIndexes(Table baseTableMetaData, List<String> matchIndexTypes) throws SemanticException {
        ArrayList<Index> matchingIndexes = new ArrayList<Index>();
        List<Index> indexesOnTable = null;
        try {
            indexesOnTable = baseTableMetaData.getAllIndexes((short)-1);
        }
        catch (HiveException e) {
            throw new SemanticException("Error accessing metastore", e);
        }
        for (Index index : indexesOnTable) {
            String indexType = index.getIndexHandlerClass();
            if (!matchIndexTypes.contains(indexType)) continue;
            matchingIndexes.add(index);
        }
        return matchingIndexes;
    }

    public static Task<?> createRootTask(HiveConf builderConf, Set<ReadEntity> inputs, Set<WriteEntity> outputs, StringBuilder command, LinkedHashMap<String, String> partSpec, String indexTableName, String dbName) {
        HiveConf.setBoolVar(builderConf, HiveConf.ConfVars.HIVEOPTINDEXFILTER, false);
        Driver driver = new Driver(builderConf);
        driver.compile(command.toString());
        Task<? extends Serializable> rootTask = driver.getPlan().getRootTasks().get(0);
        inputs.addAll(driver.getPlan().getInputs());
        outputs.addAll(driver.getPlan().getOutputs());
        IndexMetadataChangeWork indexMetaChange = new IndexMetadataChangeWork(partSpec, indexTableName, dbName);
        IndexMetadataChangeTask indexMetaChangeTsk = new IndexMetadataChangeTask();
        indexMetaChangeTsk.setWork(indexMetaChange);
        rootTask.addDependentTask(indexMetaChangeTsk);
        return rootTask;
    }
}

