/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.StringUtils;

public class StatsTask
extends Task<StatsWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Log LOG = LogFactory.getLog(StatsTask.class);
    private Table table;
    private List<LinkedHashMap<String, String>> dpPartSpecs = null;
    private static final List<String> supportedStats = new ArrayList<String>();
    private static final List<String> collectableStats = new ArrayList<String>();
    private static final Map<String, String> nameMapping = new HashMap<String, String>();

    @Override
    protected void receiveFeed(Task.FeedType feedType, Object feedValue) {
        if (feedType == Task.FeedType.DYNAMIC_PARTITIONS) {
            assert (feedValue instanceof List);
            this.dpPartSpecs = (List)feedValue;
        }
    }

    @Override
    public int execute(DriverContext driverContext) {
        LOG.info((Object)"Executing stats task");
        int workComponentsPresent = 0;
        if (((StatsWork)this.work).getLoadTableDesc() != null) {
            workComponentsPresent = (short)(workComponentsPresent + 1);
        }
        if (((StatsWork)this.work).getTableSpecs() != null) {
            workComponentsPresent = (short)(workComponentsPresent + 1);
        }
        if (((StatsWork)this.work).getLoadFileDesc() != null) {
            workComponentsPresent = (short)(workComponentsPresent + 1);
        }
        assert (workComponentsPresent == 1);
        String tableName = "";
        try {
            tableName = ((StatsWork)this.work).getLoadTableDesc() != null ? ((StatsWork)this.work).getLoadTableDesc().getTable().getTableName() : (((StatsWork)this.work).getTableSpecs() != null ? ((StatsWork)this.work).getTableSpecs().tableName : ((StatsWork)this.work).getLoadFileDesc().getDestinationCreateTable());
            this.table = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            LOG.error((Object)("Cannot get table " + tableName), (Throwable)e);
            this.console.printError("Cannot get table " + tableName, e.toString());
        }
        return this.aggregateStats();
    }

    @Override
    public StageType getType() {
        return StageType.STATS;
    }

    @Override
    public String getName() {
        return "STATS";
    }

    @Override
    protected void localizeMRTmpFilesImpl(Context ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int aggregateStats() {
        StatsAggregator statsAggregator = null;
        try {
            FileStatus[] fileStatus;
            FileSystem fileSys;
            Warehouse wh = new Warehouse(this.conf);
            if (!((StatsWork)this.getWork()).getNoStatsAggregator()) {
                String statsImplementationClass = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVESTATSDBCLASS);
                StatsFactory.setImplementation(statsImplementationClass, this.conf);
                statsAggregator = StatsFactory.getStatsAggregator();
                if (!statsAggregator.connect(this.conf)) {
                    throw new HiveException("StatsAggregator connect failed " + statsImplementationClass);
                }
            }
            TableStatistics tblStats = new TableStatistics();
            org.apache.hadoop.hive.metastore.api.Table tTable = this.table.getTTable();
            Map<String, String> parameters = tTable.getParameters();
            boolean tableStatsExist = this.existStats(parameters);
            for (String statType : supportedStats) {
                if (!parameters.containsKey(statType)) continue;
                tblStats.setStat(statType, Long.parseLong(parameters.get(statType)));
            }
            if (parameters.containsKey("numPartitions")) {
                tblStats.setNumPartitions(Integer.parseInt(parameters.get("numPartitions")));
            }
            List<Partition> partitions = this.getPartitionsList();
            boolean atomic = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_ATOMIC);
            if (partitions == null) {
                if (!tableStatsExist && atomic) {
                    int n = 0;
                    return n;
                }
                Path tablePath = wh.getTablePath(this.db.getDatabase(this.table.getDbName()), this.table.getTableName());
                fileSys = tablePath.getFileSystem((Configuration)this.conf);
                fileStatus = Utilities.getFileStatusRecurse(tablePath, 1, fileSys);
                tblStats.setStat("numFiles", fileStatus.length);
                long tableSize = 0L;
                for (int i = 0; i < fileStatus.length; ++i) {
                    tableSize += fileStatus[i].getLen();
                }
                tblStats.setStat("totalSize", tableSize);
                if (statsAggregator != null) {
                    this.updateStats(collectableStats, tblStats, statsAggregator, parameters, ((StatsWork)this.work).getAggKey(), atomic);
                    statsAggregator.cleanUp(((StatsWork)this.work).getAggKey());
                }
            } else {
                for (Partition partn : partitions) {
                    org.apache.hadoop.hive.metastore.api.Partition tPart = partn.getTPartition();
                    parameters = tPart.getParameters();
                    boolean hasStats = this.existStats(parameters);
                    if (!hasStats && atomic) continue;
                    HashMap<String, Long> currentValues = new HashMap<String, Long>();
                    for (String statType : supportedStats) {
                        Long val = parameters.containsKey(statType) ? Long.parseLong(parameters.get(statType)) : 0L;
                        currentValues.put(statType, val);
                    }
                    PartitionStatistics newPartStats = new PartitionStatistics();
                    String partitionID = ((StatsWork)this.work).getAggKey() + Warehouse.makePartPath(partn.getSpec());
                    LOG.info((Object)("Stats aggregator : " + partitionID));
                    if (statsAggregator != null) {
                        this.updateStats(collectableStats, newPartStats, statsAggregator, parameters, partitionID, atomic);
                    } else {
                        for (String statType : collectableStats) {
                            newPartStats.setStat(statType, (Long)currentValues.get(statType));
                        }
                    }
                    fileSys = partn.getPartitionPath().getFileSystem((Configuration)this.conf);
                    fileStatus = Utilities.getFileStatusRecurse(partn.getPartitionPath(), 1, fileSys);
                    newPartStats.setStat("numFiles", fileStatus.length);
                    long partitionSize = 0L;
                    for (int i = 0; i < fileStatus.length; ++i) {
                        partitionSize += fileStatus[i].getLen();
                    }
                    newPartStats.setStat("totalSize", partitionSize);
                    if (hasStats) {
                        PartitionStatistics oldPartStats = new PartitionStatistics(currentValues);
                        tblStats.updateStats(oldPartStats, newPartStats);
                    } else {
                        tblStats.addPartitionStats(newPartStats);
                    }
                    for (String statType : supportedStats) {
                        long statValue = newPartStats.getStat(statType);
                        if (statValue < 0L) continue;
                        parameters.put(statType, Long.toString(newPartStats.getStat(statType)));
                    }
                    tPart.setParameters(parameters);
                    String tableFullName = this.table.getDbName() + "." + this.table.getTableName();
                    this.db.alterPartition(tableFullName, new Partition(this.table, tPart));
                    if (statsAggregator != null) {
                        statsAggregator.cleanUp(partitionID);
                    }
                    this.console.printInfo("Partition " + tableFullName + partn.getSpec() + " stats: [" + newPartStats.toString() + ']');
                }
            }
            parameters = tTable.getParameters();
            for (String statType : supportedStats) {
                parameters.put(statType, Long.toString(tblStats.getStat(statType)));
            }
            parameters.put("numPartitions", Integer.toString(tblStats.getNumPartitions()));
            tTable.setParameters(parameters);
            String tableFullName = this.table.getDbName() + "." + this.table.getTableName();
            this.db.alterTable(tableFullName, new Table(tTable));
            this.console.printInfo("Table " + tableFullName + " stats: [" + tblStats.toString() + ']');
        }
        catch (Exception e) {
            this.console.printInfo("[Warning] could not update stats.", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
        }
        finally {
            if (statsAggregator != null) {
                statsAggregator.closeConnection();
            }
        }
        return 0;
    }

    private boolean existStats(Map<String, String> parameters) {
        return parameters.containsKey("numRows") || parameters.containsKey("numFiles") || parameters.containsKey("totalSize") || parameters.containsKey("rawDataSize") || parameters.containsKey("numPartitions");
    }

    private void updateStats(List<String> statsList, PartitionStatistics stats, StatsAggregator statsAggregator, Map<String, String> parameters, String aggKey, boolean atomic) throws HiveException {
        for (String statType : statsList) {
            String value = statsAggregator.aggregateStats(aggKey, statType);
            if (value != null) {
                String originalValue;
                Long longValue = Long.parseLong(value);
                if (((StatsWork)this.work).getLoadTableDesc() != null && !((StatsWork)this.work).getLoadTableDesc().getReplace() && (originalValue = parameters.get(statType)) != null) {
                    longValue = longValue + Long.parseLong(originalValue);
                }
                stats.setStat(statType, longValue);
                continue;
            }
            if (!atomic) continue;
            throw new HiveException("StatsAggregator failed to get statistics.");
        }
    }

    private List<Partition> getPartitionsList() throws HiveException {
        if (((StatsWork)this.work).getLoadFileDesc() != null) {
            return null;
        }
        ArrayList<Partition> list = new ArrayList<Partition>();
        if (((StatsWork)this.work).getTableSpecs() != null) {
            BaseSemanticAnalyzer.tableSpec tblSpec = ((StatsWork)this.work).getTableSpecs();
            this.table = tblSpec.tableHandle;
            if (!this.table.isPartitioned()) {
                return null;
            }
            List<Partition> partitions = tblSpec.partitions;
            if (partitions != null) {
                for (Partition partn : partitions) {
                    list.add(partn);
                }
            }
        } else if (((StatsWork)this.work).getLoadTableDesc() != null) {
            LoadTableDesc tbd = ((StatsWork)this.work).getLoadTableDesc();
            this.table = this.db.getTable(tbd.getTable().getTableName());
            if (!this.table.isPartitioned()) {
                return null;
            }
            DynamicPartitionCtx dpCtx = tbd.getDPCtx();
            if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                for (LinkedHashMap<String, String> partSpec : this.dpPartSpecs) {
                    Partition partn = this.db.getPartition(this.table, partSpec, false);
                    list.add(partn);
                }
            } else {
                Partition partn = this.db.getPartition(this.table, tbd.getPartitionSpec(), false);
                list.add(partn);
            }
        }
        return list;
    }

    public static void cleanUp(String jobID, Configuration config) {
        String statsImplementationClass = HiveConf.getVar(config, HiveConf.ConfVars.HIVESTATSDBCLASS);
        StatsFactory.setImplementation(statsImplementationClass, config);
        StatsAggregator statsAggregator = StatsFactory.getStatsAggregator();
        if (statsAggregator.connect(config)) {
            statsAggregator.cleanUp(jobID + "/");
            statsAggregator.closeConnection();
        }
    }

    static {
        supportedStats.add("numFiles");
        supportedStats.add("numRows");
        supportedStats.add("totalSize");
        supportedStats.add("rawDataSize");
        collectableStats.add("numRows");
        collectableStats.add("rawDataSize");
        nameMapping.put("numFiles", "num_files");
        nameMapping.put("numRows", "num_rows");
        nameMapping.put("totalSize", "total_size");
        nameMapping.put("rawDataSize", "raw_data_size");
    }

    class TableStatistics
    extends PartitionStatistics {
        int numPartitions;

        public TableStatistics() {
            this.numPartitions = 0;
        }

        public void setNumPartitions(int np) {
            this.numPartitions = np;
        }

        public int getNumPartitions() {
            return this.numPartitions;
        }

        public void updateStats(PartitionStatistics oldStats, PartitionStatistics newStats) {
            this.deletePartitionStats(oldStats);
            this.addPartitionStats(newStats);
        }

        public void addPartitionStats(PartitionStatistics newStats) {
            for (String statType : supportedStats) {
                LongWritable value = (LongWritable)this.stats.get(statType);
                if (value == null) {
                    this.stats.put(statType, new LongWritable(newStats.getStat(statType)));
                    continue;
                }
                value.set(value.get() + newStats.getStat(statType));
            }
            ++this.numPartitions;
        }

        public void deletePartitionStats(PartitionStatistics oldStats) {
            for (String statType : supportedStats) {
                LongWritable value = (LongWritable)this.stats.get(statType);
                value.set(value.get() - oldStats.getStat(statType));
            }
            --this.numPartitions;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("num_partitions: ").append(this.numPartitions).append(", ");
            sb.append(super.toString());
            return sb.toString();
        }
    }

    class PartitionStatistics {
        Map<String, LongWritable> stats = new HashMap<String, LongWritable>();

        public PartitionStatistics() {
            for (String statType : supportedStats) {
                this.stats.put(statType, new LongWritable(0L));
            }
        }

        public PartitionStatistics(Map<String, Long> st) {
            for (String statType : st.keySet()) {
                Long stValue = st.get(statType) == null ? 0L : st.get(statType);
                this.stats.put(statType, new LongWritable(stValue.longValue()));
            }
        }

        public long getStat(String statType) {
            return this.stats.get(statType) == null ? 0L : this.stats.get(statType).get();
        }

        public void setStat(String statType, long value) {
            this.stats.put(statType, new LongWritable(value));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String statType : supportedStats) {
                sb.append((String)nameMapping.get(statType)).append(": ").append(this.stats.get(statType)).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            return sb.toString();
        }
    }
}

