/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;

public class HiveObjectPrivilege
implements TBase<HiveObjectPrivilege, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("HiveObjectPrivilege");
    private static final TField HIVE_OBJECT_FIELD_DESC = new TField("hiveObject", 12, 1);
    private static final TField PRINCIPAL_NAME_FIELD_DESC = new TField("principalName", 11, 2);
    private static final TField PRINCIPAL_TYPE_FIELD_DESC = new TField("principalType", 8, 3);
    private static final TField GRANT_INFO_FIELD_DESC = new TField("grantInfo", 12, 4);
    private HiveObjectRef hiveObject;
    private String principalName;
    private PrincipalType principalType;
    private PrivilegeGrantInfo grantInfo;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public HiveObjectPrivilege() {
    }

    public HiveObjectPrivilege(HiveObjectRef hiveObject, String principalName, PrincipalType principalType, PrivilegeGrantInfo grantInfo) {
        this();
        this.hiveObject = hiveObject;
        this.principalName = principalName;
        this.principalType = principalType;
        this.grantInfo = grantInfo;
    }

    public HiveObjectPrivilege(HiveObjectPrivilege other) {
        if (other.isSetHiveObject()) {
            this.hiveObject = new HiveObjectRef(other.hiveObject);
        }
        if (other.isSetPrincipalName()) {
            this.principalName = other.principalName;
        }
        if (other.isSetPrincipalType()) {
            this.principalType = other.principalType;
        }
        if (other.isSetGrantInfo()) {
            this.grantInfo = new PrivilegeGrantInfo(other.grantInfo);
        }
    }

    public HiveObjectPrivilege deepCopy() {
        return new HiveObjectPrivilege(this);
    }

    @Override
    public void clear() {
        this.hiveObject = null;
        this.principalName = null;
        this.principalType = null;
        this.grantInfo = null;
    }

    public HiveObjectRef getHiveObject() {
        return this.hiveObject;
    }

    public void setHiveObject(HiveObjectRef hiveObject) {
        this.hiveObject = hiveObject;
    }

    public void unsetHiveObject() {
        this.hiveObject = null;
    }

    public boolean isSetHiveObject() {
        return this.hiveObject != null;
    }

    public void setHiveObjectIsSet(boolean value) {
        if (!value) {
            this.hiveObject = null;
        }
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public void unsetPrincipalName() {
        this.principalName = null;
    }

    public boolean isSetPrincipalName() {
        return this.principalName != null;
    }

    public void setPrincipalNameIsSet(boolean value) {
        if (!value) {
            this.principalName = null;
        }
    }

    public PrincipalType getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(PrincipalType principalType) {
        this.principalType = principalType;
    }

    public void unsetPrincipalType() {
        this.principalType = null;
    }

    public boolean isSetPrincipalType() {
        return this.principalType != null;
    }

    public void setPrincipalTypeIsSet(boolean value) {
        if (!value) {
            this.principalType = null;
        }
    }

    public PrivilegeGrantInfo getGrantInfo() {
        return this.grantInfo;
    }

    public void setGrantInfo(PrivilegeGrantInfo grantInfo) {
        this.grantInfo = grantInfo;
    }

    public void unsetGrantInfo() {
        this.grantInfo = null;
    }

    public boolean isSetGrantInfo() {
        return this.grantInfo != null;
    }

    public void setGrantInfoIsSet(boolean value) {
        if (!value) {
            this.grantInfo = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case HIVE_OBJECT: {
                if (value == null) {
                    this.unsetHiveObject();
                    break;
                }
                this.setHiveObject((HiveObjectRef)value);
                break;
            }
            case PRINCIPAL_NAME: {
                if (value == null) {
                    this.unsetPrincipalName();
                    break;
                }
                this.setPrincipalName((String)value);
                break;
            }
            case PRINCIPAL_TYPE: {
                if (value == null) {
                    this.unsetPrincipalType();
                    break;
                }
                this.setPrincipalType((PrincipalType)value);
                break;
            }
            case GRANT_INFO: {
                if (value == null) {
                    this.unsetGrantInfo();
                    break;
                }
                this.setGrantInfo((PrivilegeGrantInfo)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case HIVE_OBJECT: {
                return this.getHiveObject();
            }
            case PRINCIPAL_NAME: {
                return this.getPrincipalName();
            }
            case PRINCIPAL_TYPE: {
                return this.getPrincipalType();
            }
            case GRANT_INFO: {
                return this.getGrantInfo();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case HIVE_OBJECT: {
                return this.isSetHiveObject();
            }
            case PRINCIPAL_NAME: {
                return this.isSetPrincipalName();
            }
            case PRINCIPAL_TYPE: {
                return this.isSetPrincipalType();
            }
            case GRANT_INFO: {
                return this.isSetGrantInfo();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof HiveObjectPrivilege) {
            return this.equals((HiveObjectPrivilege)that);
        }
        return false;
    }

    public boolean equals(HiveObjectPrivilege that) {
        if (that == null) {
            return false;
        }
        boolean this_present_hiveObject = this.isSetHiveObject();
        boolean that_present_hiveObject = that.isSetHiveObject();
        if (this_present_hiveObject || that_present_hiveObject) {
            if (!this_present_hiveObject || !that_present_hiveObject) {
                return false;
            }
            if (!this.hiveObject.equals(that.hiveObject)) {
                return false;
            }
        }
        boolean this_present_principalName = this.isSetPrincipalName();
        boolean that_present_principalName = that.isSetPrincipalName();
        if (this_present_principalName || that_present_principalName) {
            if (!this_present_principalName || !that_present_principalName) {
                return false;
            }
            if (!this.principalName.equals(that.principalName)) {
                return false;
            }
        }
        boolean this_present_principalType = this.isSetPrincipalType();
        boolean that_present_principalType = that.isSetPrincipalType();
        if (this_present_principalType || that_present_principalType) {
            if (!this_present_principalType || !that_present_principalType) {
                return false;
            }
            if (!this.principalType.equals(that.principalType)) {
                return false;
            }
        }
        boolean this_present_grantInfo = this.isSetGrantInfo();
        boolean that_present_grantInfo = that.isSetGrantInfo();
        if (this_present_grantInfo || that_present_grantInfo) {
            if (!this_present_grantInfo || !that_present_grantInfo) {
                return false;
            }
            if (!this.grantInfo.equals(that.grantInfo)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(HiveObjectPrivilege other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        HiveObjectPrivilege typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetHiveObject()).compareTo(typedOther.isSetHiveObject());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHiveObject() && (lastComparison = TBaseHelper.compareTo(this.hiveObject, typedOther.hiveObject)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPrincipalName()).compareTo(typedOther.isSetPrincipalName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrincipalName() && (lastComparison = TBaseHelper.compareTo(this.principalName, typedOther.principalName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPrincipalType()).compareTo(typedOther.isSetPrincipalType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrincipalType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.principalType), (Comparable)((Object)typedOther.principalType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGrantInfo()).compareTo(typedOther.isSetGrantInfo());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGrantInfo() && (lastComparison = TBaseHelper.compareTo(this.grantInfo, typedOther.grantInfo)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 12) {
                        this.hiveObject = new HiveObjectRef();
                        this.hiveObject.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.principalName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 8) {
                        this.principalType = PrincipalType.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 12) {
                        this.grantInfo = new PrivilegeGrantInfo();
                        this.grantInfo.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.hiveObject != null) {
            oprot.writeFieldBegin(HIVE_OBJECT_FIELD_DESC);
            this.hiveObject.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.principalName != null) {
            oprot.writeFieldBegin(PRINCIPAL_NAME_FIELD_DESC);
            oprot.writeString(this.principalName);
            oprot.writeFieldEnd();
        }
        if (this.principalType != null) {
            oprot.writeFieldBegin(PRINCIPAL_TYPE_FIELD_DESC);
            oprot.writeI32(this.principalType.getValue());
            oprot.writeFieldEnd();
        }
        if (this.grantInfo != null) {
            oprot.writeFieldBegin(GRANT_INFO_FIELD_DESC);
            this.grantInfo.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HiveObjectPrivilege(");
        boolean first = true;
        sb.append("hiveObject:");
        if (this.hiveObject == null) {
            sb.append("null");
        } else {
            sb.append(this.hiveObject);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("principalName:");
        if (this.principalName == null) {
            sb.append("null");
        } else {
            sb.append(this.principalName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("principalType:");
        if (this.principalType == null) {
            sb.append("null");
        } else {
            sb.append(this.principalType);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("grantInfo:");
        if (this.grantInfo == null) {
            sb.append("null");
        } else {
            sb.append(this.grantInfo);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.HIVE_OBJECT, new FieldMetaData("hiveObject", 3, new StructMetaData(12, HiveObjectRef.class)));
        tmpMap.put(_Fields.PRINCIPAL_NAME, new FieldMetaData("principalName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PRINCIPAL_TYPE, new FieldMetaData("principalType", 3, new EnumMetaData(16, PrincipalType.class)));
        tmpMap.put(_Fields.GRANT_INFO, new FieldMetaData("grantInfo", 3, new StructMetaData(12, PrivilegeGrantInfo.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(HiveObjectPrivilege.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        HIVE_OBJECT(1, "hiveObject"),
        PRINCIPAL_NAME(2, "principalName"),
        PRINCIPAL_TYPE(3, "principalType"),
        GRANT_INFO(4, "grantInfo");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return HIVE_OBJECT;
                }
                case 2: {
                    return PRINCIPAL_NAME;
                }
                case 3: {
                    return PRINCIPAL_TYPE;
                }
                case 4: {
                    return GRANT_INFO;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

