/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.TUGIContainingTransport;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;

public class TUGIBasedProcessor<I extends ThriftHiveMetastore.Iface>
extends ThriftHiveMetastore.Processor<ThriftHiveMetastore.Iface> {
    private final I iface;
    private final Map<String, ProcessFunction<I, ? extends TBase<?, ?>>> functions;
    private final HadoopShims shim;

    public TUGIBasedProcessor(I iface) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        super(iface);
        this.iface = iface;
        Method map = ThriftHiveMetastore.Processor.class.getDeclaredMethod("getProcessMap", Map.class);
        map.setAccessible(true);
        this.functions = (Map)map.invoke(null, new HashMap());
        this.shim = ShimLoader.getHadoopShims();
    }

    @Override
    public boolean process(final TProtocol in, final TProtocol out) throws TException {
        final TMessage msg = in.readMessageBegin();
        final ProcessFunction<I, TBase<?, ?>> fn = this.functions.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
            return true;
        }
        TUGIContainingTransport ugiTrans = (TUGIContainingTransport)in.getTransport();
        if (msg.name.equalsIgnoreCase("set_ugi")) {
            try {
                this.handleSetUGI(ugiTrans, fn, msg, in, out);
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TException(e.getCause());
            }
            return true;
        }
        UserGroupInformation clientUgi = ugiTrans.getClientUGI();
        if (null == clientUgi) {
            fn.process(msg.seqid, in, out, this.iface);
            return true;
        }
        PrivilegedExceptionAction<Void> pvea = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() {
                try {
                    fn.process(msg.seqid, in, out, TUGIBasedProcessor.this.iface);
                    return null;
                }
                catch (TException te) {
                    throw new RuntimeException(te);
                }
            }
        };
        try {
            this.shim.doAs(clientUgi, pvea);
            return true;
        }
        catch (RuntimeException rte) {
            if (rte.getCause() instanceof TException) {
                throw (TException)rte.getCause();
            }
            throw rte;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void handleSetUGI(TUGIContainingTransport ugiTrans, ProcessFunction<I, ? extends TBase<?, ?>> fn, TMessage msg, TProtocol iprot, TProtocol oprot) throws TException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        UserGroupInformation clientUgi = ugiTrans.getClientUGI();
        if (null != clientUgi) {
            throw new TException(new IllegalStateException("UGI is already set. Resetting is not allowed. Current ugi is: " + clientUgi.getUserName()));
        }
        Method method = fn.getClass().getDeclaredMethod("getEmptyArgsInstance", new Class[0]);
        method.setAccessible(true);
        ThriftHiveMetastore.set_ugi_args args = (ThriftHiveMetastore.set_ugi_args)method.invoke(fn, new Object[0]);
        try {
            args.read(iprot);
        }
        catch (TProtocolException e) {
            iprot.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e.getMessage());
            oprot.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
            return;
        }
        iprot.readMessageEnd();
        method = fn.getClass().getDeclaredMethod("getResult", ThriftHiveMetastore.Iface.class, ThriftHiveMetastore.set_ugi_args.class);
        method.setAccessible(true);
        ThriftHiveMetastore.set_ugi_result result = (ThriftHiveMetastore.set_ugi_result)method.invoke(fn, this.iface, args);
        List<String> principals = result.getSuccess();
        ugiTrans.setClientUGI(this.shim.createRemoteUser(principals.remove(principals.size() - 1), principals));
        oprot.writeMessageBegin(new TMessage(msg.name, 2, msg.seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
    }
}

