/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class HiveMetaStoreClient
implements IMetaStoreClient {
    ThriftHiveMetastore.Iface client = null;
    private TTransport transport = null;
    private boolean isConnected = false;
    private URI[] metastoreUris;
    private final HiveMetaHookLoader hookLoader;
    private final HiveConf conf;
    private String tokenStrForm;
    private final boolean localMetaStore;
    private int retries = 5;
    private int retryDelaySeconds = 0;
    private static final Log LOG = LogFactory.getLog((String)"hive.metastore");

    public HiveMetaStoreClient(HiveConf conf) throws MetaException {
        this(conf, null);
    }

    public HiveMetaStoreClient(HiveConf conf, HiveMetaHookLoader hookLoader) throws MetaException {
        this.hookLoader = hookLoader;
        if (conf == null) {
            conf = new HiveConf(HiveMetaStoreClient.class);
        }
        this.conf = conf;
        this.localMetaStore = conf.getBoolVar(HiveConf.ConfVars.METASTORE_MODE);
        if (this.localMetaStore) {
            this.client = new HiveMetaStore.HMSHandler("hive client", conf);
            this.isConnected = true;
            return;
        }
        this.retries = HiveConf.getIntVar(conf, HiveConf.ConfVars.METASTORETHRIFTRETRIES);
        this.retryDelaySeconds = conf.getIntVar(HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY);
        if (conf.getVar(HiveConf.ConfVars.METASTOREURIS) != null) {
            String[] metastoreUrisString = conf.getVar(HiveConf.ConfVars.METASTOREURIS).split(",");
            this.metastoreUris = new URI[metastoreUrisString.length];
            try {
                int i = 0;
                for (String s : metastoreUrisString) {
                    URI tmpUri = new URI(s);
                    if (tmpUri.getScheme() == null) {
                        throw new IllegalArgumentException("URI: " + s + " does not have a scheme");
                    }
                    this.metastoreUris[i++] = tmpUri;
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                MetaStoreUtils.logAndThrowMetaException(e);
            }
        } else if (conf.getVar(HiveConf.ConfVars.METASTOREDIRECTORY) != null) {
            this.metastoreUris = new URI[1];
            try {
                this.metastoreUris[0] = new URI(conf.getVar(HiveConf.ConfVars.METASTOREDIRECTORY));
            }
            catch (URISyntaxException e) {
                MetaStoreUtils.logAndThrowMetaException(e);
            }
        } else {
            LOG.error((Object)"NOT getting uris from conf");
            throw new MetaException("MetaStoreURIs not found in conf file");
        }
        this.open();
    }

    @Override
    public void alter_table(String dbname, String tbl_name, Table new_tbl) throws InvalidOperationException, MetaException, TException {
        this.client.alter_table(dbname, tbl_name, new_tbl);
    }

    @Override
    public void renamePartition(String dbname, String name, List<String> part_vals, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.client.rename_partition(dbname, name, part_vals, newPart);
    }

    private void open() throws MetaException {
        for (URI store : this.metastoreUris) {
            LOG.info((Object)("Trying to connect to metastore with URI " + store));
            try {
                this.openStore(store);
            }
            catch (MetaException e) {
                LOG.warn((Object)e.getStackTrace());
                LOG.warn((Object)("Unable to connect to metastore with URI " + store));
            }
            if (this.isConnected) break;
        }
        if (!this.isConnected) {
            throw new MetaException("Could not connect to meta store using any of the URIs provided");
        }
        LOG.info((Object)"Connected to metastore.");
    }

    private void openStore(URI store) throws MetaException {
        this.isConnected = false;
        for (int attempt = 0; !this.isConnected && attempt < this.retries; ++attempt) {
            if (attempt > 0 && this.retryDelaySeconds > 0) {
                try {
                    LOG.info((Object)("Waiting " + this.retryDelaySeconds + " seconds before next connection attempt."));
                    Thread.sleep(this.retryDelaySeconds * 1000);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            this.transport = new TSocket(store.getHost(), store.getPort());
            ((TSocket)this.transport).setTimeout(1000 * this.conf.getIntVar(HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT));
            HadoopShims shim = ShimLoader.getHadoopShims();
            boolean useSasl = this.conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL);
            if (useSasl) {
                try {
                    HadoopThriftAuthBridge.Client authBridge = ShimLoader.getHadoopThriftAuthBridge().createClient();
                    String tokenSig = this.conf.get("hive.metastore.token.signature");
                    this.tokenStrForm = shim.getTokenStrForm(tokenSig);
                    if (this.tokenStrForm != null) {
                        this.transport = authBridge.createClientTransport(null, store.getHost(), "DIGEST", this.tokenStrForm, this.transport);
                    } else {
                        String principalConfig = this.conf.getVar(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL);
                        this.transport = authBridge.createClientTransport(principalConfig, store.getHost(), "KERBEROS", null, this.transport);
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Couldn't create client transport", (Throwable)ioe);
                    throw new MetaException(ioe.toString());
                }
            }
            TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
            this.client = new ThriftHiveMetastore.Client(protocol);
            try {
                this.transport.open();
                this.isConnected = true;
            }
            catch (TTransportException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)"Failed to connect to the MetaStore Server...", (Throwable)e);
                }
                LOG.warn((Object)"Failed to connect to the MetaStore Server...");
            }
            if (useSasl || !this.conf.getBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI)) continue;
            try {
                UserGroupInformation ugi = shim.getUGIForConf(this.conf);
                this.client.set_ugi(ugi.getUserName(), Arrays.asList(ugi.getGroupNames()));
                continue;
            }
            catch (LoginException e) {
                LOG.warn((Object)"Failed to do login. set_ugi() is not successful, Continuing without it.", (Throwable)e);
                continue;
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed to find ugi of client set_ugi() is not successful, Continuing without it.", (Throwable)e);
                continue;
            }
            catch (TException e) {
                LOG.warn((Object)"set_ugi() not successful, Likely cause: new client talking to old server. Continuing without it.", (Throwable)e);
            }
        }
        if (!this.isConnected) {
            throw new MetaException("Could not connect to the MetaStore server!");
        }
    }

    public String getTokenStrForm() throws IOException {
        return this.tokenStrForm;
    }

    @Override
    public void close() {
        this.isConnected = false;
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
        try {
            if (null != this.client) {
                this.client.shutdown();
            }
        }
        catch (TException e) {
            LOG.error((Object)"Unable to shutdown local metastore client");
            LOG.error((Object)e.getStackTrace());
        }
    }

    @Override
    public Partition add_partition(Partition new_part) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.deepCopy(this.client.add_partition(new_part));
    }

    @Override
    public int add_partitions(List<Partition> new_parts) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.client.add_partitions(new_parts);
    }

    @Override
    public Partition appendPartition(String db_name, String table_name, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.deepCopy(this.client.append_partition(db_name, table_name, part_vals));
    }

    @Override
    public Partition appendPartition(String dbName, String tableName, String partName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.deepCopy(this.client.append_partition_by_name(dbName, tableName, partName));
    }

    @Override
    public void createDatabase(Database db) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        this.client.create_database(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        HiveMetaHook hook = this.getHook(tbl);
        if (hook != null) {
            hook.preCreateTable(tbl);
        }
        boolean success = false;
        try {
            this.client.create_table(tbl);
            if (hook != null) {
                hook.commitCreateTable(tbl);
            }
            success = true;
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackCreateTable(tbl);
            }
        }
    }

    public boolean createType(Type type) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        return this.client.create_type(type);
    }

    @Override
    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, true, false, false);
    }

    @Override
    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    @Override
    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try {
            this.getDatabase(name);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownDb) {
                throw e;
            }
            return;
        }
        this.client.drop_database(name, deleteData, cascade);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(db_name, tbl_name, part_vals, true);
    }

    @Override
    public boolean dropPartition(String dbName, String tableName, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition_by_name(dbName, tableName, partName, deleteData);
    }

    @Override
    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition(db_name, tbl_name, part_vals, deleteData);
    }

    @Override
    public void dropTable(String dbname, String name) throws NoSuchObjectException, MetaException, TException {
        this.dropTable(dbname, name, true, true);
    }

    @Override
    @Deprecated
    public void dropTable(String tableName, boolean deleteData) throws MetaException, UnknownTableException, TException, NoSuchObjectException {
        this.dropTable("default", tableName, deleteData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUknownTab) throws MetaException, TException, NoSuchObjectException {
        Table tbl;
        try {
            tbl = this.getTable(dbname, name);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUknownTab) {
                throw e;
            }
            return;
        }
        HiveMetaHook hook = this.getHook(tbl);
        if (hook != null) {
            hook.preDropTable(tbl);
        }
        boolean success = false;
        try {
            this.client.drop_table(dbname, name, deleteData);
            if (hook != null) {
                hook.commitDropTable(tbl, deleteData);
            }
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUknownTab) {
                throw e;
            }
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackDropTable(tbl);
            }
        }
    }

    public boolean dropType(String type) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_type(type);
    }

    public Map<String, Type> getTypeAll(String name) throws MetaException, TException {
        LinkedHashMap<String, Type> result = null;
        Map<String, Type> fromClient = this.client.get_type_all(name);
        if (fromClient != null) {
            result = new LinkedHashMap<String, Type>();
            for (String key : fromClient.keySet()) {
                result.put(key, this.deepCopy(fromClient.get(key)));
            }
        }
        return result;
    }

    @Override
    public List<String> getDatabases(String databasePattern) throws MetaException {
        try {
            return this.client.get_databases(databasePattern);
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getAllDatabases() throws MetaException {
        try {
            return this.client.get_all_databases();
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<Partition> listPartitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopyPartitions(this.client.get_partitions(db_name, tbl_name, max_parts));
    }

    @Override
    public List<Partition> listPartitions(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopyPartitions(this.client.get_partitions_ps(db_name, tbl_name, part_vals, max_parts));
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String db_name, String tbl_name, short max_parts, String user_name, List<String> group_names) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopyPartitions(this.client.get_partitions_with_auth(db_name, tbl_name, max_parts, user_name, group_names));
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String db_name, String tbl_name, List<String> part_vals, short max_parts, String user_name, List<String> group_names) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopyPartitions(this.client.get_partitions_ps_with_auth(db_name, tbl_name, part_vals, max_parts, user_name, group_names));
    }

    @Override
    public List<Partition> listPartitionsByFilter(String db_name, String tbl_name, String filter, short max_parts) throws MetaException, NoSuchObjectException, TException {
        return this.deepCopyPartitions(this.client.get_partitions_by_filter(db_name, tbl_name, filter, max_parts));
    }

    @Override
    public Database getDatabase(String name) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopy(this.client.get_database(name));
    }

    @Override
    public Partition getPartition(String db_name, String tbl_name, List<String> part_vals) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopy(this.client.get_partition(db_name, tbl_name, part_vals));
    }

    @Override
    public List<Partition> getPartitionsByNames(String db_name, String tbl_name, List<String> part_names) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopyPartitions(this.client.get_partitions_by_names(db_name, tbl_name, part_names));
    }

    @Override
    public Partition getPartitionWithAuthInfo(String db_name, String tbl_name, List<String> part_vals, String user_name, List<String> group_names) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.deepCopy(this.client.get_partition_with_auth(db_name, tbl_name, part_vals, user_name, group_names));
    }

    @Override
    public Table getTable(String dbname, String name) throws MetaException, TException, NoSuchObjectException {
        return this.deepCopy(this.client.get_table(dbname, name));
    }

    @Override
    @Deprecated
    public Table getTable(String tableName) throws MetaException, TException, NoSuchObjectException {
        return this.getTable("default", tableName);
    }

    @Override
    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        return this.deepCopyTables(this.client.get_table_objects_by_name(dbName, tableNames));
    }

    @Override
    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException, TException, InvalidOperationException, UnknownDBException {
        return this.client.get_table_names_by_filter(dbName, filter, maxTables);
    }

    public Type getType(String name) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopy(this.client.get_type(name));
    }

    @Override
    public List<String> getTables(String dbname, String tablePattern) throws MetaException {
        try {
            return this.client.get_tables(dbname, tablePattern);
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getAllTables(String dbname) throws MetaException {
        try {
            return this.client.get_all_tables(dbname);
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        try {
            this.client.get_table(databaseName, tableName);
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean tableExists(String tableName) throws MetaException, TException, UnknownDBException {
        return this.tableExists("default", tableName);
    }

    @Override
    public List<String> listPartitionNames(String dbName, String tblName, short max) throws MetaException, TException {
        return this.client.get_partition_names(dbName, tblName, max);
    }

    @Override
    public List<String> listPartitionNames(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException {
        return this.client.get_partition_names_ps(db_name, tbl_name, part_vals, max_parts);
    }

    @Override
    public void alter_partition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.client.alter_partition(dbName, tblName, newPart);
    }

    @Override
    public void alterDatabase(String dbName, Database db) throws MetaException, NoSuchObjectException, TException {
        this.client.alter_database(dbName, db);
    }

    @Override
    public List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.deepCopyFieldSchemas(this.client.get_fields(db, tableName));
    }

    @Override
    public void createIndex(Index index, Table indexTable) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.client.add_index(index, indexTable);
    }

    @Override
    public void alter_index(String dbname, String base_tbl_name, String idx_name, Index new_idx) throws InvalidOperationException, MetaException, TException {
        this.client.alter_index(dbname, base_tbl_name, idx_name, new_idx);
    }

    @Override
    public Index getIndex(String dbName, String tblName, String indexName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.deepCopy(this.client.get_index_by_name(dbName, tblName, indexName));
    }

    @Override
    public List<String> listIndexNames(String dbName, String tblName, short max) throws MetaException, TException {
        return this.client.get_index_names(dbName, tblName, max);
    }

    @Override
    public List<Index> listIndexes(String dbName, String tblName, short max) throws NoSuchObjectException, MetaException, TException {
        return this.client.get_indexes(dbName, tblName, max);
    }

    @Override
    public List<FieldSchema> getSchema(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.deepCopyFieldSchemas(this.client.get_schema(db, tableName));
    }

    @Override
    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        return this.client.get_config_value(name, defaultValue);
    }

    @Override
    public Partition getPartition(String db, String tableName, String partName) throws MetaException, TException, UnknownTableException, NoSuchObjectException {
        return this.deepCopy(this.client.get_partition_by_name(db, tableName, partName));
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.deepCopy(this.client.append_partition_by_name(dbName, tableName, partName));
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition_by_name(dbName, tableName, partName, deleteData);
    }

    private HiveMetaHook getHook(Table tbl) throws MetaException {
        if (this.hookLoader == null) {
            return null;
        }
        return this.hookLoader.getHook(tbl);
    }

    @Override
    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        return this.client.partition_name_to_vals(name);
    }

    @Override
    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        return this.client.partition_name_to_spec(name);
    }

    private Partition deepCopy(Partition partition) {
        Partition copy = null;
        if (partition != null) {
            copy = new Partition(partition);
        }
        return copy;
    }

    private Database deepCopy(Database database) {
        Database copy = null;
        if (database != null) {
            copy = new Database(database);
        }
        return copy;
    }

    private Table deepCopy(Table table) {
        Table copy = null;
        if (table != null) {
            copy = new Table(table);
        }
        return copy;
    }

    private Index deepCopy(Index index) {
        Index copy = null;
        if (index != null) {
            copy = new Index(index);
        }
        return copy;
    }

    private Type deepCopy(Type type) {
        Type copy = null;
        if (type != null) {
            copy = new Type(type);
        }
        return copy;
    }

    private FieldSchema deepCopy(FieldSchema schema) {
        FieldSchema copy = null;
        if (schema != null) {
            copy = new FieldSchema(schema);
        }
        return copy;
    }

    private List<Partition> deepCopyPartitions(List<Partition> partitions) {
        ArrayList<Partition> copy = null;
        if (partitions != null) {
            copy = new ArrayList<Partition>();
            for (Partition part : partitions) {
                copy.add(this.deepCopy(part));
            }
        }
        return copy;
    }

    private List<Table> deepCopyTables(List<Table> tables) {
        ArrayList<Table> copy = null;
        if (tables != null) {
            copy = new ArrayList<Table>();
            for (Table tab : tables) {
                copy.add(this.deepCopy(tab));
            }
        }
        return copy;
    }

    private List<FieldSchema> deepCopyFieldSchemas(List<FieldSchema> schemas) {
        ArrayList<FieldSchema> copy = null;
        if (schemas != null) {
            copy = new ArrayList<FieldSchema>();
            for (FieldSchema schema : schemas) {
                copy.add(this.deepCopy(schema));
            }
        }
        return copy;
    }

    @Override
    public boolean dropIndex(String dbName, String tblName, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_index_by_name(dbName, tblName, name, deleteData);
    }

    @Override
    public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        return this.client.grant_role(roleName, userName, principalType, grantor, grantorType, grantOption);
    }

    @Override
    public boolean create_role(Role role) throws MetaException, TException {
        return this.client.create_role(role);
    }

    @Override
    public boolean drop_role(String roleName) throws MetaException, TException {
        return this.client.drop_role(roleName);
    }

    @Override
    public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        return this.client.list_roles(principalName, principalType);
    }

    @Override
    public List<String> listRoleNames() throws MetaException, TException {
        return this.client.get_role_names();
    }

    @Override
    public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        return this.client.grant_privileges(privileges);
    }

    @Override
    public boolean revoke_role(String roleName, String userName, PrincipalType principalType) throws MetaException, TException {
        return this.client.revoke_role(roleName, userName, principalType);
    }

    @Override
    public boolean revoke_privileges(PrivilegeBag privileges) throws MetaException, TException {
        return this.client.revoke_privileges(privileges);
    }

    @Override
    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
        return this.client.get_privilege_set(hiveObject, userName, groupNames);
    }

    @Override
    public List<HiveObjectPrivilege> list_privileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObject) throws MetaException, TException {
        return this.client.list_privileges(principalName, principalType, hiveObject);
    }

    public String getDelegationToken(String renewerKerberosPrincipalName) throws MetaException, TException, IOException {
        String owner = this.conf.getUser();
        return this.getDelegationToken(owner, renewerKerberosPrincipalName);
    }

    @Override
    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        if (this.localMetaStore) {
            throw new UnsupportedOperationException("getDelegationToken() can be called only in thrift (non local) mode");
        }
        return this.client.get_delegation_token(owner, renewerKerberosPrincipalName);
    }

    @Override
    public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        if (this.localMetaStore) {
            throw new UnsupportedOperationException("renewDelegationToken() can be called only in thrift (non local) mode");
        }
        return this.client.renew_delegation_token(tokenStrForm);
    }

    @Override
    public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        if (this.localMetaStore) {
            throw new UnsupportedOperationException("renewDelegationToken() can be called only in thrift (non local) mode");
        }
        this.client.cancel_delegation_token(tokenStrForm);
    }

    public static IMetaStoreClient newSynchronizedClient(IMetaStoreClient client) {
        return (IMetaStoreClient)Proxy.newProxyInstance(HiveMetaStoreClient.class.getClassLoader(), new Class[]{IMetaStoreClient.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    @Override
    public void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, TException, NoSuchObjectException, UnknownDBException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        assert (db_name != null);
        assert (tbl_name != null);
        assert (partKVs != null);
        this.client.markPartitionForEvent(db_name, tbl_name, partKVs, eventType);
    }

    @Override
    public boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, UnknownTableException, UnknownDBException, TException, InvalidPartitionException, UnknownPartitionException {
        assert (db_name != null);
        assert (tbl_name != null);
        assert (partKVs != null);
        return this.client.isPartitionMarkedForEvent(db_name, tbl_name, partKVs, eventType);
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final IMetaStoreClient client;
        private static final Object lock = SynchronizedHandler.class;

        SynchronizedHandler(IMetaStoreClient client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object object = lock;
                synchronized (object) {
                    return method.invoke((Object)this.client, args);
                }
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

