/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.serde;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Writable;

public abstract class TableMapping {
    protected final List<String> cassandraColumnNames;
    protected final int iKey;
    protected final String cassandraColumnFamily;
    private boolean useJSONSerialize;
    protected final ByteStream.Output serializeStream = new ByteStream.Output();
    private final byte[] separators;
    private final boolean escaped;
    private final byte escapeChar;
    private final boolean[] needsEscape;

    TableMapping(String colFamily, List<String> columnNames, LazySimpleSerDe.SerDeParameters serdeParams) {
        this.cassandraColumnFamily = colFamily;
        this.cassandraColumnNames = columnNames;
        this.iKey = this.cassandraColumnNames.indexOf(":key");
        this.separators = serdeParams.getSeparators();
        this.escaped = serdeParams.isEscaped();
        this.escapeChar = serdeParams.getEscapeChar();
        this.needsEscape = serdeParams.getNeedsEscape();
    }

    public Writable getWritable(List<? extends StructField> fields, List<Object> list, List<? extends StructField> declaredFields) throws IOException {
        assert (this.iKey >= 0);
        byte[] keyBytes = this.serializeToBytes(this.iKey, fields, list, declaredFields);
        return this.write(keyBytes, fields, list, declaredFields);
    }

    public abstract Writable write(byte[] var1, List<? extends StructField> var2, List<Object> var3, List<? extends StructField> var4) throws IOException;

    protected byte[] serializeToBytes(int index, List<? extends StructField> fields, List<Object> list, List<? extends StructField> declaredFields) throws IOException {
        return this.serializeToBytes(fields.get(index).getFieldObjectInspector(), list.get(index), this.useJsonSerialize(index, declaredFields));
    }

    protected boolean useJsonSerialize(int index, List<? extends StructField> declaredFields) {
        return declaredFields == null || declaredFields.get(index).getFieldObjectInspector().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || this.useJSONSerialize;
    }

    protected byte[] serializeToBytes(ObjectInspector foi, Object obj, boolean useJsonSerialize) throws IOException {
        this.serializeStream.reset();
        boolean isNotNull = !foi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && useJsonSerialize ? this.serialize(SerDeUtils.getJSONString(obj, foi), PrimitiveObjectInspectorFactory.javaStringObjectInspector, 1) : this.serialize(obj, foi, 1);
        if (!isNotNull) {
            return null;
        }
        byte[] key = new byte[this.serializeStream.getCount()];
        System.arraycopy(this.serializeStream.getData(), 0, key, 0, this.serializeStream.getCount());
        return key;
    }

    protected boolean serialize(Object obj, ObjectInspector objInspector, int level) throws IOException {
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                LazyUtils.writePrimitiveUTF8(this.serializeStream, obj, (PrimitiveObjectInspector)objInspector, this.escaped, this.escapeChar, this.needsEscape);
                return true;
            }
            case LIST: {
                char separator = (char)this.separators[level];
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                List<?> list = loi.getList(obj);
                ObjectInspector eoi = loi.getListElementObjectInspector();
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        this.serializeStream.write(separator);
                    }
                    this.serialize(list.get(i), eoi, level + 1);
                }
                return true;
            }
            case MAP: {
                char separator = (char)this.separators[level];
                char keyValueSeparator = (char)this.separators[level + 1];
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map<?, ?> map = moi.getMap(obj);
                if (map == null) {
                    return false;
                }
                boolean first = true;
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        this.serializeStream.write(separator);
                    }
                    this.serialize(entry.getKey(), koi, level + 2);
                    this.serializeStream.write(keyValueSeparator);
                    this.serialize(entry.getValue(), voi, level + 2);
                }
                return true;
            }
            case STRUCT: {
                char separator = (char)this.separators[level];
                StructObjectInspector soi = (StructObjectInspector)objInspector;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                List<Object> list = soi.getStructFieldsDataAsList(obj);
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        this.serializeStream.write(separator);
                    }
                    this.serialize(list.get(i), fields.get(i).getFieldObjectInspector(), level + 1);
                }
                return true;
            }
        }
        throw new RuntimeException("Unknown category type: " + (Object)((Object)objInspector.getCategory()));
    }
}

