/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.input;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;

public class LazyCassandraCellMap
extends LazyMap {
    private ColumnFamilyRecordReader rowResult;
    private String cassandraColumnFamily;

    protected LazyCassandraCellMap(LazyMapObjectInspector oi) {
        super(oi);
    }

    public void init(ColumnFamilyRecordReader rr, String columnFamily) {
        this.rowResult = rr;
        this.cassandraColumnFamily = columnFamily;
        this.setParsed(false);
    }

    private void parse() {
        if (this.cachedMap == null) {
            this.cachedMap = new LinkedHashMap();
        } else {
            this.cachedMap.clear();
        }
    }

    @Override
    public Object getMapValueElement(Object key) {
        if (!this.getParsed()) {
            this.parse();
        }
        for (Map.Entry entry : this.cachedMap.entrySet()) {
            LazyPrimitive lazyKeyI = (LazyPrimitive)entry.getKey();
            Object keyI = lazyKeyI.getWritableObject();
            if (keyI == null || !keyI.equals(key)) continue;
            LazyObject v = (LazyObject)entry.getValue();
            return v == null ? v : v.getObject();
        }
        return null;
    }

    @Override
    public Map<Object, Object> getMap() {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.cachedMap;
    }

    @Override
    public int getMapSize() {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.cachedMap.size();
    }
}

