/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.hadoop.ColumnFamilyInputFormat;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.cassandra.input.CassandraHiveRecordReader;
import org.apache.hadoop.hive.cassandra.input.ColumnFamilyWideRowRecordReader;
import org.apache.hadoop.hive.cassandra.input.HiveCassandraStandardSplit;
import org.apache.hadoop.hive.cassandra.serde.AbstractColumnSerDe;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class HiveCassandraStandardColumnInputFormat
extends InputFormat<BytesWritable, MapWritable>
implements org.apache.hadoop.mapred.InputFormat<BytesWritable, MapWritable> {
    static final Log LOG = LogFactory.getLog(HiveCassandraStandardColumnInputFormat.class);
    private boolean isTransposed;
    private final ColumnFamilyInputFormat cfif = new ColumnFamilyInputFormat();

    public org.apache.hadoop.mapred.RecordReader<BytesWritable, MapWritable> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf jobConf, final Reporter reporter) throws IOException {
        HiveCassandraStandardSplit cassandraSplit = (HiveCassandraStandardSplit)split;
        List<String> columns = AbstractColumnSerDe.parseColumnMapping(cassandraSplit.getColumnMapping());
        this.isTransposed = AbstractColumnSerDe.isTransposed(columns);
        ArrayList<Integer> readColIDs = ColumnProjectionUtils.getReadColumnIDs((Configuration)jobConf);
        if (columns.size() < readColIDs.size()) {
            throw new IOException("Cannot read more columns than the given table contains.");
        }
        ColumnFamilySplit cfSplit = cassandraSplit.getSplit();
        Job job = new Job((Configuration)jobConf);
        TaskAttemptContext tac = new TaskAttemptContext(job.getConfiguration(), new TaskAttemptID()){

            public void progress() {
                reporter.progress();
            }
        };
        SlicePredicate predicate = new SlicePredicate();
        if (this.isTransposed || readColIDs.size() == columns.size() || readColIDs.size() == 0) {
            SliceRange range = new SliceRange();
            BytesType comparator = BytesType.instance;
            String comparatorType = jobConf.get("cassandra.slice.predicate.range.comparator");
            if (comparatorType != null && !comparatorType.equals("")) {
                try {
                    comparator = TypeParser.parse((String)comparatorType);
                }
                catch (ConfigurationException ex) {
                    throw new IOException("Comparator class not found.");
                }
            }
            String sliceStart = jobConf.get("cassandra.slice.predicate.range.start");
            String sliceEnd = jobConf.get("cassandra.slice.predicate.range.finish");
            String reversed = jobConf.get("cassandra.slice.predicate.range.reversed");
            range.setStart(comparator.fromString(sliceStart == null ? "" : sliceStart));
            range.setFinish(comparator.fromString(sliceEnd == null ? "" : sliceEnd));
            range.setReversed(reversed == null ? false : reversed.equals("true"));
            range.setCount(cassandraSplit.getSlicePredicateSize());
            predicate.setSlice_range(range);
        } else {
            int iKey = columns.indexOf(":key");
            predicate.setColumn_names(this.getColumnNames(iKey, columns, readColIDs));
        }
        try {
            ConfigHelper.setInputColumnFamily((Configuration)tac.getConfiguration(), (String)cassandraSplit.getKeyspace(), (String)cassandraSplit.getColumnFamily());
            ConfigHelper.setInputSlicePredicate((Configuration)tac.getConfiguration(), (SlicePredicate)predicate);
            ConfigHelper.setRangeBatchSize((Configuration)tac.getConfiguration(), (int)cassandraSplit.getRangeBatchSize());
            ConfigHelper.setInputRpcPort((Configuration)tac.getConfiguration(), (String)(cassandraSplit.getPort() + ""));
            ConfigHelper.setInputInitialAddress((Configuration)tac.getConfiguration(), (String)cassandraSplit.getHost());
            ConfigHelper.setInputPartitioner((Configuration)tac.getConfiguration(), (String)cassandraSplit.getPartitioner());
            ConfigHelper.setInputSplitSize((Configuration)tac.getConfiguration(), (int)cassandraSplit.getSplitSize());
            CassandraHiveRecordReader rr = null;
            rr = this.isTransposed && tac.getConfiguration().getBoolean("cassandra.enable.widerow.iterator", true) ? new CassandraHiveRecordReader(new ColumnFamilyWideRowRecordReader(), this.isTransposed) : new CassandraHiveRecordReader(new ColumnFamilyRecordReader(), this.isTransposed);
            rr.initialize((InputSplit)cfSplit, tac);
            return rr;
        }
        catch (Exception ie) {
            throw new IOException(ie);
        }
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        String ks = jobConf.get("cassandra.ks.name");
        String cf = jobConf.get("cassandra.cf.name");
        int slicePredicateSize = jobConf.getInt("cassandra.slice.predicate.size", 1000);
        int sliceRangeSize = jobConf.getInt("cassandra.range.size", 1000);
        int splitSize = jobConf.getInt("cassandra.input.split.size", 65536);
        String cassandraColumnMapping = jobConf.get("cassandra.columns.mapping");
        int rpcPort = jobConf.getInt("cassandra.port", 9160);
        String host = jobConf.get("cassandra.host");
        String partitioner = jobConf.get("cassandra.partitioner");
        if (cassandraColumnMapping == null) {
            throw new IOException("cassandra.columns.mapping required for Cassandra Table.");
        }
        SliceRange range = new SliceRange();
        range.setStart(new byte[0]);
        range.setFinish(new byte[0]);
        range.setReversed(false);
        range.setCount(slicePredicateSize);
        SlicePredicate predicate = new SlicePredicate();
        predicate.setSlice_range(range);
        ConfigHelper.setInputRpcPort((Configuration)jobConf, (String)("" + rpcPort));
        ConfigHelper.setInputInitialAddress((Configuration)jobConf, (String)host);
        ConfigHelper.setInputPartitioner((Configuration)jobConf, (String)partitioner);
        ConfigHelper.setInputSlicePredicate((Configuration)jobConf, (SlicePredicate)predicate);
        ConfigHelper.setInputColumnFamily((Configuration)jobConf, (String)ks, (String)cf);
        ConfigHelper.setRangeBatchSize((Configuration)jobConf, (int)sliceRangeSize);
        ConfigHelper.setInputSplitSize((Configuration)jobConf, (int)splitSize);
        Job job = new Job((Configuration)jobConf);
        JobContext jobContext = new JobContext(job.getConfiguration(), job.getJobID());
        Path[] tablePaths = FileInputFormat.getInputPaths((JobContext)jobContext);
        List<InputSplit> splits = this.getSplits(jobContext);
        org.apache.hadoop.mapred.InputSplit[] results = new org.apache.hadoop.mapred.InputSplit[splits.size()];
        for (int i = 0; i < splits.size(); ++i) {
            HiveCassandraStandardSplit csplit = new HiveCassandraStandardSplit((ColumnFamilySplit)splits.get(i), cassandraColumnMapping, tablePaths[0]);
            csplit.setKeyspace(ks);
            csplit.setColumnFamily(cf);
            csplit.setRangeBatchSize(sliceRangeSize);
            csplit.setSplitSize(splitSize);
            csplit.setHost(host);
            csplit.setPort(rpcPort);
            csplit.setSlicePredicateSize(slicePredicateSize);
            csplit.setPartitioner(partitioner);
            csplit.setColumnMapping(cassandraColumnMapping);
            results[i] = csplit;
        }
        return results;
    }

    private List<ByteBuffer> getColumnNames(int iKey, List<String> columns, List<Integer> readColIDs) {
        ArrayList<ByteBuffer> results = new ArrayList<ByteBuffer>();
        int maxSize = columns.size();
        for (Integer i : readColIDs) {
            assert (i < maxSize);
            if (i == iKey) continue;
            results.add(ByteBufferUtil.bytes((String)columns.get(i)));
        }
        return results;
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        return this.cfif.getSplits(context);
    }

    public RecordReader<BytesWritable, MapWritable> createRecordReader(InputSplit arg0, TaskAttemptContext tac) throws IOException, InterruptedException {
        if (this.isTransposed && tac.getConfiguration().getBoolean("cassandra.enable.widerow.iterator", true)) {
            return new CassandraHiveRecordReader(new ColumnFamilyWideRowRecordReader(), this.isTransposed);
        }
        return new CassandraHiveRecordReader(new ColumnFamilyRecordReader(), this.isTransposed);
    }
}

