/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra;

import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cassandra.CassandraManager;
import org.apache.hadoop.hive.cassandra.input.HiveCassandraStandardColumnInputFormat;
import org.apache.hadoop.hive.cassandra.output.HiveCassandraOutputFormat;
import org.apache.hadoop.hive.cassandra.serde.AbstractColumnSerDe;
import org.apache.hadoop.hive.cassandra.serde.CassandraColumnSerDe;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;

public class CassandraStorageHandler
implements HiveStorageHandler,
HiveMetaHook {
    private Configuration configuration;

    @Override
    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        String tableName = tableProperties.getProperty("name");
        String dbName = tableProperties.getProperty("db");
        String keyspace = tableProperties.getProperty("cassandra.ks.name");
        String columnFamily = tableProperties.getProperty("cassandra.cf.name");
        if (keyspace == null) {
            keyspace = dbName;
        }
        jobProperties.put("cassandra.ks.name", keyspace);
        if (columnFamily == null) {
            columnFamily = tableName;
        }
        jobProperties.put("cassandra.cf.name", columnFamily);
        String columnInfo = tableProperties.getProperty("cassandra.columns.mapping");
        if (columnInfo == null) {
            columnInfo = AbstractColumnSerDe.createColumnMappingString(tableProperties.getProperty("columns"));
        }
        jobProperties.put("cassandra.columns.mapping", columnInfo);
        jobProperties.put("cassandra.host", tableProperties.getProperty("cassandra.host", "localhost"));
        jobProperties.put("cassandra.port", tableProperties.getProperty("cassandra.port", "9160"));
        jobProperties.put("cassandra.partitioner", tableProperties.getProperty("cassandra.partitioner", "org.apache.cassandra.dht.RandomPartitioner"));
        jobProperties.put("cassandra.thrift.mode", tableProperties.getProperty("cassandra.thrift.mode", "framed"));
        jobProperties.put("cassandra.consistency.level", tableProperties.getProperty("cassandra.consistency.level", "ONE"));
        jobProperties.put("cassandra.range.size", tableProperties.getProperty("cassandra.range.size", Integer.toString(1000)));
        jobProperties.put("cassandra.slice.predicate.size", tableProperties.getProperty("cassandra.slice.predicate.size", Integer.toString(1000)));
        jobProperties.put("cassandra.input.split.size", tableProperties.getProperty("cassandra.input.split.size", Integer.toString(65536)));
        jobProperties.put("cassandra.batchmutate.size", tableProperties.getProperty("cassandra.batchmutate.size", Integer.toString(500)));
        jobProperties.put("cassandra.slice.predicate.range.finish", tableProperties.getProperty("cassandra.slice.predicate.range.finish", ""));
        jobProperties.put("cassandra.slice.predicate.range.comparator", tableProperties.getProperty("cassandra.slice.predicate.range.comparator", ""));
        jobProperties.put("cassandra.slice.predicate.range.reversed", tableProperties.getProperty("cassandra.slice.predicate.range.reversed", "false"));
        jobProperties.put("cassandra.slice.predicate.range.count", tableProperties.getProperty("cassandra.slice.predicate.range.count", "false"));
        jobProperties.put("cassandra.slice.predicate.column_names", tableProperties.getProperty("cassandra.slice.predicate.column_names", ""));
        jobProperties.put("cassandra.cf.counters", tableProperties.getProperty("cassandra.cf.counters", "false"));
        jobProperties.put("cassandra.input.keyspace.username", tableProperties.getProperty("cassandra.ks.username", ""));
        jobProperties.put("cassandra.input.keyspace.passwd", tableProperties.getProperty("cassandra.ks.password", ""));
    }

    @Override
    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveCassandraStandardColumnInputFormat.class;
    }

    @Override
    public HiveMetaHook getMetaHook() {
        return this;
    }

    @Override
    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveCassandraOutputFormat.class;
    }

    @Override
    public Class<? extends SerDe> getSerDeClass() {
        return CassandraColumnSerDe.class;
    }

    public Configuration getConf() {
        return this.configuration;
    }

    public void setConf(Configuration arg0) {
        this.configuration = arg0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preCreateTable(Table table) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable(table);
        if (!isExternal) {
            throw new MetaException("Cassandra tables must be external.");
        }
        if (table.getSd().getLocation() != null) {
            throw new MetaException("LOCATION may not be specified for Cassandra.");
        }
        CassandraManager manager = new CassandraManager(table);
        try {
            manager.openConnection();
            KsDef ks = manager.getKeyspaceDesc();
            manager.createCFIfNotFound(ks);
        }
        catch (NotFoundException e) {
            manager.createKeyspaceWithColumns();
        }
        finally {
            manager.closeConnection();
        }
    }

    @Override
    public void commitCreateTable(Table table) throws MetaException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitDropTable(Table table, boolean deleteData) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable(table);
        if (deleteData && !isExternal) {
            CassandraManager manager = new CassandraManager(table);
            try {
                manager.openConnection();
                manager.dropTable();
            }
            finally {
                manager.closeConnection();
            }
        }
    }

    @Override
    public void preDropTable(Table table) throws MetaException {
    }

    @Override
    public void rollbackCreateTable(Table table) throws MetaException {
    }

    @Override
    public void rollbackDropTable(Table table) throws MetaException {
    }
}

