/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.BlockTransferThrottler;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;

class BlockSender
implements Closeable,
FSConstants {
    public static final Log LOG = DataNode.LOG;
    static final Log ClientTraceLog = DataNode.ClientTraceLog;
    private Block block;
    private InputStream blockIn;
    private long blockInPosition = -1L;
    private DataInputStream checksumIn;
    private DataChecksum checksum;
    private long offset;
    private long endOffset;
    private long blockLength;
    private int bytesPerChecksum;
    private int checksumSize;
    private boolean corruptChecksumOk;
    private boolean chunkOffsetOK;
    private long seqno;
    private boolean transferToAllowed = true;
    private boolean blockReadFully;
    private boolean verifyChecksum;
    private BlockTransferThrottler throttler;
    private final String clientTraceFmt;
    private static final int MIN_BUFFER_WITH_TRANSFERTO = 65536;

    BlockSender(Block block, long startOffset, long length, boolean corruptChecksumOk, boolean chunkOffsetOK, boolean verifyChecksum, DataNode datanode) throws IOException {
        this(block, startOffset, length, corruptChecksumOk, chunkOffsetOK, verifyChecksum, datanode, null);
    }

    BlockSender(Block block, long startOffset, long length, boolean corruptChecksumOk, boolean chunkOffsetOK, boolean verifyChecksum, DataNode datanode, String clientTraceFmt) throws IOException {
        try {
            long checksumSkip;
            this.block = block;
            this.chunkOffsetOK = chunkOffsetOK;
            this.corruptChecksumOk = corruptChecksumOk;
            this.verifyChecksum = verifyChecksum;
            this.blockLength = datanode.data.getLength(block);
            this.transferToAllowed = datanode.transferToAllowed;
            this.clientTraceFmt = clientTraceFmt;
            if (!corruptChecksumOk || datanode.data.metaFileExists(block)) {
                this.checksumIn = new DataInputStream(new BufferedInputStream(datanode.data.getMetaDataInputStream(block), BUFFER_SIZE));
                BlockMetadataHeader header = BlockMetadataHeader.readHeader(this.checksumIn);
                short version = header.getVersion();
                if (version != 1) {
                    LOG.warn((Object)("Wrong version (" + version + ") for metadata file for " + block + " ignoring ..."));
                }
                this.checksum = header.getChecksum();
            } else {
                LOG.warn((Object)("Could not find metadata file for " + block));
                this.checksum = DataChecksum.newDataChecksum(0, 16384);
            }
            this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
            if (this.bytesPerChecksum > 0xA00000 && (long)this.bytesPerChecksum > this.blockLength) {
                this.checksum = DataChecksum.newDataChecksum(this.checksum.getChecksumType(), Math.max((int)this.blockLength, 0xA00000));
                this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
            }
            this.checksumSize = this.checksum.getChecksumSize();
            if (length < 0L) {
                length = this.blockLength;
            }
            this.endOffset = this.blockLength;
            if (startOffset < 0L || startOffset > this.endOffset || length + startOffset > this.endOffset) {
                String msg = " Offset " + startOffset + " and length " + length + " don't match block " + block + " ( blockLen " + this.endOffset + " )";
                LOG.warn((Object)(datanode.dnRegistration + ":sendBlock() : " + msg));
                throw new IOException(msg);
            }
            this.offset = startOffset - startOffset % (long)this.bytesPerChecksum;
            if (length >= 0L) {
                long tmpLen = startOffset + length;
                if (tmpLen % (long)this.bytesPerChecksum != 0L) {
                    tmpLen += (long)this.bytesPerChecksum - tmpLen % (long)this.bytesPerChecksum;
                }
                if (tmpLen < this.endOffset) {
                    this.endOffset = tmpLen;
                }
            }
            if (this.offset > 0L && (checksumSkip = this.offset / (long)this.bytesPerChecksum * (long)this.checksumSize) > 0L) {
                IOUtils.skipFully(this.checksumIn, checksumSkip);
            }
            this.seqno = 0L;
            this.blockIn = datanode.data.getBlockInputStream(block, this.offset);
        }
        catch (IOException ioe) {
            IOUtils.closeStream(this);
            IOUtils.closeStream(this.blockIn);
            throw ioe;
        }
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        if (this.checksumIn != null) {
            try {
                this.checksumIn.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            this.checksumIn = null;
        }
        if (this.blockIn != null) {
            try {
                this.blockIn.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            this.blockIn = null;
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private static IOException ioeToSocketException(IOException ioe) {
        if (ioe.getClass().equals(IOException.class)) {
            SocketException se = new SocketException("Original Exception : " + ioe);
            se.initCause(ioe);
            se.setStackTrace(ioe.getStackTrace());
            return se;
        }
        return ioe;
    }

    private int sendChunks(ByteBuffer pkt, int maxChunks, OutputStream out) throws IOException {
        int len = Math.min((int)(this.endOffset - this.offset), this.bytesPerChecksum * maxChunks);
        if (len == 0) {
            return 0;
        }
        int numChunks = (len + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
        int packetLen = len + numChunks * this.checksumSize + 4;
        pkt.clear();
        pkt.putInt(packetLen);
        pkt.putLong(this.offset);
        pkt.putLong(this.seqno);
        pkt.put((byte)(this.offset + (long)len >= this.endOffset ? 1 : 0));
        pkt.putInt(len);
        int checksumOff = pkt.position();
        int checksumLen = numChunks * this.checksumSize;
        byte[] buf = pkt.array();
        if (this.checksumSize > 0 && this.checksumIn != null) {
            try {
                this.checksumIn.readFully(buf, checksumOff, checksumLen);
            }
            catch (IOException e) {
                LOG.warn((Object)(" Could not read or failed to veirfy checksum for data at offset " + this.offset + " for block " + this.block + " got : " + StringUtils.stringifyException(e)));
                IOUtils.closeStream(this.checksumIn);
                this.checksumIn = null;
                if (this.corruptChecksumOk) {
                    if (checksumOff < checksumLen) {
                        Arrays.fill(buf, checksumOff, checksumLen, (byte)0);
                    }
                }
                throw e;
            }
        }
        int dataOff = checksumOff + checksumLen;
        if (this.blockInPosition < 0L) {
            IOUtils.readFully(this.blockIn, buf, dataOff, len);
            if (this.verifyChecksum) {
                int dOff = dataOff;
                int cOff = checksumOff;
                int dLeft = len;
                for (int i = 0; i < numChunks; ++i) {
                    this.checksum.reset();
                    int dLen = Math.min(dLeft, this.bytesPerChecksum);
                    this.checksum.update(buf, dOff, dLen);
                    if (!this.checksum.compare(buf, cOff)) {
                        throw new ChecksumException("Checksum failed at " + (this.offset + (long)len - (long)dLeft), len);
                    }
                    dLeft -= dLen;
                    dOff += dLen;
                    cOff += this.checksumSize;
                }
            }
        }
        try {
            if (this.blockInPosition >= 0L) {
                SocketOutputStream sockOut = (SocketOutputStream)out;
                sockOut.write(buf, 0, dataOff);
                sockOut.transferToFully(((FileInputStream)this.blockIn).getChannel(), this.blockInPosition, len);
                this.blockInPosition += (long)len;
            } else {
                out.write(buf, 0, dataOff + len);
            }
        }
        catch (IOException e) {
            throw BlockSender.ioeToSocketException(e);
        }
        if (this.throttler != null) {
            this.throttler.throttle(packetLen);
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long sendBlock(DataOutputStream out, OutputStream baseStream, BlockTransferThrottler throttler) throws IOException {
        long totalRead;
        long initialOffset;
        block12: {
            if (out == null) {
                throw new IOException("out stream is null");
            }
            this.throttler = throttler;
            initialOffset = this.offset;
            totalRead = 0L;
            DataOutputStream dataOutputStream = out;
            long startTime = ClientTraceLog.isInfoEnabled() ? System.nanoTime() : 0L;
            try {
                int maxChunksPerPacket;
                try {
                    this.checksum.writeHeader(out);
                    if (this.chunkOffsetOK) {
                        out.writeLong(this.offset);
                    }
                    out.flush();
                }
                catch (IOException e) {
                    throw BlockSender.ioeToSocketException(e);
                }
                int pktSize = 25;
                if (this.transferToAllowed && !this.verifyChecksum && baseStream instanceof SocketOutputStream && this.blockIn instanceof FileInputStream) {
                    FileChannel fileChannel = ((FileInputStream)this.blockIn).getChannel();
                    this.blockInPosition = fileChannel.position();
                    OutputStream outputStream = baseStream;
                    maxChunksPerPacket = (Math.max(BUFFER_SIZE, 65536) + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
                    pktSize += this.checksumSize * maxChunksPerPacket;
                } else {
                    maxChunksPerPacket = Math.max(1, (BUFFER_SIZE + this.bytesPerChecksum - 1) / this.bytesPerChecksum);
                    pktSize += (this.bytesPerChecksum + this.checksumSize) * maxChunksPerPacket;
                }
                ByteBuffer pktBuf = ByteBuffer.allocate(pktSize);
                while (this.endOffset > this.offset) {
                    void var8_8;
                    long len = this.sendChunks(pktBuf, maxChunksPerPacket, (OutputStream)var8_8);
                    this.offset += len;
                    totalRead += len + (len + (long)this.bytesPerChecksum - 1L) / (long)this.bytesPerChecksum * (long)this.checksumSize;
                    ++this.seqno;
                }
                try {
                    out.writeInt(0);
                    out.flush();
                }
                catch (IOException e) {
                    throw BlockSender.ioeToSocketException(e);
                }
                if (this.clientTraceFmt == null) break block12;
            }
            catch (Throwable throwable) {
                if (this.clientTraceFmt != null) {
                    long endTime = System.nanoTime();
                    ClientTraceLog.info((Object)String.format(this.clientTraceFmt, totalRead, initialOffset, endTime - startTime));
                }
                this.close();
                throw throwable;
            }
            long endTime = System.nanoTime();
            ClientTraceLog.info((Object)String.format(this.clientTraceFmt, totalRead, initialOffset, endTime - startTime));
        }
        this.close();
        this.blockReadFully = initialOffset == 0L && this.offset >= this.blockLength;
        return totalRead;
    }

    boolean isBlockReadFully() {
        return this.blockReadFully;
    }
}

