/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Upgradeable;
import org.apache.hadoop.util.StringUtils;

public class UpgradeObjectCollection {
    static SortedSet<UOSignature> upgradeTable;

    static final void initialize() {
        upgradeTable = new TreeSet<UOSignature>();
    }

    static void registerUpgrade(Upgradeable uo) {
        upgradeTable.add(new UOSignature(uo));
    }

    public static SortedSet<Upgradeable> getDistributedUpgrades(int versionFrom, HdfsConstants.NodeType type) throws IOException {
        assert (-31 <= versionFrom) : "Incorrect version " + versionFrom + ". Expected to be <= " + -31;
        TreeSet<Upgradeable> upgradeObjects = new TreeSet<Upgradeable>();
        for (UOSignature sig : upgradeTable) {
            if (sig.getVersion() < -31) continue;
            if (sig.getVersion() > versionFrom) break;
            if (sig.getType() != type) continue;
            upgradeObjects.add(sig.instantiate());
        }
        if (upgradeObjects.size() == 0) {
            return null;
        }
        return upgradeObjects;
    }

    static {
        UpgradeObjectCollection.initialize();
    }

    static class UOSignature
    implements Comparable<UOSignature> {
        int version;
        HdfsConstants.NodeType type;
        String className;

        UOSignature(Upgradeable uo) {
            this.version = uo.getVersion();
            this.type = uo.getType();
            this.className = uo.getClass().getCanonicalName();
        }

        int getVersion() {
            return this.version;
        }

        HdfsConstants.NodeType getType() {
            return this.type;
        }

        String getClassName() {
            return this.className;
        }

        Upgradeable instantiate() throws IOException {
            try {
                return (Upgradeable)Class.forName(this.getClassName()).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException(e));
            }
            catch (InstantiationException e) {
                throw new IOException(StringUtils.stringifyException(e));
            }
            catch (IllegalAccessException e) {
                throw new IOException(StringUtils.stringifyException(e));
            }
        }

        @Override
        public int compareTo(UOSignature o) {
            if (this.version != o.version) {
                return this.version < o.version ? -1 : 1;
            }
            int res = this.getType().toString().compareTo(o.getType().toString());
            if (res != 0) {
                return res;
            }
            return this.className.compareTo(o.className);
        }

        public boolean equals(Object o) {
            if (!(o instanceof UOSignature)) {
                return false;
            }
            return this.compareTo((UOSignature)o) == 0;
        }

        public int hashCode() {
            return this.version ^ (this.type == null ? 0 : this.type.hashCode()) ^ (this.className == null ? 0 : this.className.hashCode());
        }
    }
}

