/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.List;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class BooleanExpression
extends SQLExpression {
    boolean hasClosure = false;

    public BooleanExpression(SQLStatement stmt, JavaTypeMapping mapping, String sql) {
        super(stmt, null, mapping);
        this.st.clearStatement();
        this.st.append(sql);
    }

    public BooleanExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public BooleanExpression(SQLStatement stmt, JavaTypeMapping mapping) {
        super(stmt, null, mapping);
        this.hasClosure = true;
    }

    public BooleanExpression(Expression.MonadicOperator op, SQLExpression expr1) {
        super(op, expr1);
        this.hasClosure = true;
    }

    public BooleanExpression(SQLExpression expr1, Expression.DyadicOperator op, SQLExpression expr2) {
        super(expr1, op, expr2);
        if (expr1 instanceof NumericExpression && expr2 instanceof NumericExpression && (op == Expression.OP_EQ || op == Expression.OP_GT || op == Expression.OP_GTEQ || op == Expression.OP_NOTEQ || op == Expression.OP_LT || op == Expression.OP_LTEQ)) {
            this.mapping = this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false);
        }
        this.hasClosure = true;
    }

    public boolean hasClosure() {
        return this.hasClosure;
    }

    public BooleanExpression and(SQLExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.and(this);
        }
        if (expr instanceof BooleanExpression) {
            return new BooleanExpression(this, Expression.OP_AND, expr);
        }
        return super.and(expr);
    }

    public BooleanExpression eor(SQLExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.eor(this);
        }
        if (expr instanceof BooleanExpression) {
            if (this.stmt.getDatabaseAdapter().supportsOption("BooleanExpression")) {
                return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
            }
            return this.and(expr.not()).ior(this.not().and(expr));
        }
        return super.eor(expr);
    }

    public BooleanExpression ior(SQLExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.ior(this);
        }
        if (expr instanceof BooleanExpression) {
            return new BooleanExpression(this, Expression.OP_OR, expr);
        }
        return super.ior(expr);
    }

    public BooleanExpression not() {
        if (!this.hasClosure) {
            return new BooleanExpression(this, Expression.OP_EQ, new BooleanLiteral(this.stmt, this.mapping, Boolean.FALSE, null));
        }
        return new BooleanExpression(Expression.OP_NOT, this);
    }

    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof BooleanLiteral || expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof BooleanExpression) {
            DatastoreMapping datastoreMapping = this.mapping.getDatastoreMapping(0);
            if (datastoreMapping.isStringBased()) {
                return new BooleanExpression(new CharacterExpression(this.stmt, this.table, this.mapping), Expression.OP_EQ, new CharacterExpression(this.stmt, expr.table, expr.mapping));
            }
            if ((datastoreMapping.isBitBased() || datastoreMapping.isIntegerBased()) && !this.stmt.getDatabaseAdapter().supportsOption("BitIsReallyBoolean")) {
                return new BooleanExpression(new NumericExpression(this.stmt, this.table, this.mapping), Expression.OP_EQ, new NumericExpression(this.stmt, expr.table, expr.mapping));
            }
            if (this.stmt.getDatabaseAdapter().supportsOption("BooleanExpression")) {
                return new BooleanExpression(this, Expression.OP_EQ, expr);
            }
            return this.and(expr).ior(this.not().and(expr.not()));
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof BooleanLiteral || expr instanceof NullLiteral) {
            return expr.ne(this);
        }
        if (expr instanceof BooleanExpression) {
            DatastoreMapping datastoreMapping = this.mapping.getDatastoreMapping(0);
            if (datastoreMapping.isStringBased()) {
                return new BooleanExpression(new CharacterExpression(this.stmt, this.table, this.mapping), Expression.OP_NOTEQ, new CharacterExpression(this.stmt, expr.table, expr.mapping));
            }
            if ((datastoreMapping.isBitBased() || datastoreMapping.isIntegerBased()) && !this.stmt.getDatabaseAdapter().supportsOption("BitIsReallyBoolean")) {
                return new BooleanExpression(new NumericExpression(this.stmt, this.table, this.mapping), Expression.OP_NOTEQ, new NumericExpression(this.stmt, expr.table, expr.mapping));
            }
            if (this.stmt.getDatabaseAdapter().supportsOption("BooleanExpression")) {
                return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
            }
            return this.and(expr.not()).ior(this.not().and(expr));
        }
        return super.ne(expr);
    }

    public BooleanExpression in(SQLExpression expr, boolean not) {
        DatastoreMapping datastoreMapping = this.mapping.getDatastoreMapping(0);
        if (datastoreMapping.isStringBased()) {
            return new BooleanExpression(new CharacterExpression(this.stmt, this.table, this.mapping), not ? Expression.OP_NOTIN : Expression.OP_IN, expr);
        }
        return new BooleanExpression(this, not ? Expression.OP_NOTIN : Expression.OP_IN, expr);
    }

    public SQLExpression invoke(String methodName, List args) {
        return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, Boolean.class.getName(), methodName, this, args);
    }

    public BooleanExpression neg() {
        return new BooleanExpression(Expression.OP_NEG, this);
    }
}

