/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementParameterMapping;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.DynamicSchemaFieldManager;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.AbstractSetStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractSetStoreSpecialization;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.types.sco.SCOMtoN;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSJoinSetStore
extends AbstractSetStore {
    protected String locateStmt;
    protected String maxOrderColumnIdStmt;
    private String iteratorStmtLocked = null;
    private String iteratorStmtUnlocked = null;
    private StatementClassMapping iteratorMappingClass = null;
    private StatementParameterMapping iteratorMappingParams = null;

    public RDBMSJoinSetStore(AbstractMemberMetaData mmd, CollectionTable joinTable, ClassLoaderResolver clr) {
        super((StoreManager)joinTable.getStoreManager(), clr, new RDBMSJoinSetStoreSpecialization(LOCALISER, clr, (RDBMSStoreManager)joinTable.getStoreManager()));
        this.containerTable = joinTable;
        this.setOwner(mmd, clr);
        this.ownerMapping = joinTable.getOwnerMapping();
        this.elementMapping = joinTable.getElementMapping();
        this.orderMapping = joinTable.getOrderMapping();
        this.relationDiscriminatorMapping = joinTable.getRelationDiscriminatorMapping();
        this.relationDiscriminatorValue = joinTable.getRelationDiscriminatorValue();
        this.elementType = mmd.getCollection().getElementType();
        this.elementsAreEmbedded = joinTable.isEmbeddedElement();
        this.elementsAreSerialised = joinTable.isSerialisedElement();
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (ClassUtils.isReferenceType((Class)element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, 3, clr, this.storeMgr.getMetaDataManager());
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
                this.elementInfo = this.emd != null && !this.elementsAreEmbedded ? this.getElementInformationForClass() : null;
            }
        }
    }

    private RDBMSStoreManager getStoreMgr() {
        return (RDBMSStoreManager)this.storeMgr;
    }

    private RDBMSAbstractSetStoreSpecialization getSpecialization() {
        return (RDBMSAbstractSetStoreSpecialization)this.specialization;
    }

    public void update(ObjectProvider sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        if (this.ownerMemberMetaData.getCollection().isSerializedElement() || this.ownerMemberMetaData.getCollection().isEmbeddedElement()) {
            this.clear(sm);
            this.addAll(sm, coll, 0);
            return;
        }
        Iterator elemIter = this.iterator(sm);
        HashSet existing = new HashSet();
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.size() != coll.size()) {
            for (Object elem : coll) {
                if (existing.contains(elem)) continue;
                this.add(sm, elem, 0);
            }
        }
    }

    public boolean removeAll(ObjectProvider sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = this.removeAllInternal(sm, elements, size);
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            sm.getExecutionContext().deleteObjects(elements.toArray());
        }
        return modified;
    }

    private boolean elementAlreadyContainsOwnerInMtoN(ObjectProvider ownerSM, Object element) {
        AbstractMemberMetaData[] relatedMmds;
        ExecutionContext ec = ownerSM.getExecutionContext();
        ObjectProvider elementSM = ec.findObjectProvider(element);
        Object elementSCO = elementSM.provideField((relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(ec.getClassLoaderResolver()))[0].getAbsoluteFieldNumber());
        if (elementSCO instanceof SCOMtoN) {
            if (this.contains(ownerSM, element)) {
                NucleusLogger.DATASTORE.info((Object)LOCALISER.msg("056040", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
                return true;
            }
        } else if (this.locate(ownerSM, element)) {
            NucleusLogger.DATASTORE.info((Object)LOCALISER.msg("056040", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ObjectProvider sm, Object element, int size) {
        ObjectProvider elementSM;
        ExecutionContext ec = sm.getExecutionContext();
        this.validateElementForWriting(ec, element, null);
        if (this.relationType == 4 && (elementSM = ec.findObjectProvider(element)) != null) {
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.PERSISTENCE.info((Object)LOCALISER.msg("056037", (Object)sm.toPrintableID(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject());
            } else if (elementOwner != sm.getObject() && sm.getReferencedPC() == null) {
                throw new NucleusUserException(LOCALISER.msg("056038", (Object)sm.toPrintableID(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject()), (Object)StringUtils.toJVMIDString((Object)elementOwner)));
            }
        }
        boolean modified = false;
        boolean toBeInserted = true;
        if (this.relationType == 5) {
            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
        }
        if (toBeInserted) {
            try {
                ManagedConnection mconn = this.storeMgr.getConnection(ec);
                try {
                    int[] returnCode;
                    int orderID = -1;
                    if (this.orderMapping != null) {
                        orderID = this.getNextIDForOrderColumn(sm);
                    }
                    if ((returnCode = this.internalAdd(sm, element, mconn, false, orderID, true))[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException e) {
                NucleusLogger.DATASTORE.error((Object)e);
                String msg = LOCALISER.msg("056009", (Object)e.getMessage());
                NucleusLogger.DATASTORE.error((Object)msg);
                throw new NucleusDataStoreException(msg, (Throwable)e);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(ObjectProvider sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<MappedDatastoreException> exceptions = new ArrayList<MappedDatastoreException>();
        boolean batched = elements.size() > 1;
        ExecutionContext ec = sm.getExecutionContext();
        for (Object element : elements) {
            ObjectProvider elementSM;
            this.validateElementForWriting(ec, element, null);
            if (this.relationType != 4 || (elementSM = sm.getExecutionContext().findObjectProvider(element)) == null) continue;
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.PERSISTENCE.info((Object)LOCALISER.msg("056037", (Object)sm.toPrintableID(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject());
                continue;
            }
            if (elementOwner == sm.getObject() || sm.getReferencedPC() != null) continue;
            throw new NucleusUserException(LOCALISER.msg("056038", (Object)sm.toPrintableID(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject()), (Object)StringUtils.toJVMIDString((Object)elementOwner)));
        }
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                this.preGetNextIDForOrderColumn(mconn);
                int nextOrderID = 0;
                if (this.orderMapping != null) {
                    nextOrderID = this.getNextIDForOrderColumn(sm);
                }
                Iterator iter = elements.iterator();
                Object element = null;
                while (iter.hasNext()) {
                    element = iter.next();
                    try {
                        int[] rc = this.internalAdd(sm, element, mconn, batched, nextOrderID, !batched || batched && !iter.hasNext());
                        if (rc != null) {
                            for (int i = 0; i < rc.length; ++i) {
                                if (rc[i] <= 0) continue;
                                modified = true;
                            }
                        }
                        ++nextOrderID;
                    }
                    catch (MappedDatastoreException mde) {
                        exceptions.add(mde);
                        NucleusLogger.DATASTORE.error((Object)"Exception thrown", (Throwable)mde);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            exceptions.add(e);
            NucleusLogger.DATASTORE.error((Object)"Exception thrown", (Throwable)e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("056009", (Object)((Exception)exceptions.get(0)).getMessage());
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), sm.getObject());
        }
        return modified;
    }

    private int[] internalAdd(ObjectProvider sm, Object element, ManagedConnection conn, boolean batched, int orderId, boolean executeNow) throws MappedDatastoreException {
        boolean toBeInserted = true;
        if (this.relationType == 5) {
            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
        }
        if (toBeInserted) {
            return this.doInternalAdd(sm, element, conn, batched, orderId, executeNow);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeAllInternal(ObjectProvider sm, Collection elements, int size) {
        boolean modified = false;
        String removeAllStmt = this.getRemoveAllStmt(sm, elements);
        try {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.getStoreMgr().getConnection(ec);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, removeAllStmt, false);
                try {
                    int jdbcPosition = 1;
                    for (Object element : elements) {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                        jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                        if (this.relationDiscriminatorMapping == null) continue;
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    int[] number = sqlControl.executeStatementUpdate(mconn, removeAllStmt, ps, true);
                    if (number[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new NucleusDataStoreException(LOCALISER.msg("056012", (Object)removeAllStmt), (Throwable)e);
        }
        return modified;
    }

    protected String getRemoveStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        stmt.append(this.ownerMapping.getDatastoreMapping(0).getDatastoreField().getIdentifier().toString());
        stmt.append(" = ");
        stmt.append(((RDBMSMapping)this.ownerMapping.getDatastoreMapping(0)).getUpdateInputParameter());
        for (i = 1; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
            stmt.append(" AND ");
            stmt.append(this.ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreMappings(); ++i) {
            stmt.append(" AND ");
            stmt.append(this.elementMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
            if (this.elementsAreSerialised) {
                stmt.append(" LIKE ");
            } else {
                stmt.append(" = ");
            }
            stmt.append(((RDBMSMapping)this.elementMapping.getDatastoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(" AND ");
                stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    protected String getRemoveAllStmt(ObjectProvider ownerSm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        Iterator elementsIter = elements.iterator();
        boolean first = true;
        while (elementsIter.hasNext()) {
            int i;
            elementsIter.next();
            if (first) {
                stmt.append("(");
            } else {
                stmt.append(" OR (");
            }
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(this.ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(" AND ");
                stmt.append(this.elementMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                if (this.elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append(" = ");
                }
                stmt.append(((RDBMSMapping)this.elementMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(")");
            first = false;
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean locate(ObjectProvider sm, Object element) {
        boolean exists = true;
        String stmt = this.getLocateStmt();
        try {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.getStoreMgr().getConnection(ec);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        if (!rs.next()) {
                            exists = false;
                        }
                    }
                    catch (SQLException sqle) {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new NucleusDataStoreException(LOCALISER.msg("RDBMS.SCO.LocateRequestFailed", (Object)stmt), (Throwable)e);
        }
        return exists;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int[] doInternalAdd(ObjectProvider sm, Object element, ManagedConnection conn, boolean batched, int orderId, boolean executeNow) throws MappedDatastoreException {
        if (this.storeMgr.getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager((RDBMSStoreManager)this.storeMgr, sm);
            HashSet<Object> coll = new HashSet<Object>();
            coll.add(element);
            dynamicSchemaFM.storeObjectField(this.ownerMemberMetaData.getAbsoluteFieldNumber(), coll);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                this.getSpecialization().invalidateAddStmt();
            }
        }
        String addStmt = this.getSpecialization().getAddStmt(this);
        boolean notYetFlushedError = false;
        ExecutionContext ec = sm.getExecutionContext();
        SQLController sqlControl = this.getStoreMgr().getSQLController();
        try {
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, batched);
            try {
                int jdbcPosition = 1;
                jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                if (this.orderMapping != null) {
                    jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, orderId, jdbcPosition, this.orderMapping);
                }
                if (this.relationDiscriminatorMapping != null) {
                    jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                }
                int[] nArray = sqlControl.executeStatementUpdate(conn, addStmt, ps, executeNow);
                return nArray;
            }
            catch (NotYetFlushedException nfe) {
                notYetFlushedError = true;
                throw nfe;
            }
            finally {
                if (notYetFlushedError) {
                    sqlControl.abortStatementForConnection(conn, ps);
                } else {
                    sqlControl.closeStatement(conn, ps);
                }
            }
        }
        catch (SQLException e) {
            throw new MappedDatastoreException(addStmt, (Throwable)e);
        }
    }

    private String getLocateStmt() {
        if (this.locateStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT 1 FROM ");
            stmt.append(this.containerTable.toString());
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(this.ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append("=");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDatastoreMapping(i)).getInsertionInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(" AND ");
                stmt.append(this.elementMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                if (this.elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append("=");
                }
                stmt.append(((RDBMSMapping)this.elementMapping.getDatastoreMapping(i)).getInsertionInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append("=");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDatastoreMapping(i)).getInsertionInputParameter());
                }
            }
            this.locateStmt = stmt.toString();
        }
        return this.locateStmt;
    }

    protected void preGetNextIDForOrderColumn(ManagedConnection mconn) throws MappedDatastoreException {
        SQLController sqlControl = this.getStoreMgr().getSQLController();
        try {
            sqlControl.processStatementsForConnection(mconn);
        }
        catch (SQLException e) {
            throw new MappedDatastoreException("SQLException", (Throwable)e);
        }
    }

    private String getMaxOrderColumnIdStmt() {
        if (this.maxOrderColumnIdStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT MAX(" + this.orderMapping.getDatastoreMapping(0).getDatastoreField().getIdentifier().toString() + ")");
            stmt.append(" FROM ");
            stmt.append(this.containerTable.toString());
            stmt.append(" WHERE ");
            stmt.append(this.ownerMapping.getDatastoreMapping(0).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDatastoreMapping(0)).getUpdateInputParameter());
            for (i = 1; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(" AND ");
                stmt.append(this.ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 1; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.maxOrderColumnIdStmt = stmt.toString();
        }
        return this.maxOrderColumnIdStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextIDForOrderColumn(ObjectProvider sm) {
        int nextID;
        ExecutionContext ec = sm.getExecutionContext();
        String stmt = this.getMaxOrderColumnIdStmt();
        try {
            ManagedConnection mconn = this.getStoreMgr().getConnection(ec);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                    if (this.relationDiscriminatorMapping != null) {
                        BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        nextID = !rs.next() ? 1 : rs.getInt(1) + 1;
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056020", (Object)stmt), (Throwable)e);
        }
        return nextID;
    }

    /*
     * Exception decompiling
     */
    public Iterator iterator(ObjectProvider ownerSM) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected SQLStatement getSQLStatementForIterator(ObjectProvider ownerSM) {
        SQLStatement sqlStmt = null;
        ClassLoaderResolver clr = ownerSM.getExecutionContext().getClassLoaderResolver();
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.storeMgr;
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            sqlStmt = new SQLStatement(storeMgr, this.containerTable, null, null);
            sqlStmt.setClassLoaderResolver(clr);
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.elementMapping, null);
        } else if (this.elementMapping instanceof ReferenceMapping) {
            sqlStmt = new SQLStatement(storeMgr, this.containerTable, null, null);
            sqlStmt.setClassLoaderResolver(clr);
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.elementMapping, null);
        } else {
            this.iteratorMappingClass = new StatementClassMapping();
            for (int i = 0; i < this.elementInfo.length; ++i) {
                int elementNo = i;
                Class elementCls = clr.classForName(this.elementInfo[elementNo].getClassName());
                SQLStatement elementStmt = null;
                if (this.elementInfo[elementNo].getDiscriminatorStrategy() != null && this.elementInfo[elementNo].getDiscriminatorStrategy() != DiscriminatorStrategy.NONE) {
                    String elementType = this.ownerMemberMetaData.getCollection().getElementType();
                    if (ClassUtils.isReferenceType((Class)clr.classForName(elementType))) {
                        String[] clsNames = storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, clr);
                        Class[] cls = new Class[clsNames.length];
                        for (int j = 0; j < clsNames.length; ++j) {
                            cls[j] = clr.classForName(clsNames[j]);
                        }
                        DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(storeMgr, clr, cls, true, null, null, this.containerTable, null, this.elementMapping);
                        if (this.allowNulls) {
                            stmtGen.setOption("allowNulls");
                        }
                        elementStmt = stmtGen.getStatement();
                    } else {
                        DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(storeMgr, clr, elementCls, true, null, null, this.containerTable, null, this.elementMapping);
                        if (this.allowNulls) {
                            stmtGen.setOption("allowNulls");
                        }
                        elementStmt = stmtGen.getStatement();
                    }
                    this.iterateUsingDiscriminator = true;
                } else {
                    UnionStatementGenerator stmtGen = new UnionStatementGenerator(storeMgr, clr, elementCls, true, null, null, this.containerTable, null, this.elementMapping);
                    stmtGen.setOption("selectNucleusType");
                    this.iteratorMappingClass.setNucleusTypeColumnName("NUCLEUS_TYPE");
                    elementStmt = stmtGen.getStatement();
                }
                if (sqlStmt == null) {
                    sqlStmt = elementStmt;
                    continue;
                }
                sqlStmt.union(elementStmt);
            }
            SQLTable elementSqlTbl = sqlStmt.getTable((DatastoreContainerObject)this.elementInfo[0].getDatastoreClass(), sqlStmt.getPrimaryTable().getGroupName());
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.iteratorMappingClass, ownerSM.getExecutionContext().getFetchPlan(), elementSqlTbl, this.emd, 0);
        }
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            SQLTable distSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.relationDiscriminatorMapping);
            SQLExpression distExpr = exprFactory.newExpression(sqlStmt, distSqlTbl, this.relationDiscriminatorMapping);
            SQLExpression distVal = exprFactory.newLiteral(sqlStmt, this.relationDiscriminatorMapping, this.relationDiscriminatorValue);
            sqlStmt.whereAnd(distExpr.eq(distVal), true);
        }
        if (this.orderMapping != null) {
            SQLTable orderSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
            SQLExpression[] orderExprs = new SQLExpression[this.orderMapping.getNumberOfDatastoreMappings()];
            boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreMappings()];
            orderExprs[0] = exprFactory.newExpression(sqlStmt, orderSqlTbl, this.orderMapping);
            sqlStmt.setOrdering(orderExprs, descendingOrder);
        }
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        if (sqlStmt.getNumberOfUnions() > 0) {
            for (int j = 0; j < sqlStmt.getNumberOfUnions() + 1; ++j) {
                int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
                for (int k = 0; k < paramPositions.length; ++k) {
                    paramPositions[k] = inputParamNum++;
                }
                ownerIdx.addParameterOccurrence(paramPositions);
            }
        } else {
            int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
            for (int k = 0; k < paramPositions.length; ++k) {
                paramPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(paramPositions);
        }
        this.iteratorMappingParams = new StatementParameterMapping();
        this.iteratorMappingParams.addMappingForParameter("owner", ownerIdx);
        return sqlStmt;
    }

    private static class RDBMSJoinSetStoreSpecialization
    extends RDBMSAbstractSetStoreSpecialization {
        private RDBMSJoinSetStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, RDBMSStoreManager storeMgr) {
            super(localiser, clr, storeMgr);
        }

        protected String getRemoveStmt(ElementContainerStore ecs) {
            return ((RDBMSJoinSetStore)ecs).getRemoveStmt();
        }
    }
}

