/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage.utils;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.wso2.carbon.hadoop.hive.jdbc.storage.datasource.CarbonDataSourceFetcher;
import org.wso2.carbon.hadoop.hive.jdbc.storage.utils.Commons;

public class ConfigurationUtils {
    public static final String HIVE_JDBC_UPDATE_ON_DUPLICATE = "hive.jdbc.update.on.duplicate";
    public static final String HIVE_JDBC_PRIMARY_KEY_FIELDS = "hive.jdbc.primary.key.fields";
    public static final String HIVE_JDBC_COLUMNS_MAPPING = "hive.jdbc.columns.mapping";
    public static final String HIVE_JDBC_TABLE_CREATE_QUERY = "hive.jdbc.table.create.query";
    public static final String HIVE_JDBC_OUTPUT_UPSERT_QUERY = "hive.jdbc.output.upsert.query";
    public static final String HIVE_JDBC_UPSERT_QUERY_VALUES_ORDER = "hive.jdbc.upsert.query.values.order";
    public static final String HIVE_PROP_CARBON_DS_NAME = "wso2.carbon.datasource.name";
    public static final String[] ALL_PROPERTIES = new String[]{"mapred.jdbc.driver.class", "mapred.jdbc.username", "mapred.jdbc.password", "mapred.jdbc.url", "mapred.jdbc.output.table.name", "mapred.jdbc.output.field.names", "mapred.jdbc.input.table.name", "name", "hive.jdbc.update.on.duplicate", "hive.jdbc.primary.key.fields", "hive.jdbc.columns.mapping", "hive.jdbc.table.create.query", "hive.jdbc.output.upsert.query", "hive.jdbc.upsert.query.values.order", "wso2.carbon.datasource.name"};

    public static void copyJDBCProperties(Properties from, Map<String, String> to) {
        for (String key : ALL_PROPERTIES) {
            String value = from.getProperty(key);
            if (value == null) continue;
            to.put(key, value);
            if (!key.equals(HIVE_PROP_CARBON_DS_NAME)) continue;
            ConfigurationUtils.addingProperties(value, to);
        }
    }

    private static void addingProperties(String dataSourceName, Map<String, String> to) {
        CarbonDataSourceFetcher carbonDataSourceFetcher = new CarbonDataSourceFetcher();
        Map<String, String> dataSource = carbonDataSourceFetcher.getCarbonDataSource(dataSourceName);
        to.putAll(dataSource);
    }

    public static final String getOutputTableName(Configuration configuration) {
        String tableName = configuration.get("mapred.jdbc.output.table.name");
        if (tableName == null) {
            String createTableQuery = configuration.get(HIVE_JDBC_TABLE_CREATE_QUERY);
            if (createTableQuery != null) {
                tableName = Commons.extractingTableNameFromQuery(createTableQuery);
            } else {
                tableName = configuration.get("name");
                if (tableName.contains("default.")) {
                    tableName = tableName.replace("default.", "");
                }
            }
        }
        return tableName;
    }

    public static final String getInputTableName(Configuration configuration) {
        String inputTableName = configuration.get("mapred.jdbc.input.table.name");
        if (inputTableName == null && (inputTableName = configuration.get("name")).contains("default.")) {
            inputTableName = inputTableName.replace("default.", "");
        }
        return inputTableName.trim();
    }

    public static final String getConnectionUrl(Configuration conf) {
        return conf.get("mapred.jdbc.url");
    }

    public static final String getDriverClass(Configuration conf) {
        return conf.get("mapred.jdbc.driver.class");
    }

    public static final String getDatabaseUserName(Configuration conf) {
        return conf.get("mapred.jdbc.username");
    }

    public static final String getDatabasePassword(Configuration conf) {
        return conf.get("mapred.jdbc.password");
    }

    public static final String[] getInputFieldNames(Configuration conf) {
        String[] fieldNames = null;
        String inputFieldNames = conf.get("mapred.jdbc.input.field.names");
        if (inputFieldNames != null) {
            fieldNames = inputFieldNames.split(",");
        } else {
            String selectQuery = conf.get("hive.query.string");
            fieldNames = Commons.extractFieldNames(selectQuery).split(",");
        }
        return fieldNames;
    }

    public static final String[] getOutputFieldNames(Configuration conf) {
        String[] fieldNames = null;
        String outputFieldNames = conf.get("mapred.jdbc.output.field.names");
        if (outputFieldNames != null) {
            fieldNames = outputFieldNames.split(",");
        }
        return fieldNames;
    }

    public static final boolean isUpdateOnDuplicate(Configuration conf) {
        return Boolean.parseBoolean(conf.get(HIVE_JDBC_UPDATE_ON_DUPLICATE));
    }

    public static final String[] getPrimaryKeyFields(Configuration conf) {
        String primaryKeyFields = conf.get(HIVE_JDBC_PRIMARY_KEY_FIELDS);
        if (primaryKeyFields != null) {
            return ConfigurationUtils.convertingToLowerCase(primaryKeyFields.split(","));
        }
        return null;
    }

    private static String[] convertingToLowerCase(String[] primaryKeyFields) {
        if (primaryKeyFields != null) {
            String[] fields = new String[primaryKeyFields.length];
            for (int i = 0; i < primaryKeyFields.length; ++i) {
                fields[i] = primaryKeyFields[i].toLowerCase();
            }
            return fields;
        }
        return null;
    }

    public static final String[] getColumnMappingFields(Configuration conf) {
        String mappingFields = conf.get(HIVE_JDBC_COLUMNS_MAPPING);
        if (mappingFields != null) {
            return mappingFields.split(",");
        }
        return null;
    }

    public static String getDbSpecificUpdateQuery(JobConf conf) {
        return conf.get(HIVE_JDBC_OUTPUT_UPSERT_QUERY);
    }

    public static String[] getUpsertQueryValuesOrder(JobConf conf) {
        String valuesOrder = conf.get(HIVE_JDBC_UPSERT_QUERY_VALUES_ORDER);
        String[] order = null;
        if (valuesOrder != null) {
            valuesOrder = valuesOrder.trim();
            order = valuesOrder.split(",");
        }
        return order;
    }

    public static String getWso2CarbonDataSourceName(JobConf conf) {
        return conf.get(HIVE_PROP_CARBON_DS_NAME);
    }

    public static String isDefaultAutoCommit(JobConf conf) {
        return conf.get("defaultAutoCommit");
    }

    public static String isDefaultReadOnly(JobConf conf) {
        return conf.get("defaultReadOnly");
    }

    public static String getDefaultCatalog(JobConf conf) {
        return conf.get("defaultCatalog");
    }

    public static String getDefaultTransactionIsolation(JobConf conf) {
        return conf.get("defaultTransactionIsolation");
    }

    public static String isTestOnBorrow(JobConf conf) {
        return conf.get("testOnBorrow");
    }

    public static String isTestOnReturn(JobConf conf) {
        return conf.get("testOnReturn");
    }

    public static String getTimeBetweenEvictionRunsMillis(JobConf conf) {
        return conf.get("timeBetweenEvictionRunsMillis");
    }

    public static String getNumTestsPerEvictionRun(JobConf conf) {
        return conf.get("numTestsPerEvictionRun");
    }

    public static String getMinEvictableIdleTimeMillis(JobConf conf) {
        return conf.get("minEvictableIdleTimeMillis");
    }

    public static String isTestWhileIdle(JobConf conf) {
        return conf.get("testWhileIdle");
    }

    public static String getValidationQuery(JobConf conf) {
        return conf.get("validationQuery");
    }

    public static String getMaxActive(JobConf conf) {
        return conf.get("maxActive");
    }

    public static String getMaxIdle(JobConf conf) {
        return conf.get("maxIdle");
    }

    public static String getMaxWait(JobConf conf) {
        return conf.get("maxWait");
    }

    public static String getMinIdle(JobConf conf) {
        return conf.get("minIdle");
    }

    public static String getInitialSize(JobConf conf) {
        return conf.get("initialSize");
    }

    public static String isAccessToUnderlyingConnectionAllowed(JobConf conf) {
        return conf.get("accessToUnderlyingConnectionAllowed");
    }

    public static String isRemoveAbandoned(JobConf conf) {
        return conf.get("removeAbandoned");
    }

    public static String getRemoveAbandonedTimeout(JobConf conf) {
        return conf.get("removeAbandonedTimeout");
    }

    public static String isLogAbandoned(JobConf conf) {
        return conf.get("logAbandoned");
    }
}

