/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage.utils;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.wso2.carbon.hadoop.hive.jdbc.storage.utils.ConfigurationUtils;

public class Commons {
    public static Object getObjectFromWritable(Writable w) {
        if (w instanceof IntWritable) {
            return ((IntWritable)w).get();
        }
        if (w instanceof ShortWritable) {
            return ((ShortWritable)w).get();
        }
        if (w instanceof ByteWritable) {
            return ((ByteWritable)w).get();
        }
        if (w instanceof BooleanWritable) {
            return ((BooleanWritable)w).get();
        }
        if (w instanceof LongWritable) {
            return ((LongWritable)w).get();
        }
        if (w instanceof FloatWritable) {
            return Float.valueOf(((FloatWritable)w).get());
        }
        if (w instanceof DoubleWritable) {
            return ((DoubleWritable)w).get();
        }
        if (w instanceof NullWritable) {
            return null;
        }
        return w.toString();
    }

    public static PreparedStatement assignCorrectObjectType(Object value, int position, PreparedStatement statement) {
        try {
            if (value instanceof Integer) {
                statement.setInt(position, (Integer)value);
            } else if (value instanceof Short) {
                statement.setShort(position, (Short)value);
            } else if (value instanceof Byte) {
                statement.setByte(position, (Byte)value);
            } else if (value instanceof Boolean) {
                statement.setBoolean(position, (Boolean)value);
            } else if (value instanceof Long) {
                statement.setLong(position, (Long)value);
            } else if (value instanceof Float) {
                statement.setFloat(position, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                statement.setDouble(position, (Double)value);
            } else {
                statement.setString(position, value.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return statement;
    }

    public static final String extractingTableNameFromQuery(String createTableQuery) {
        String tableName = null;
        if (createTableQuery != null) {
            List<String> queryList = Arrays.asList(createTableQuery.split(" "));
            Iterator<String> iterator = queryList.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equalsIgnoreCase("create")) continue;
                while (iterator.hasNext()) {
                    if (!iterator.next().equalsIgnoreCase("table")) continue;
                    while (iterator.hasNext()) {
                        String nextString = iterator.next();
                        if (nextString.equalsIgnoreCase("")) continue;
                        tableName = nextString;
                        return tableName;
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("You should provide at least mapred.jdbc.output.table.name or hive.jdbc.table.create.query property.");
        }
        return tableName;
    }

    public static final String extractFieldNames(String selectQuery) {
        String fields = "";
        List<String> queryList = Arrays.asList(selectQuery.split(" "));
        Iterator<String> iterator = queryList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equalsIgnoreCase("select")) continue;
            while (iterator.hasNext()) {
                String nextString = iterator.next();
                if (nextString.equalsIgnoreCase("from")) {
                    return fields;
                }
                fields = fields + nextString;
            }
        }
        return fields;
    }

    public static BasicDataSource configureBasicDataSource(JobConf conf) {
        BasicDataSource basicDataSource = new BasicDataSource();
        String connectionUrl = ConfigurationUtils.getConnectionUrl((Configuration)conf);
        connectionUrl = connectionUrl.replaceAll(" ", "");
        basicDataSource.setUrl(connectionUrl);
        basicDataSource.setDriverClassName(ConfigurationUtils.getDriverClass((Configuration)conf));
        basicDataSource.setUsername(ConfigurationUtils.getDatabaseUserName((Configuration)conf));
        basicDataSource.setPassword(ConfigurationUtils.getDatabasePassword((Configuration)conf));
        if (ConfigurationUtils.getWso2CarbonDataSourceName(conf) != null) {
            String logAbandoned;
            String removeAbandonedTimeout;
            String removeAbandoned;
            String accessToUnderlyingConnectionAllowed;
            String initialSize;
            String minIdle;
            String maxWait;
            String maxIdle;
            String maxActive;
            String validationQuery;
            String testWhileIdle;
            String minEvictableIdleTimeMillis;
            String numTestsPerEvictionRun;
            String timeBetweenEvictionRunsMillis;
            String testOnReturn;
            String testOnBorrow;
            String defaultTransactionIsolation;
            String defaultCatalog;
            String defaultReadOnly;
            String defaultAutoCommit = ConfigurationUtils.isDefaultAutoCommit(conf);
            if (defaultAutoCommit != null) {
                basicDataSource.setDefaultAutoCommit(Boolean.parseBoolean(defaultAutoCommit));
            }
            if ((defaultReadOnly = ConfigurationUtils.isDefaultReadOnly(conf)) != null) {
                basicDataSource.setDefaultReadOnly(Boolean.parseBoolean(defaultReadOnly));
            }
            if ((defaultCatalog = ConfigurationUtils.getDefaultCatalog(conf)) != null) {
                basicDataSource.setDefaultCatalog(defaultCatalog);
            }
            if ((defaultTransactionIsolation = ConfigurationUtils.getDefaultTransactionIsolation(conf)) != null) {
                basicDataSource.setDefaultTransactionIsolation(Integer.parseInt(defaultTransactionIsolation));
            }
            if ((testOnBorrow = ConfigurationUtils.isTestOnBorrow(conf)) != null) {
                basicDataSource.setTestOnBorrow(Boolean.parseBoolean(testOnBorrow));
            }
            if ((testOnReturn = ConfigurationUtils.isTestOnReturn(conf)) != null) {
                basicDataSource.setTestOnReturn(Boolean.parseBoolean(testOnReturn));
            }
            if ((timeBetweenEvictionRunsMillis = ConfigurationUtils.getTimeBetweenEvictionRunsMillis(conf)) != null) {
                basicDataSource.setTimeBetweenEvictionRunsMillis(Long.parseLong(timeBetweenEvictionRunsMillis));
            }
            if ((numTestsPerEvictionRun = ConfigurationUtils.getNumTestsPerEvictionRun(conf)) != null) {
                basicDataSource.setNumTestsPerEvictionRun(Integer.parseInt(numTestsPerEvictionRun));
            }
            if ((minEvictableIdleTimeMillis = ConfigurationUtils.getMinEvictableIdleTimeMillis(conf)) != null) {
                basicDataSource.setMinEvictableIdleTimeMillis(Long.parseLong(minEvictableIdleTimeMillis));
            }
            if ((testWhileIdle = ConfigurationUtils.isTestWhileIdle(conf)) != null) {
                basicDataSource.setTestWhileIdle(Boolean.parseBoolean(testWhileIdle));
            }
            if ((validationQuery = ConfigurationUtils.getValidationQuery(conf)) != null) {
                basicDataSource.setValidationQuery(validationQuery);
            }
            if ((maxActive = ConfigurationUtils.getMaxActive(conf)) != null) {
                basicDataSource.setMaxActive(Integer.parseInt(maxActive));
            }
            if ((maxIdle = ConfigurationUtils.getMaxIdle(conf)) != null) {
                basicDataSource.setMaxIdle(Integer.parseInt(maxIdle));
            }
            if ((maxWait = ConfigurationUtils.getMaxWait(conf)) != null) {
                basicDataSource.setMaxWait(Long.parseLong(maxWait));
            }
            if ((minIdle = ConfigurationUtils.getMinIdle(conf)) != null) {
                basicDataSource.setMinIdle(Integer.parseInt(minIdle));
            }
            if ((initialSize = ConfigurationUtils.getInitialSize(conf)) != null) {
                basicDataSource.setInitialSize(Integer.parseInt(initialSize));
            }
            if ((accessToUnderlyingConnectionAllowed = ConfigurationUtils.isAccessToUnderlyingConnectionAllowed(conf)) != null) {
                basicDataSource.setAccessToUnderlyingConnectionAllowed(Boolean.parseBoolean(accessToUnderlyingConnectionAllowed));
            }
            if ((removeAbandoned = ConfigurationUtils.isRemoveAbandoned(conf)) != null) {
                basicDataSource.setRemoveAbandoned(Boolean.parseBoolean(removeAbandoned));
            }
            if ((removeAbandonedTimeout = ConfigurationUtils.getRemoveAbandonedTimeout(conf)) != null) {
                basicDataSource.setRemoveAbandonedTimeout(Integer.parseInt(removeAbandonedTimeout));
            }
            if ((logAbandoned = ConfigurationUtils.isLogAbandoned(conf)) != null) {
                basicDataSource.setLogAbandoned(Boolean.parseBoolean(logAbandoned));
            }
        }
        return basicDataSource;
    }
}

