/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.hadoop.mapred.JobConf;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DatabaseType;
import org.wso2.carbon.hadoop.hive.jdbc.storage.exception.UnsupportedDatabaseException;
import org.wso2.carbon.hadoop.hive.jdbc.storage.utils.Commons;

public class DBManager {
    private DataSource dataSource;

    public void setDataSource(DataSource dSource) {
        this.dataSource = dSource;
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException {
        return this.dataSource.getConnection();
    }

    public DatabaseType getDatabaseName(Connection connection) throws UnsupportedDatabaseException {
        String connectionUrl = null;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            connectionUrl = metaData.getURL();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.getDatabaseType(connectionUrl.split(":")[1]);
    }

    public DatabaseType getDatabaseType(String databaseName) throws UnsupportedDatabaseException {
        DatabaseType databaseType = null;
        if (databaseName.equalsIgnoreCase("mysql")) {
            databaseType = DatabaseType.MYSQL;
        } else if (databaseName.equalsIgnoreCase("microsoft")) {
            databaseType = DatabaseType.SQLSERVER;
        } else if (databaseName.equalsIgnoreCase("oracle")) {
            databaseType = DatabaseType.ORACLE;
        } else if (databaseName.equalsIgnoreCase("h2")) {
            databaseType = DatabaseType.H2;
        } else if (databaseName.equalsIgnoreCase("postgresql")) {
            databaseType = DatabaseType.POSTGRESQL;
        } else {
            throw new UnsupportedDatabaseException("Your database type doesn't support by hive jdbc-handler to fetch results");
        }
        return databaseType;
    }

    public void configureDB(JobConf conf) {
        BasicDataSource basicDataSource = Commons.configureBasicDataSource(conf);
        this.setDataSource((DataSource)basicDataSource);
    }
}

