/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.wso2.carbon.hadoop.hive.jdbc.storage.JDBCDataOutputFormat;
import org.wso2.carbon.hadoop.hive.jdbc.storage.JDBCDataSerDe;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DBOperation;
import org.wso2.carbon.hadoop.hive.jdbc.storage.input.JDBCDataInputFormat;
import org.wso2.carbon.hadoop.hive.jdbc.storage.utils.ConfigurationUtils;

public class JDBCStorageHandler
implements HiveStorageHandler,
HiveMetaHook {
    private Configuration conf;

    @Override
    public Class<? extends InputFormat> getInputFormatClass() {
        return JDBCDataInputFormat.class;
    }

    @Override
    public Class<? extends OutputFormat> getOutputFormatClass() {
        return JDBCDataOutputFormat.class;
    }

    @Override
    public Class<? extends SerDe> getSerDeClass() {
        return JDBCDataSerDe.class;
    }

    @Override
    public HiveMetaHook getMetaHook() {
        return this;
    }

    @Override
    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties properties = tableDesc.getProperties();
        ConfigurationUtils.copyJDBCProperties(properties, jobProperties);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void preCreateTable(Table table) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable(table);
        if (!isExternal) {
            throw new MetaException("Tables must be external.");
        }
        Map<String, String> tableParameters = table.getParameters();
        DBOperation operation = new DBOperation();
        operation.createTableIfNotExist(tableParameters);
    }

    @Override
    public void rollbackCreateTable(Table table) throws MetaException {
    }

    @Override
    public void commitCreateTable(Table table) throws MetaException {
    }

    @Override
    public void preDropTable(Table table) throws MetaException {
    }

    @Override
    public void rollbackDropTable(Table table) throws MetaException {
    }

    @Override
    public void commitDropTable(Table table, boolean b) throws MetaException {
    }
}

