/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.thrift.DelegationTokenIdentifier;
import org.apache.hadoop.hive.thrift.TokenStoreDelegationTokenSecretManager;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.HiveDelegationTokenSupport;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperTokenStore
implements TokenStoreDelegationTokenSecretManager.TokenStore {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ZooKeeperTokenStore.class.getName());
    private static final String ZK_SEQ_FORMAT = "%010d";
    private static final String NODE_KEYS = "/keys";
    private static final String NODE_TOKENS = "/tokens";
    private String rootNode = "";
    private volatile ZooKeeper zkSession;
    private String zkConnectString;
    private final int zkSessionTimeout = 3000;

    protected ZooKeeperTokenStore() {
    }

    public ZooKeeperTokenStore(String hostPort) {
        this.zkConnectString = hostPort;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooKeeper getSession() {
        if (this.zkSession == null || this.zkSession.getState() == ZooKeeper.States.CLOSED) {
            ZooKeeperTokenStore zooKeeperTokenStore = this;
            synchronized (zooKeeperTokenStore) {
                if (this.zkSession == null || this.zkSession.getState() == ZooKeeper.States.CLOSED) {
                    try {
                        this.zkSession = new ZooKeeper(this.zkConnectString, this.zkSessionTimeout, (Watcher)new ZooKeeperWatcher());
                    }
                    catch (IOException ex) {
                        throw new TokenStoreDelegationTokenSecretManager.TokenStoreError("Token store error.", ex);
                    }
                }
            }
        }
        return this.zkSession;
    }

    private static String ensurePath(ZooKeeper zk, String path) throws KeeperException, InterruptedException {
        String[] pathComps = StringUtils.splitByWholeSeparator((String)path, (String)"/");
        String currentPath = "";
        for (String pathComp : pathComps) {
            currentPath = currentPath + "/" + pathComp;
            try {
                String node = zk.create(currentPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                LOGGER.info("Created path: " + node);
            }
            catch (KeeperException.NodeExistsException e) {
                // empty catch block
            }
        }
        return currentPath;
    }

    private void init() {
        if (this.zkConnectString == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.zkSession != null) {
            try {
                this.zkSession.close();
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Failed to close existing session.", (Throwable)ex);
            }
        }
        ZooKeeper zk = this.getSession();
        try {
            ZooKeeperTokenStore.ensurePath(zk, this.rootNode + NODE_KEYS);
            ZooKeeperTokenStore.ensurePath(zk, this.rootNode + NODE_TOKENS);
        }
        catch (Exception e) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError("Failed to validate token path.", e);
        }
    }

    public void setConf(Configuration conf) {
        if (conf != null) {
            this.zkConnectString = conf.get("hive.cluster.delegation.token.store.zookeeper.connectString", null);
            this.rootNode = conf.get("hive.cluster.delegation.token.store.zookeeper.rootNode", "/hive/cluster/delegation");
        }
        this.init();
    }

    public Configuration getConf() {
        return null;
    }

    private Map<Integer, byte[]> getAllKeys() throws KeeperException, InterruptedException {
        String masterKeyNode = this.rootNode + NODE_KEYS;
        ZooKeeper zk = this.getSession();
        List nodes = zk.getChildren(masterKeyNode, false);
        HashMap<Integer, byte[]> result = new HashMap<Integer, byte[]>();
        for (String node : nodes) {
            byte[] data = zk.getData(masterKeyNode + "/" + node, false, null);
            if (data == null) continue;
            result.put(this.getSeq(node), data);
        }
        return result;
    }

    private int getSeq(String path) {
        String[] pathComps = path.split("/");
        return Integer.parseInt(pathComps[pathComps.length - 1]);
    }

    @Override
    public int addMasterKey(String s) {
        try {
            ZooKeeper zk = this.getSession();
            String newNode = zk.create(this.rootNode + NODE_KEYS + "/", s.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            LOGGER.info("Added key {}", (Object)newNode);
            return this.getSeq(newNode);
        }
        catch (KeeperException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
        catch (InterruptedException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
    }

    @Override
    public void updateMasterKey(int keySeq, String s) {
        try {
            ZooKeeper zk = this.getSession();
            zk.setData(this.rootNode + NODE_KEYS + "/" + String.format(ZK_SEQ_FORMAT, keySeq), s.getBytes(), -1);
        }
        catch (KeeperException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
        catch (InterruptedException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
    }

    @Override
    public boolean removeMasterKey(int keySeq) {
        try {
            ZooKeeper zk = this.getSession();
            zk.delete(this.rootNode + NODE_KEYS + "/" + String.format(ZK_SEQ_FORMAT, keySeq), -1);
            return true;
        }
        catch (KeeperException.NoNodeException ex) {
            return false;
        }
        catch (KeeperException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
        catch (InterruptedException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
    }

    @Override
    public String[] getMasterKeys() {
        try {
            Map<Integer, byte[]> allKeys = this.getAllKeys();
            String[] result = new String[allKeys.size()];
            int resultIdx = 0;
            for (byte[] keyBytes : allKeys.values()) {
                result[resultIdx++] = new String(keyBytes);
            }
            return result;
        }
        catch (KeeperException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
        catch (InterruptedException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
    }

    private String getTokenPath(DelegationTokenIdentifier tokenIdentifier) {
        try {
            return this.rootNode + NODE_TOKENS + "/" + TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)tokenIdentifier);
        }
        catch (IOException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError("Failed to encode token identifier", ex);
        }
    }

    @Override
    public boolean addToken(DelegationTokenIdentifier tokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation token) {
        try {
            ZooKeeper zk = this.getSession();
            byte[] tokenBytes = HiveDelegationTokenSupport.encodeDelegationTokenInformation((AbstractDelegationTokenSecretManager.DelegationTokenInformation)token);
            String newNode = zk.create(this.getTokenPath(tokenIdentifier), tokenBytes, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            LOGGER.info("Added token: {}", (Object)newNode);
            return true;
        }
        catch (KeeperException.NodeExistsException ex) {
            return false;
        }
        catch (KeeperException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
        catch (InterruptedException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
    }

    @Override
    public boolean removeToken(DelegationTokenIdentifier tokenIdentifier) {
        try {
            ZooKeeper zk = this.getSession();
            zk.delete(this.getTokenPath(tokenIdentifier), -1);
            return true;
        }
        catch (KeeperException.NoNodeException ex) {
            return false;
        }
        catch (KeeperException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
        catch (InterruptedException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
    }

    @Override
    public AbstractDelegationTokenSecretManager.DelegationTokenInformation getToken(DelegationTokenIdentifier tokenIdentifier) {
        try {
            ZooKeeper zk = this.getSession();
            byte[] tokenBytes = zk.getData(this.getTokenPath(tokenIdentifier), false, null);
            try {
                return HiveDelegationTokenSupport.decodeDelegationTokenInformation((byte[])tokenBytes);
            }
            catch (Exception ex) {
                throw new TokenStoreDelegationTokenSecretManager.TokenStoreError("Failed to decode token", ex);
            }
        }
        catch (KeeperException.NoNodeException ex) {
            return null;
        }
        catch (KeeperException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
        catch (InterruptedException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
    }

    @Override
    public List<DelegationTokenIdentifier> getAllDelegationTokenIdentifiers() {
        List nodes;
        String containerNode = this.rootNode + NODE_TOKENS;
        try {
            nodes = this.getSession().getChildren(containerNode, false);
        }
        catch (KeeperException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
        catch (InterruptedException ex) {
            throw new TokenStoreDelegationTokenSecretManager.TokenStoreError(ex);
        }
        ArrayList<DelegationTokenIdentifier> result = new ArrayList<DelegationTokenIdentifier>(nodes.size());
        for (String node : nodes) {
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            try {
                TokenStoreDelegationTokenSecretManager.decodeWritable((Writable)id, node);
                result.add(id);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to decode token '{}'", (Object)node);
            }
        }
        return result;
    }

    private class ZooKeeperWatcher
    implements Watcher {
        private ZooKeeperWatcher() {
        }

        public void process(WatchedEvent event) {
            LOGGER.info(event.toString());
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                LOGGER.warn("ZooKeeper session expired, discarding connection");
                try {
                    ZooKeeperTokenStore.this.zkSession.close();
                }
                catch (Throwable e) {
                    LOGGER.warn("Failed to close connection on expired session", e);
                }
            }
        }
    }
}

