/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hive.thrift.TFilterTransport;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class TUGIContainingTransport
extends TFilterTransport {
    private UserGroupInformation ugi;

    public TUGIContainingTransport(TTransport wrapped, UserGroupInformation ugi) {
        super(wrapped);
    }

    public UserGroupInformation getClientUGI() {
        return this.ugi;
    }

    public void setClientUGI(UserGroupInformation ugi) {
        this.ugi = ugi;
    }

    public static class Factory
    extends TTransportFactory {
        private static final ConcurrentMap<TTransport, TUGIContainingTransport> transMap = new MapMaker().weakKeys().makeMap();

        @Override
        public TUGIContainingTransport getTransport(TTransport trans) {
            transMap.putIfAbsent(trans, new TUGIContainingTransport(trans, null));
            return (TUGIContainingTransport)transMap.get(trans);
        }
    }
}

