/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.CassandraLazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import org.apache.hadoop.io.LongWritable;

public class CassandraLazyLong
extends CassandraLazyPrimitive<LazyLongObjectInspector, LongWritable> {
    public CassandraLazyLong(LazyLongObjectInspector oi) {
        super(oi);
        this.data = new LongWritable();
    }

    @Override
    public void parseBytes(ByteArrayRef bytes, int start, int length) {
        this.setData(LazyLong.parseLong(bytes.getData(), start, length));
    }

    @Override
    public void parsePrimitiveBytes(ByteArrayRef bytes, int start, int length) {
        ByteBuffer buf = ByteBuffer.wrap(bytes.getData(), start, length);
        this.setData(buf.getLong(buf.position()));
    }

    @Override
    public void setPrimitiveSize() {
        this.primitiveSize = 8;
    }

    private void setData(long num) {
        ((LongWritable)this.data).set(num);
        this.isNull = false;
    }
}

