/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.CassandraLazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

public class CassandraLazyInteger
extends CassandraLazyPrimitive<LazyIntObjectInspector, IntWritable> {
    public CassandraLazyInteger(LazyIntObjectInspector oi) {
        super(oi);
        this.data = new IntWritable();
    }

    @Override
    public void parseBytes(ByteArrayRef bytes, int start, int length) {
        this.setData(LazyInteger.parseInt(bytes.getData(), start, length));
    }

    @Override
    public void parsePrimitiveBytes(ByteArrayRef bytes, int start, int length) {
        ByteBuffer buf = ByteBuffer.wrap(bytes.getData(), start, length);
        this.setData(buf.getInt(buf.position()));
    }

    @Override
    public void setPrimitiveSize() {
        this.primitiveSize = 4;
    }

    private void setData(int num) {
        ((IntWritable)this.data).set(num);
        this.isNull = false;
    }
}

