/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

@Explain(displayName="Select Operator")
public class SelectDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<ExprNodeDesc> colList;
    private ArrayList<String> outputColumnNames;
    private boolean selectStar;
    private boolean selStarNoCompute;

    public SelectDesc() {
    }

    public SelectDesc(boolean selStarNoCompute) {
        this.selStarNoCompute = selStarNoCompute;
    }

    public SelectDesc(ArrayList<ExprNodeDesc> colList, ArrayList<String> outputColumnNames) {
        this(colList, outputColumnNames, false);
    }

    public SelectDesc(ArrayList<ExprNodeDesc> colList, ArrayList<String> outputColumnNames, boolean selectStar) {
        this.colList = colList;
        this.selectStar = selectStar;
        this.outputColumnNames = outputColumnNames;
    }

    public SelectDesc(ArrayList<ExprNodeDesc> colList, boolean selectStar, boolean selStarNoCompute) {
        this.colList = colList;
        this.selectStar = selectStar;
        this.selStarNoCompute = selStarNoCompute;
    }

    @Explain(displayName="expressions")
    public ArrayList<ExprNodeDesc> getColList() {
        return this.colList;
    }

    public void setColList(ArrayList<ExprNodeDesc> colList) {
        this.colList = colList;
    }

    @Explain(displayName="outputColumnNames")
    public ArrayList<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(ArrayList<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    @Explain(displayName="SELECT * ")
    public String explainNoCompute() {
        if (this.isSelStarNoCompute()) {
            return "(no compute)";
        }
        return null;
    }

    public boolean isSelectStar() {
        return this.selectStar;
    }

    public void setSelectStar(boolean selectStar) {
        this.selectStar = selectStar;
    }

    public boolean isSelStarNoCompute() {
        return this.selStarNoCompute;
    }

    public void setSelStarNoCompute(boolean selStarNoCompute) {
        this.selStarNoCompute = selStarNoCompute;
    }
}

