/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class ConditionalResolverMergeFiles
implements ConditionalResolver,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Task<? extends Serializable>> getTasks(HiveConf conf, Object objCtx) {
        ConditionalResolverMergeFilesCtx ctx = (ConditionalResolverMergeFilesCtx)objCtx;
        String dirName = ctx.getDir();
        ArrayList<Task<? extends Serializable>> resTsks = new ArrayList<Task<? extends Serializable>>();
        long trgtSize = conf.getLongVar(HiveConf.ConfVars.HIVEMERGEMAPFILESSIZE);
        long avgConditionSize = conf.getLongVar(HiveConf.ConfVars.HIVEMERGEMAPFILESAVGSIZE);
        trgtSize = Math.max(trgtSize, avgConditionSize);
        Task<? extends Serializable> mvTask = ctx.getListTasks().get(0);
        Task<? extends Serializable> mrTask = ctx.getListTasks().get(1);
        try {
            Path dirPath = new Path(dirName);
            FileSystem inpFs = dirPath.getFileSystem((Configuration)conf);
            DynamicPartitionCtx dpCtx = ctx.getDPCtx();
            if (inpFs.exists(dirPath)) {
                MapredWork work = (MapredWork)mrTask.getWork();
                if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                    FileStatus[] status = Utilities.getFileStatusRecurse(dirPath, dpCtx.getNumDPCols(), inpFs);
                    LinkedHashMap<String, PartitionDesc> ptpi = work.getPathToPartitionInfo();
                    assert (ptpi.size() == 1);
                    String path = (String)ptpi.keySet().iterator().next();
                    TableDesc tblDesc = ((PartitionDesc)ptpi.get(path)).getTableDesc();
                    ptpi.remove(path);
                    LinkedHashMap<String, ArrayList<String>> pta = work.getPathToAliases();
                    assert (pta.size() == 1);
                    path = (String)pta.keySet().iterator().next();
                    ArrayList aliases = (ArrayList)pta.get(path);
                    pta.remove(path);
                    long totalSz = 0L;
                    boolean doMerge = false;
                    ArrayList<String> toMove = new ArrayList<String>();
                    for (int i = 0; i < status.length; ++i) {
                        long len = this.getMergeSize(inpFs, status[i].getPath(), avgConditionSize);
                        if (len >= 0L) {
                            doMerge = true;
                            totalSz += len;
                            LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>(dpCtx.getPartSpec());
                            Warehouse.makeSpecFromName(fullPartSpec, status[i].getPath());
                            PartitionDesc pDesc = new PartitionDesc(tblDesc, fullPartSpec);
                            work.resolveDynamicPartitionMerge(conf, status[i].getPath(), tblDesc, aliases, pDesc);
                            continue;
                        }
                        toMove.add(status[i].getPath().toString());
                    }
                    if (doMerge) {
                        this.setupMapRedWork(conf, work, trgtSize, totalSz);
                        resTsks.add(mrTask);
                        if (toMove.size() > 0) {
                            MoveWork mvWork = (MoveWork)mvTask.getWork();
                            LoadFileDesc lfd = mvWork.getLoadFileWork();
                            String targetDir = lfd.getTargetDir();
                            ArrayList<String> targetDirs = new ArrayList<String>(toMove.size());
                            int numDPCols = dpCtx.getNumDPCols();
                            for (int i = 0; i < toMove.size(); ++i) {
                                String toMoveStr = (String)toMove.get(i);
                                if (toMoveStr.endsWith("/")) {
                                    toMoveStr = toMoveStr.substring(0, toMoveStr.length() - 1);
                                }
                                String[] moveStrSplits = toMoveStr.split("/");
                                String target = targetDir;
                                for (int dpIndex = moveStrSplits.length - numDPCols; dpIndex < moveStrSplits.length; ++dpIndex) {
                                    target = target + "/" + moveStrSplits[dpIndex];
                                }
                                targetDirs.add(target);
                            }
                            LoadMultiFilesDesc lmfd = new LoadMultiFilesDesc(toMove, targetDirs, lfd.getIsDfsDir(), lfd.getColumns(), lfd.getColumnTypes());
                            mvWork.setLoadFileWork(null);
                            mvWork.setLoadTableWork(null);
                            mvWork.setMultiFilesDesc(lmfd);
                            List<Task<Serializable>> cTasks = mrTask.getDependentTasks();
                            if (cTasks != null) {
                                Iterator<Task<Serializable>> itr = cTasks.iterator();
                                while (itr.hasNext()) {
                                    Task<Serializable> cld = itr.next();
                                    itr.remove();
                                    mvTask.addDependentTask(cld);
                                }
                            }
                            mrTask.addDependentTask(mvTask);
                        }
                    } else {
                        resTsks.add(mvTask);
                    }
                } else {
                    long totalSz = this.getMergeSize(inpFs, dirPath, avgConditionSize);
                    if (totalSz >= 0L) {
                        this.setupMapRedWork(conf, work, trgtSize, totalSz);
                        resTsks.add(mrTask);
                    } else {
                        resTsks.add(mvTask);
                    }
                }
            } else {
                resTsks.add(mvTask);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resTsks;
    }

    private void setupMapRedWork(HiveConf conf, MapredWork work, long targetSize, long totalSize) {
        if (work.getNumReduceTasks() > 0) {
            int maxReducers = conf.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
            int reducers = (int)((totalSize + targetSize - 1L) / targetSize);
            reducers = Math.max(1, reducers);
            reducers = Math.min(maxReducers, reducers);
            work.setNumReduceTasks(reducers);
        }
        work.setMaxSplitSize(targetSize);
        work.setMinSplitSize(targetSize);
        work.setMinSplitSizePerNode(targetSize);
        work.setMinSplitSizePerRack(targetSize);
    }

    private long getMergeSize(FileSystem inpFs, Path dirPath, long avgSize) {
        try {
            FileStatus[] fStats = inpFs.listStatus(dirPath);
            if (fStats.length <= 1) {
                return -1L;
            }
            long totalSz = 0L;
            for (FileStatus fStat : fStats) {
                totalSz += fStat.getLen();
            }
            if (totalSz < avgSize * (long)fStats.length) {
                return totalSz;
            }
            return -1L;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public static class ConditionalResolverMergeFilesCtx
    implements Serializable {
        private static final long serialVersionUID = 1L;
        List<Task<? extends Serializable>> listTasks;
        private String dir;
        private DynamicPartitionCtx dpCtx;

        public ConditionalResolverMergeFilesCtx() {
        }

        public ConditionalResolverMergeFilesCtx(List<Task<? extends Serializable>> listTasks, String dir) {
            this.listTasks = listTasks;
            this.dir = dir;
        }

        public String getDir() {
            return this.dir;
        }

        public void setDir(String dir) {
            this.dir = dir;
        }

        public List<Task<? extends Serializable>> getListTasks() {
            return this.listTasks;
        }

        public void setListTasks(List<Task<? extends Serializable>> listTasks) {
            this.listTasks = listTasks;
        }

        public DynamicPartitionCtx getDPCtx() {
            return this.dpCtx;
        }

        public void setDPCtx(DynamicPartitionCtx dp) {
            this.dpCtx = dp;
        }
    }
}

