/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;

public class Table
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.metadata.Table");
    private org.apache.hadoop.hive.metastore.api.Table tTable;
    private Deserializer deserializer;
    private Class<? extends HiveOutputFormat> outputFormatClass;
    private Class<? extends InputFormat> inputFormatClass;
    private URI uri;
    private HiveStorageHandler storageHandler;

    public Table() {
    }

    public Table(org.apache.hadoop.hive.metastore.api.Table table) {
        this.tTable = table;
        if (!this.isView()) {
            this.getInputFormatClass();
            this.getOutputFormatClass();
        }
    }

    public Table(String databaseName, String tableName) {
        this(Table.getEmptyTable(databaseName, tableName));
    }

    public org.apache.hadoop.hive.metastore.api.Table getTTable() {
        return this.tTable;
    }

    public void setTTable(org.apache.hadoop.hive.metastore.api.Table tTable) {
        this.tTable = tTable;
    }

    static org.apache.hadoop.hive.metastore.api.Table getEmptyTable(String databaseName, String tableName) {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setSerdeInfo(new SerDeInfo());
        sd.setNumBuckets(-1);
        sd.setBucketCols(new ArrayList<String>());
        sd.setCols(new ArrayList<FieldSchema>());
        sd.setParameters(new HashMap<String, String>());
        sd.setSortCols(new ArrayList<Order>());
        sd.getSerdeInfo().setParameters(new HashMap<String, String>());
        sd.getSerdeInfo().setSerializationLib(MetadataTypedColumnsetSerDe.class.getName());
        sd.getSerdeInfo().getParameters().put("serialization.format", "1");
        sd.setInputFormat(SequenceFileInputFormat.class.getName());
        sd.setOutputFormat(HiveSequenceFileOutputFormat.class.getName());
        org.apache.hadoop.hive.metastore.api.Table t = new org.apache.hadoop.hive.metastore.api.Table();
        t.setSd(sd);
        t.setPartitionKeys(new ArrayList<FieldSchema>());
        t.setParameters(new HashMap<String, String>());
        t.setTableType(TableType.MANAGED_TABLE.toString());
        t.setDbName(databaseName);
        t.setTableName(tableName);
        return t;
    }

    public void checkValidity() throws HiveException {
        String name = this.tTable.getTableName();
        if (null == name || name.length() == 0 || !MetaStoreUtils.validateName(name)) {
            throw new HiveException("[" + name + "]: is not a valid table name");
        }
        if (0 == this.getCols().size()) {
            throw new HiveException("at least one column must be specified for the table");
        }
        if (!this.isView()) {
            if (null == this.getDeserializerFromMetaStore()) {
                throw new HiveException("must specify a non-null serDe");
            }
            if (null == this.getInputFormatClass()) {
                throw new HiveException("must specify an InputFormat class");
            }
            if (null == this.getOutputFormatClass()) {
                throw new HiveException("must specify an OutputFormat class");
            }
        }
        if (this.isView()) {
            assert (this.getViewOriginalText() != null);
            assert (this.getViewExpandedText() != null);
        } else {
            assert (this.getViewOriginalText() == null);
            assert (this.getViewExpandedText() == null);
        }
        Iterator<FieldSchema> iterCols = this.getCols().iterator();
        ArrayList<String> colNames = new ArrayList<String>();
        while (iterCols.hasNext()) {
            String colName = iterCols.next().getName();
            for (String oldColName : colNames) {
                if (!colName.equalsIgnoreCase(oldColName)) continue;
                throw new HiveException("Duplicate column name " + colName + " in the table definition.");
            }
            colNames.add(colName.toLowerCase());
        }
        if (this.getPartCols() != null) {
            Iterator<FieldSchema> partColsIter = this.getPartCols().iterator();
            while (partColsIter.hasNext()) {
                String partCol = partColsIter.next().getName();
                if (!colNames.contains(partCol.toLowerCase())) continue;
                throw new HiveException("Partition column name " + partCol + " conflicts with table columns.");
            }
        }
    }

    public void setInputFormatClass(Class<? extends InputFormat> inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
        this.tTable.getSd().setInputFormat(inputFormatClass.getName());
    }

    public void setOutputFormatClass(Class<? extends HiveOutputFormat> outputFormatClass) {
        this.outputFormatClass = outputFormatClass;
        this.tTable.getSd().setOutputFormat(outputFormatClass.getName());
    }

    public final Properties getSchema() {
        return MetaStoreUtils.getSchema(this.tTable);
    }

    public final Path getPath() {
        String location = this.tTable.getSd().getLocation();
        if (location == null) {
            return null;
        }
        return new Path(location);
    }

    public final String getTableName() {
        return this.tTable.getTableName();
    }

    public final URI getDataLocation() {
        Path path;
        if (this.uri == null && (path = this.getPath()) != null) {
            this.uri = path.toUri();
        }
        return this.uri;
    }

    public final Deserializer getDeserializer() {
        if (this.deserializer == null) {
            this.deserializer = this.getDeserializerFromMetaStore();
        }
        return this.deserializer;
    }

    private Deserializer getDeserializerFromMetaStore() {
        try {
            return MetaStoreUtils.getDeserializer((Configuration)Hive.get().getConf(), this.tTable);
        }
        catch (MetaException e) {
            throw new RuntimeException(e);
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    public HiveStorageHandler getStorageHandler() {
        if (this.storageHandler != null) {
            return this.storageHandler;
        }
        try {
            this.storageHandler = HiveUtils.getStorageHandler(Hive.get().getConf(), this.getProperty("storage_handler"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.storageHandler;
    }

    public final Class<? extends InputFormat> getInputFormatClass() {
        if (this.inputFormatClass == null) {
            try {
                String className = this.tTable.getSd().getInputFormat();
                if (className == null) {
                    if (this.getStorageHandler() == null) {
                        return null;
                    }
                    this.inputFormatClass = this.getStorageHandler().getInputFormatClass();
                } else {
                    this.inputFormatClass = Class.forName(className, true, JavaUtils.getClassLoader());
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.inputFormatClass;
    }

    public final Class<? extends HiveOutputFormat> getOutputFormatClass() {
        if (this.outputFormatClass == null) {
            try {
                Class<Object> c;
                String className = this.tTable.getSd().getOutputFormat();
                if (className == null) {
                    if (this.getStorageHandler() == null) {
                        return null;
                    }
                    c = this.getStorageHandler().getOutputFormatClass();
                } else {
                    c = Class.forName(className, true, JavaUtils.getClassLoader());
                }
                this.outputFormatClass = !HiveOutputFormat.class.isAssignableFrom(c) ? HiveFileFormatUtils.getOutputFormatSubstitute(c) : c;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.outputFormatClass;
    }

    public final boolean isValidSpec(Map<String, String> spec) throws HiveException {
        List<FieldSchema> partCols = this.tTable.getPartitionKeys();
        if (partCols == null || partCols.size() == 0) {
            if (spec != null) {
                throw new HiveException("table is not partitioned but partition spec exists: " + spec);
            }
            return true;
        }
        if (spec == null || spec.size() != partCols.size()) {
            throw new HiveException("table is partitioned but partition spec is not specified or does not fully match table partitioning: " + spec);
        }
        for (FieldSchema field : partCols) {
            if (spec.get(field.getName()) != null) continue;
            throw new HiveException(field.getName() + " not found in table's partition spec: " + spec);
        }
        return true;
    }

    public void setProperty(String name, String value) {
        this.tTable.getParameters().put(name, value);
    }

    public String getProperty(String name) {
        return this.tTable.getParameters().get(name);
    }

    public void setTableType(TableType tableType) {
        this.tTable.setTableType(tableType.toString());
    }

    public TableType getTableType() {
        return Enum.valueOf(TableType.class, this.tTable.getTableType());
    }

    public ArrayList<StructField> getFields() {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        try {
            Deserializer decoder = this.getDeserializer();
            StructObjectInspector structObjectInspector = (StructObjectInspector)decoder.getObjectInspector();
            List<? extends StructField> fld_lst = structObjectInspector.getAllStructFieldRefs();
            for (StructField structField : fld_lst) {
                fields.add(structField);
            }
        }
        catch (SerDeException e) {
            throw new RuntimeException(e);
        }
        return fields;
    }

    public StructField getField(String fld) {
        try {
            StructObjectInspector structObjectInspector = (StructObjectInspector)this.getDeserializer().getObjectInspector();
            return structObjectInspector.getStructFieldRef(fld);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.tTable.getTableName();
    }

    public List<FieldSchema> getPartCols() {
        List<FieldSchema> partKeys = this.tTable.getPartitionKeys();
        if (partKeys == null) {
            partKeys = new ArrayList<FieldSchema>();
            this.tTable.setPartitionKeys(partKeys);
        }
        return partKeys;
    }

    public boolean isPartitionKey(String colName) {
        for (FieldSchema key : this.getPartCols()) {
            if (!key.getName().toLowerCase().equals(colName)) continue;
            return true;
        }
        return false;
    }

    public String getBucketingDimensionId() {
        List<String> bcols = this.tTable.getSd().getBucketCols();
        if (bcols == null || bcols.size() == 0) {
            return null;
        }
        if (bcols.size() > 1) {
            LOG.warn((Object)(this + " table has more than one dimensions which aren't supported yet"));
        }
        return bcols.get(0);
    }

    public void setDataLocation(URI uri) {
        this.uri = uri;
        this.tTable.getSd().setLocation(uri.toString());
    }

    public void unsetDataLocation() {
        this.uri = null;
        this.tTable.getSd().unsetLocation();
    }

    public void setBucketCols(List<String> bucketCols) throws HiveException {
        if (bucketCols == null) {
            return;
        }
        for (String col : bucketCols) {
            if (this.isField(col)) continue;
            throw new HiveException("Bucket columns " + col + " is not part of the table columns (" + this.getCols());
        }
        this.tTable.getSd().setBucketCols(bucketCols);
    }

    public void setSortCols(List<Order> sortOrder) throws HiveException {
        this.tTable.getSd().setSortCols(sortOrder);
    }

    private boolean isField(String col) {
        for (FieldSchema field : this.getCols()) {
            if (!field.getName().equals(col)) continue;
            return true;
        }
        return false;
    }

    public List<FieldSchema> getCols() {
        boolean getColsFromSerDe = SerDeUtils.shouldGetColsFromSerDe(this.getSerializationLib());
        if (!getColsFromSerDe) {
            return this.tTable.getSd().getCols();
        }
        try {
            return Hive.getFieldsFromDeserializer(this.getTableName(), this.getDeserializer());
        }
        catch (HiveException e) {
            LOG.error((Object)("Unable to get field from serde: " + this.getSerializationLib()), (Throwable)e);
            return new ArrayList<FieldSchema>();
        }
    }

    public List<FieldSchema> getAllCols() {
        ArrayList<FieldSchema> f_list = new ArrayList<FieldSchema>();
        f_list.addAll(this.getPartCols());
        f_list.addAll(this.getCols());
        return f_list;
    }

    public void setPartCols(List<FieldSchema> partCols) {
        this.tTable.setPartitionKeys(partCols);
    }

    public String getDbName() {
        return this.tTable.getDbName();
    }

    public int getNumBuckets() {
        return this.tTable.getSd().getNumBuckets();
    }

    protected void replaceFiles(Path srcf) throws HiveException {
        Path tableDest = new Path(this.getDataLocation().getPath());
        Hive.replaceFiles(srcf, tableDest, tableDest, Hive.get().getConf());
    }

    protected void copyFiles(Path srcf) throws HiveException {
        try {
            FileSystem fs = FileSystem.get((URI)this.getDataLocation(), (Configuration)Hive.get().getConf());
            Hive.copyFiles(srcf, new Path(this.getDataLocation().getPath()), fs);
        }
        catch (IOException e) {
            throw new HiveException("addFiles: filesystem error in check phase", e);
        }
    }

    public void setInputFormatClass(String name) throws HiveException {
        if (name == null) {
            this.inputFormatClass = null;
            this.tTable.getSd().setInputFormat(null);
            return;
        }
        try {
            this.setInputFormatClass(Class.forName(name, true, JavaUtils.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Class not found: " + name, e);
        }
    }

    public void setOutputFormatClass(String name) throws HiveException {
        if (name == null) {
            this.outputFormatClass = null;
            this.tTable.getSd().setOutputFormat(null);
            return;
        }
        try {
            Class<?> origin = Class.forName(name, true, JavaUtils.getClassLoader());
            this.setOutputFormatClass(HiveFileFormatUtils.getOutputFormatSubstitute(origin));
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Class not found: " + name, e);
        }
    }

    public boolean isPartitioned() {
        if (this.getPartCols() == null) {
            return false;
        }
        return this.getPartCols().size() != 0;
    }

    public void setFields(List<FieldSchema> fields) {
        this.tTable.getSd().setCols(fields);
    }

    public void setNumBuckets(int nb) {
        this.tTable.getSd().setNumBuckets(nb);
    }

    public String getOwner() {
        return this.tTable.getOwner();
    }

    public Map<String, String> getParameters() {
        return this.tTable.getParameters();
    }

    public int getRetention() {
        return this.tTable.getRetention();
    }

    public void setOwner(String owner) {
        this.tTable.setOwner(owner);
    }

    public void setRetention(int retention) {
        this.tTable.setRetention(retention);
    }

    private SerDeInfo getSerdeInfo() {
        return this.tTable.getSd().getSerdeInfo();
    }

    public void setSerializationLib(String lib) {
        this.getSerdeInfo().setSerializationLib(lib);
    }

    public String getSerializationLib() {
        return this.getSerdeInfo().getSerializationLib();
    }

    public String getSerdeParam(String param) {
        return this.getSerdeInfo().getParameters().get(param);
    }

    public String setSerdeParam(String param, String value) {
        return this.getSerdeInfo().getParameters().put(param, value);
    }

    public List<String> getBucketCols() {
        return this.tTable.getSd().getBucketCols();
    }

    public List<Order> getSortCols() {
        return this.tTable.getSd().getSortCols();
    }

    public void setTableName(String tableName) {
        this.tTable.setTableName(tableName);
    }

    public void setDbName(String databaseName) {
        this.tTable.setDbName(databaseName);
    }

    public List<FieldSchema> getPartitionKeys() {
        return this.tTable.getPartitionKeys();
    }

    public String getViewOriginalText() {
        return this.tTable.getViewOriginalText();
    }

    public void setViewOriginalText(String viewOriginalText) {
        this.tTable.setViewOriginalText(viewOriginalText);
    }

    public String getViewExpandedText() {
        return this.tTable.getViewExpandedText();
    }

    public void clearSerDeInfo() {
        this.tTable.getSd().getSerdeInfo().getParameters().clear();
    }

    public void setViewExpandedText(String viewExpandedText) {
        this.tTable.setViewExpandedText(viewExpandedText);
    }

    public boolean isView() {
        return TableType.VIRTUAL_VIEW.equals((Object)this.getTableType());
    }

    public boolean isIndexTable() {
        return TableType.INDEX_TABLE.equals((Object)this.getTableType());
    }

    public LinkedHashMap<String, String> createSpec(Partition tp) {
        List<FieldSchema> fsl = this.getPartCols();
        List<String> tpl = tp.getValues();
        LinkedHashMap<String, String> spec = new LinkedHashMap<String, String>();
        for (int i = 0; i < fsl.size(); ++i) {
            FieldSchema fs = fsl.get(i);
            String value = tpl.get(i);
            spec.put(fs.getName(), value);
        }
        return spec;
    }

    public Table copy() throws HiveException {
        return new Table(this.tTable.deepCopy());
    }

    public void setCreateTime(int createTime) {
        this.tTable.setCreateTime(createTime);
    }

    public int getLastAccessTime() {
        return this.tTable.getLastAccessTime();
    }

    public void setLastAccessTime(int lastAccessTime) {
        this.tTable.setLastAccessTime(lastAccessTime);
    }

    public boolean isNonNative() {
        return this.getProperty("storage_handler") != null;
    }

    public void setProtectMode(ProtectMode protectMode) {
        Map<String, String> parameters = this.tTable.getParameters();
        parameters.put(ProtectMode.PARAMETER_NAME, protectMode.toString());
        this.tTable.setParameters(parameters);
    }

    public ProtectMode getProtectMode() {
        Map<String, String> parameters = this.tTable.getParameters();
        if (!parameters.containsKey(ProtectMode.PARAMETER_NAME)) {
            return new ProtectMode();
        }
        return ProtectMode.getProtectModeFromString(parameters.get(ProtectMode.PARAMETER_NAME));
    }

    public boolean isOffline() {
        return this.getProtectMode().offline;
    }

    public boolean canDrop() {
        ProtectMode mode = this.getProtectMode();
        return !mode.noDrop && !mode.offline && !mode.readOnly && !mode.noDropCascade;
    }

    public boolean canWrite() {
        ProtectMode mode = this.getProtectMode();
        return !mode.offline && !mode.readOnly;
    }

    public String getCompleteName() {
        return this.getDbName() + "@" + this.getTableName();
    }

    public List<Index> getAllIndexes(short max) throws HiveException {
        Hive hive = Hive.get();
        return hive.getIndexes(this.getTTable().getDbName(), this.getTTable().getTableName(), max);
    }
}

