/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.fb303.FacebookBase;
import com.facebook.fb303.fb_status;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import javax.jdo.JDOException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.common.cli.CommonCliOptions;
import org.apache.hadoop.hive.common.metrics.Metrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.HiveAlterHandler;
import org.apache.hadoop.hive.metastore.MetaStoreEndFunctionContext;
import org.apache.hadoop.hive.metastore.MetaStoreEndFunctionListener;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TServerSocketKeepAlive;
import org.apache.hadoop.hive.metastore.TUGIBasedProcessor;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.IndexAlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.EventCleanerTask;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.hooks.JDOConnectionURLHook;
import org.apache.hadoop.hive.metastore.model.MDBPrivilege;
import org.apache.hadoop.hive.metastore.model.MGlobalPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionPrivilege;
import org.apache.hadoop.hive.metastore.model.MRole;
import org.apache.hadoop.hive.metastore.model.MRoleMap;
import org.apache.hadoop.hive.metastore.model.MTableColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MTablePrivilege;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.thrift.TUGIContainingTransport;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TTransportFactory;

public class HiveMetaStore
extends ThriftHiveMetastore {
    public static final Log LOG = LogFactory.getLog(HiveMetaStore.class);
    private static final int DEFAULT_HIVE_METASTORE_PORT = 9083;
    private static HadoopThriftAuthBridge.Server saslServer;
    private static boolean useSasl;

    public static void cancelDelegationToken(String tokenStrForm) throws IOException {
        saslServer.cancelDelegationToken(tokenStrForm);
    }

    public static String getDelegationToken(String owner, String renewer) throws IOException, InterruptedException {
        return saslServer.getDelegationToken(owner, renewer);
    }

    public static long renewDelegationToken(String tokenStrForm) throws IOException {
        return saslServer.renewDelegationToken(tokenStrForm);
    }

    public static void main(String[] args) throws Throwable {
        HiveMetastoreCli cli = new HiveMetastoreCli();
        cli.parse(args);
        Properties hiveconf = cli.addHiveconfToSystemProperties();
        if (System.getProperty("log4j.configuration") == null) {
            try {
                LogUtils.initHiveLog4j();
            }
            catch (LogUtils.LogInitializationException e) {
                HMSHandler.LOG.warn((Object)e.getMessage());
            }
        }
        try {
            String msg = "Starting hive metastore on port " + cli.port;
            HMSHandler.LOG.info((Object)msg);
            if (cli.isVerbose()) {
                System.err.println(msg);
            }
            HiveConf conf = new HiveConf(HMSHandler.class);
            for (Map.Entry<Object, Object> item : hiveconf.entrySet()) {
                conf.set((String)item.getKey(), (String)item.getValue());
            }
            HiveMetaStore.startMetaStore(cli.port, ShimLoader.getHadoopThriftAuthBridge(), conf);
        }
        catch (Throwable t) {
            HMSHandler.LOG.error((Object)"Metastore Thrift Server threw an exception...", t);
            throw t;
        }
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge) throws Throwable {
        HiveMetaStore.startMetaStore(port, bridge, new HiveConf(HMSHandler.class));
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge, HiveConf conf) throws Throwable {
        try {
            TProcessor processor;
            TTransportFactory transFactory;
            TServerSocket serverTransport;
            int minWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMINTHREADS);
            int maxWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMAXTHREADS);
            boolean tcpKeepAlive = conf.getBoolVar(HiveConf.ConfVars.METASTORE_TCP_KEEP_ALIVE);
            useSasl = conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL);
            TServerSocket tServerSocket = serverTransport = tcpKeepAlive ? new TServerSocketKeepAlive(port) : new TServerSocket(port);
            if (useSasl) {
                saslServer = bridge.createServer(conf.getVar(HiveConf.ConfVars.METASTORE_KERBEROS_KEYTAB_FILE), conf.getVar(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL));
                saslServer.startDelegationTokenSecretManager(conf);
                transFactory = saslServer.createTransportFactory();
                processor = saslServer.wrapProcessor(new ThriftHiveMetastore.Processor<HMSHandler>(new HMSHandler("new db based metaserver", conf)));
                LOG.info((Object)"Starting DB backed MetaStore Server in Secure Mode");
            } else {
                HMSHandler handler = new HMSHandler("new db based metaserver", conf);
                if (conf.getBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI)) {
                    transFactory = new TUGIContainingTransport.Factory();
                    processor = new TUGIBasedProcessor<HMSHandler>(handler);
                    LOG.info((Object)"Starting DB backed MetaStore Server with SetUGI enabled");
                } else {
                    transFactory = new TTransportFactory();
                    processor = new ThriftHiveMetastore.Processor<HMSHandler>(handler);
                    LOG.info((Object)"Starting DB backed MetaStore Server");
                }
            }
            TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args(serverTransport).processor(processor)).transportFactory(transFactory)).protocolFactory(new TBinaryProtocol.Factory())).minWorkerThreads(minWorkerThreads).maxWorkerThreads(maxWorkerThreads);
            TThreadPoolServer tServer = new TThreadPoolServer(args);
            HMSHandler.LOG.info((Object)("Started the new metaserver on port [" + port + "]..."));
            HMSHandler.LOG.info((Object)("Options.minWorkerThreads = " + minWorkerThreads));
            HMSHandler.LOG.info((Object)("Options.maxWorkerThreads = " + maxWorkerThreads));
            HMSHandler.LOG.info((Object)("TCP keepalive = " + tcpKeepAlive));
            ((TServer)tServer).serve();
        }
        catch (Throwable x) {
            x.printStackTrace();
            HMSHandler.LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)x));
            throw x;
        }
    }

    public static class HiveMetastoreCli
    extends CommonCliOptions {
        int port = 9083;

        public HiveMetastoreCli() {
            super("hivemetastore", true);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"port");
            OptionBuilder.withDescription((String)"Hive Metastore port number, default:9083");
            this.OPTIONS.addOption(OptionBuilder.create((char)'p'));
        }

        @Override
        public void parse(String[] args) {
            super.parse(args);
            args = this.commandLine.getArgs();
            if (args.length > 0) {
                System.err.println("This usage has been deprecated, consider using the new command line syntax (run with -h to see usage information)");
                this.port = new Integer(args[0]);
            }
            if (this.commandLine.hasOption('p')) {
                this.port = Integer.parseInt(this.commandLine.getOptionValue('p'));
            } else {
                String metastorePort = System.getenv("METASTORE_PORT");
                if (metastorePort != null) {
                    this.port = Integer.parseInt(metastorePort);
                }
            }
        }
    }

    public static class HMSHandler
    extends FacebookBase
    implements ThriftHiveMetastore.Iface {
        public static final Log LOG = LOG;
        private static boolean createDefaultDB = false;
        private String rawStoreClassName;
        private final HiveConf hiveConf;
        private Warehouse wh;
        private final ThreadLocal<RawStore> threadLocalMS = new ThreadLocal<RawStore>(){

            @Override
            protected synchronized RawStore initialValue() {
                return null;
            }
        };
        private final ThreadLocal<Configuration> threadLocalConf = new ThreadLocal<Configuration>(){

            @Override
            protected synchronized Configuration initialValue() {
                return null;
            }
        };
        public static final String AUDIT_FORMAT = "ugi=%s\tip=%s\tcmd=%s\t";
        public static final Log auditLog = LogFactory.getLog((String)(HiveMetaStore.class.getName() + ".audit"));
        private static final ThreadLocal<Formatter> auditFormatter = new ThreadLocal<Formatter>(){

            @Override
            protected Formatter initialValue() {
                return new Formatter(new StringBuilder(HMSHandler.AUDIT_FORMAT.length() * 4));
            }
        };
        private boolean checkForDefaultDb;
        private static int nextSerialNum = 0;
        private static ThreadLocal<Integer> threadLocalId = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(nextSerialNum++);
            }
        };
        private int retryInterval = 0;
        private int retryLimit = 0;
        private JDOConnectionURLHook urlHook = null;
        private String urlHookClassName = "";
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private AlterHandler alterHandler;
        private List<MetaStoreEventListener> listeners;
        private List<MetaStoreEndFunctionListener> endFunctionListeners;
        private static final String DATABASE_WAREHOUSE_SUFFIX = ".db";

        private final void logAuditEvent(String cmd) {
            UserGroupInformation ugi;
            if (!useSasl || cmd == null) {
                return;
            }
            try {
                ugi = ShimLoader.getHadoopShims().getUGIForConf(this.getConf());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            Formatter fmt = auditFormatter.get();
            ((StringBuilder)fmt.out()).setLength(0);
            auditLog.info((Object)fmt.format(AUDIT_FORMAT, ugi.getUserName(), saslServer.getRemoteAddress().toString(), cmd).toString());
        }

        public static Integer get() {
            return threadLocalId.get();
        }

        public HMSHandler(String name) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.hiveConf = new HiveConf(this.getClass());
            this.init();
        }

        public HMSHandler(String name, HiveConf conf) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.hiveConf = conf;
            this.init();
        }

        public HiveConf getHiveConf() {
            return this.hiveConf;
        }

        private boolean init() throws MetaException {
            this.rawStoreClassName = this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_RAW_STORE_IMPL);
            this.checkForDefaultDb = this.hiveConf.getBoolean("hive.metastore.checkForDefaultDb", true);
            String alterHandlerName = this.hiveConf.get("hive.metastore.alter.impl", HiveAlterHandler.class.getName());
            this.alterHandler = (AlterHandler)ReflectionUtils.newInstance(this.getClass(alterHandlerName, AlterHandler.class), (Configuration)this.hiveConf);
            this.wh = new Warehouse(this.hiveConf);
            this.retryInterval = HiveConf.getIntVar(this.hiveConf, HiveConf.ConfVars.METASTOREINTERVAL);
            this.retryLimit = HiveConf.getIntVar(this.hiveConf, HiveConf.ConfVars.METASTOREATTEMPTS);
            this.updateConnectionURL(this.hiveConf, null);
            this.createDefaultDB();
            if (this.hiveConf.getBoolean("hive.metastore.metrics.enabled", false)) {
                try {
                    Metrics.init();
                }
                catch (Exception e) {
                    LOG.error((Object)("error in Metrics init: " + e.getClass().getName() + " " + e.getMessage()));
                    MetaStoreUtils.printStackTrace(e);
                }
            }
            this.listeners = MetaStoreUtils.getMetaStoreListeners(MetaStoreEventListener.class, this.hiveConf, this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_EVENT_LISTENERS));
            this.endFunctionListeners = MetaStoreUtils.getMetaStoreListeners(MetaStoreEndFunctionListener.class, this.hiveConf, this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_END_FUNCTION_LISTENERS));
            long cleanFreq = this.hiveConf.getLongVar(HiveConf.ConfVars.METASTORE_EVENT_CLEAN_FREQ) * 1000L;
            if (cleanFreq > 0L) {
                Timer cleaner = new Timer("Metastore Events Cleaner Thread", true);
                cleaner.schedule((TimerTask)new EventCleanerTask(this), cleanFreq, cleanFreq);
            }
            return true;
        }

        private String addPrefix(String s) {
            return threadLocalId.get() + ": " + s;
        }

        @InterfaceAudience.LimitedPrivate(value={"HCATALOG"})
        @InterfaceStability.Evolving
        public <T> T executeWithRetry(Command<T> cmd) throws Exception {
            T ret = null;
            boolean gotNewConnectUrl = false;
            boolean reloadConf = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.METASTOREFORCERELOADCONF);
            if (reloadConf) {
                this.updateConnectionURL(this.getConf(), null);
            }
            int retryCount = 0;
            JDOException caughtException = null;
            while (true) {
                try {
                    RawStore ms = this.getMS(reloadConf || gotNewConnectUrl);
                    ret = cmd.run(ms);
                }
                catch (JDOException e) {
                    caughtException = e;
                    if (retryCount >= this.retryLimit) {
                        throw caughtException;
                    }
                    assert (this.retryInterval >= 0);
                    LOG.error((Object)String.format("JDO datastore error. Retrying metastore command after %d ms (attempt %d of %d)", this.retryInterval, ++retryCount, this.retryLimit));
                    Thread.sleep(this.retryInterval);
                    String lastUrl = HMSHandler.getConnectionURL(this.getConf());
                    gotNewConnectUrl = this.updateConnectionURL(this.getConf(), lastUrl);
                    continue;
                }
                break;
            }
            return ret;
        }

        private Configuration getConf() {
            Configuration conf = this.threadLocalConf.get();
            if (conf == null) {
                conf = new Configuration((Configuration)this.hiveConf);
                this.threadLocalConf.set(conf);
            }
            return conf;
        }

        @InterfaceAudience.LimitedPrivate(value={"HCATALOG"})
        @InterfaceStability.Evolving
        public RawStore getMS(boolean reloadConf) throws MetaException {
            RawStore ms = this.threadLocalMS.get();
            if (ms == null) {
                LOG.info((Object)this.addPrefix("Opening raw store with implemenation class:" + this.rawStoreClassName));
                ms = (RawStore)ReflectionUtils.newInstance(this.getClass(this.rawStoreClassName, RawStore.class), (Configuration)this.getConf());
                this.threadLocalMS.set(ms);
                ms = this.threadLocalMS.get();
            }
            if (reloadConf) {
                ms.setConf(this.getConf());
            }
            return ms;
        }

        private boolean updateConnectionURL(Configuration conf, String badUrl) throws MetaException {
            String connectUrl = null;
            String currentUrl = HMSHandler.getConnectionURL(conf);
            try {
                this.initConnectionUrlHook();
                if (this.urlHook != null) {
                    if (badUrl != null) {
                        this.urlHook.notifyBadConnectionUrl(badUrl);
                    }
                    connectUrl = this.urlHook.getJdoConnectionUrl(this.hiveConf);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception while getting connection URL from the hook: " + e));
            }
            if (connectUrl != null && !connectUrl.equals(currentUrl)) {
                LOG.error((Object)this.addPrefix(String.format("Overriding %s with %s", HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), connectUrl)));
                conf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), connectUrl);
                return true;
            }
            return false;
        }

        private static String getConnectionURL(Configuration conf) {
            return conf.get(HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), "");
        }

        private synchronized void initConnectionUrlHook() throws ClassNotFoundException {
            boolean urlHookChanged;
            String className = this.hiveConf.get(HiveConf.ConfVars.METASTORECONNECTURLHOOK.toString(), "").trim();
            if (className.equals("")) {
                this.urlHookClassName = "";
                this.urlHook = null;
                return;
            }
            boolean bl = urlHookChanged = !this.urlHookClassName.equals(className);
            if (this.urlHook == null || urlHookChanged) {
                this.urlHookClassName = className.trim();
                Class<?> urlHookClass = Class.forName(this.urlHookClassName, true, JavaUtils.getClassLoader());
                this.urlHook = (JDOConnectionURLHook)ReflectionUtils.newInstance(urlHookClass, null);
            }
        }

        private void createDefaultDB_core(RawStore ms) throws MetaException, InvalidObjectException {
            try {
                ms.getDatabase("default");
            }
            catch (NoSuchObjectException e) {
                ms.createDatabase(new Database("default", "Default Hive database", this.getDefaultDatabasePath("default").toString(), null));
            }
            createDefaultDB = true;
        }

        private void createDefaultDB() throws MetaException {
            if (createDefaultDB || !this.checkForDefaultDb) {
                return;
            }
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.createDefaultDB_core(ms);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (InvalidObjectException e) {
                throw new MetaException(e.getMessage());
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
        }

        private Class<?> getClass(String rawStoreClassName, Class<?> class1) throws MetaException {
            try {
                return Class.forName(rawStoreClassName, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new MetaException(rawStoreClassName + " class not found");
            }
        }

        private void logInfo(String m) {
            LOG.info((Object)(threadLocalId.get().toString() + ": " + m));
            this.logAuditEvent(m);
        }

        public String startFunction(String function, String extraLogInfo) {
            this.incrementCounter(function);
            this.logInfo(function + extraLogInfo);
            try {
                Metrics.startScope(function);
            }
            catch (IOException e) {
                LOG.debug((Object)("Exception when starting metrics scope" + e.getClass().getName() + " " + e.getMessage()));
                MetaStoreUtils.printStackTrace(e);
            }
            return function;
        }

        public String startFunction(String function) {
            return this.startFunction(function, "");
        }

        public String startTableFunction(String function, String db, String tbl) {
            return this.startFunction(function, " : db=" + db + " tbl=" + tbl);
        }

        public String startMultiTableFunction(String function, String db, List<String> tbls) {
            String tableNames = StringUtils.join(tbls, (String)",");
            return this.startFunction(function, " : db=" + db + " tbls=" + tableNames);
        }

        public String startPartitionFunction(String function, String db, String tbl, List<String> partVals) {
            return this.startFunction(function, " : db=" + db + " tbl=" + tbl + "[" + StringUtils.join(partVals, (String)",") + "]");
        }

        public String startPartitionFunction(String function, String db, String tbl, Map<String, String> partName) {
            return this.startFunction(function, " : db=" + db + " tbl=" + tbl + "partition=" + partName);
        }

        public void endFunction(String function, boolean successful) {
            this.endFunction(function, new MetaStoreEndFunctionContext(successful));
        }

        public void endFunction(String function, MetaStoreEndFunctionContext context) {
            try {
                Metrics.endScope(function);
            }
            catch (IOException e) {
                LOG.debug((Object)("Exception when closing metrics scope" + e));
            }
            for (MetaStoreEndFunctionListener listener : this.endFunctionListeners) {
                listener.onEndFunction(function, context);
            }
        }

        public fb_status getStatus() {
            return fb_status.ALIVE;
        }

        public void shutdown() {
            this.logInfo("Shutting down the object store...");
            RawStore ms = this.threadLocalMS.get();
            if (ms != null) {
                ms.shutdown();
                ms = null;
            }
            this.logInfo("Metastore shutdown complete.");
        }

        public AbstractMap<String, Long> getCounters() {
            AbstractMap counters = super.getCounters();
            if (this.endFunctionListeners != null) {
                for (MetaStoreEndFunctionListener listener : this.endFunctionListeners) {
                    listener.exportCounters(counters);
                }
            }
            return counters;
        }

        private Path getDefaultDatabasePath(String dbName) throws MetaException {
            if (dbName.equalsIgnoreCase("default")) {
                return this.wh.getWhRoot();
            }
            return new Path(this.wh.getWhRoot(), dbName.toLowerCase() + DATABASE_WAREHOUSE_SUFFIX);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_database_core(RawStore ms, Database db) throws AlreadyExistsException, InvalidObjectException, MetaException, IOException {
            if (!MetaStoreUtils.validateName(db.getName())) {
                throw new InvalidObjectException(db.getName() + " is not a valid database name");
            }
            if (null == db.getLocationUri()) {
                db.setLocationUri(this.getDefaultDatabasePath(db.getName()).toString());
            } else {
                db.setLocationUri(this.wh.getDnsPath(new Path(db.getLocationUri())).toString());
            }
            Path dbPath = new Path(db.getLocationUri());
            boolean success = false;
            boolean madeDir = false;
            try {
                if (!this.wh.isDir(dbPath)) {
                    if (!this.wh.mkdirs(dbPath)) {
                        throw new MetaException("Unable to create database path " + dbPath + ", failed to create database " + db.getName());
                    }
                    madeDir = true;
                }
                ms.openTransaction();
                ms.createDatabase(db);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                    if (madeDir) {
                        this.wh.deleteDir(dbPath, true);
                    }
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onCreateDatabase(new CreateDatabaseEvent(db, success, this));
                }
            }
        }

        @Override
        public void create_database(final Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
            this.startFunction("create_database", ": " + db.getName() + " " + db.getLocationUri() + " " + db.getDescription());
            boolean success = false;
            try {
                try {
                    if (null != this.get_database(db.getName())) {
                        throw new AlreadyExistsException("Database " + db.getName() + " already exists");
                    }
                }
                catch (NoSuchObjectException e) {
                    // empty catch block
                }
                success = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.create_database_core(ms, db);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("create_database", success);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Database get_database(final String name) throws NoSuchObjectException, MetaException {
            this.startFunction("get_database", ": " + name);
            Database db = null;
            try {
                db = this.executeWithRetry(new Command<Database>(){

                    @Override
                    public Database run(RawStore ms) throws Exception {
                        return ms.getDatabase(name);
                    }
                });
                this.endFunction("get_database", db != null);
                return db;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (NoSuchObjectException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        if ($assertionsDisabled) throw (RuntimeException)e3;
                        if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_database", db != null);
                    throw throwable;
                }
            }
        }

        @Override
        public void alter_database(final String dbName, final Database db) throws NoSuchObjectException, TException, MetaException {
            this.startFunction("alter_database" + dbName);
            boolean success = false;
            try {
                success = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        return ms.alterDatabase(dbName, db);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("alter_database", success);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_database_core(RawStore ms, String name, boolean deleteData, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, IOException {
            boolean success = false;
            Database db = null;
            try {
                ms.openTransaction();
                db = ms.getDatabase(name);
                List<String> allTables = this.get_all_tables(db.getName());
                if (!cascade && !allTables.isEmpty()) {
                    throw new InvalidOperationException("Database " + db.getName() + " is not empty");
                }
                Path path = new Path(db.getLocationUri()).getParent();
                if (!this.wh.isWritable(path)) {
                    throw new MetaException("Database not dropped since " + path + " is not writable by " + this.hiveConf.getUser());
                }
                if (ms.dropDatabase(name)) {
                    success = ms.commitTransaction();
                }
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData) {
                    this.wh.deleteDir(new Path(db.getLocationUri()), true);
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onDropDatabase(new DropDatabaseEvent(db, success, this));
                }
            }
        }

        @Override
        public void drop_database(final String dbName, final boolean deleteData, final boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException {
            this.startFunction("drop_database", ": " + dbName);
            if ("default".equalsIgnoreCase(dbName)) {
                this.endFunction("drop_database", false);
                throw new MetaException("Can not drop default database");
            }
            boolean success = false;
            try {
                success = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.drop_database_core(ms, dbName, deleteData, cascade);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (InvalidOperationException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_database", success);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<String> get_databases(final String pattern) throws MetaException {
            this.startFunction("get_databases", ": " + pattern);
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    public List<String> run(RawStore ms) throws Exception {
                        return ms.getDatabases(pattern);
                    }
                });
                this.endFunction("get_databases", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        if ($assertionsDisabled) throw (RuntimeException)e2;
                        if (e2 instanceof RuntimeException) throw (RuntimeException)e2;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_databases", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<String> get_all_databases() throws MetaException {
            this.startFunction("get_all_databases");
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    public List<String> run(RawStore ms) throws Exception {
                        return ms.getAllDatabases();
                    }
                });
                this.endFunction("get_all_databases", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        if ($assertionsDisabled) throw (RuntimeException)e2;
                        if (e2 instanceof RuntimeException) throw (RuntimeException)e2;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_all_databases", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_type_core(RawStore ms, Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            if (!MetaStoreUtils.validateName(type.getName())) {
                throw new InvalidObjectException("Invalid type name");
            }
            boolean success = false;
            try {
                ms.openTransaction();
                if (this.is_type_exists(ms, type.getName())) {
                    throw new AlreadyExistsException("Type " + type.getName() + " already exists");
                }
                ms.createType(type);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean create_type(final Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.startFunction("create_type", ": " + type.getName());
            boolean ret = false;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.create_type_core(ms, type);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("create_type", ret);
            }
            return ret;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Type get_type(final String name) throws MetaException, NoSuchObjectException {
            this.startFunction("get_type", ": " + name);
            Type ret = null;
            try {
                ret = this.executeWithRetry(new Command<Type>(){

                    @Override
                    public Type run(RawStore ms) throws Exception {
                        Type type = ms.getType(name);
                        if (null == type) {
                            throw new NoSuchObjectException("Type \"" + name + "\" not found.");
                        }
                        return type;
                    }
                });
                this.endFunction("get_type", ret != null);
                return ret;
            }
            catch (NoSuchObjectException e) {
                try {
                    throw e;
                    catch (MetaException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        if ($assertionsDisabled) throw (RuntimeException)e3;
                        if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_type", ret != null);
                    throw throwable;
                }
            }
        }

        private boolean is_type_exists(RawStore ms, String typeName) throws MetaException {
            return ms.getType(typeName) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_type_core(RawStore ms, String typeName) throws NoSuchObjectException, MetaException {
            boolean success = false;
            try {
                ms.openTransaction();
                if (!this.is_type_exists(ms, typeName)) {
                    throw new NoSuchObjectException(typeName + " doesn't exist");
                }
                if (!ms.dropType(typeName)) {
                    throw new MetaException("Unable to drop type " + typeName);
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean drop_type(final String name) throws MetaException {
            this.startFunction("drop_type", ": " + name);
            boolean ret = false;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        return ms.dropType(name);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_type", ret);
            }
            return ret;
        }

        @Override
        public Map<String, Type> get_type_all(String name) throws MetaException {
            this.startFunction("get_type_all", ": " + name);
            this.endFunction("get_type_all", false);
            throw new MetaException("Not yet implemented");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_table_core(RawStore ms, Table tbl) throws AlreadyExistsException, MetaException, InvalidObjectException, NoSuchObjectException {
            boolean success;
            block16: {
                if (!MetaStoreUtils.validateName(tbl.getTableName()) || !MetaStoreUtils.validateColNames(tbl.getSd().getCols()) || tbl.getPartitionKeys() != null && !MetaStoreUtils.validateColNames(tbl.getPartitionKeys())) {
                    throw new InvalidObjectException(tbl.getTableName() + " is not a valid object name");
                }
                Path tblPath = null;
                success = false;
                boolean madeDir = false;
                try {
                    ms.openTransaction();
                    if (ms.getDatabase(tbl.getDbName()) == null) {
                        throw new NoSuchObjectException("The database " + tbl.getDbName() + " does not exist");
                    }
                    if (this.is_table_exists(ms, tbl.getDbName(), tbl.getTableName())) {
                        throw new AlreadyExistsException("Table " + tbl.getTableName() + " already exists");
                    }
                    if (!TableType.VIRTUAL_VIEW.toString().equals(tbl.getTableType())) {
                        if (tbl.getSd().getLocation() == null || tbl.getSd().getLocation().isEmpty()) {
                            tblPath = this.wh.getTablePath(ms.getDatabase(tbl.getDbName()), tbl.getTableName());
                        } else {
                            if (!this.isExternal(tbl) && !MetaStoreUtils.isNonNativeTable(tbl)) {
                                LOG.warn((Object)("Location: " + tbl.getSd().getLocation() + " specified for non-external table:" + tbl.getTableName()));
                            }
                            tblPath = this.wh.getDnsPath(new Path(tbl.getSd().getLocation()));
                        }
                        tbl.getSd().setLocation(tblPath.toString());
                    }
                    if (tblPath != null && !this.wh.isDir(tblPath)) {
                        if (!this.wh.mkdirs(tblPath)) {
                            throw new MetaException(tblPath + " is not a directory or unable to create one");
                        }
                        madeDir = true;
                    }
                    long time = System.currentTimeMillis() / 1000L;
                    tbl.setCreateTime((int)time);
                    if (tbl.getParameters() == null || tbl.getParameters().get("transient_lastDdlTime") == null) {
                        tbl.putToParameters("transient_lastDdlTime", Long.toString(time));
                    }
                    ms.createTable(tbl);
                    success = ms.commitTransaction();
                    if (success) break block16;
                    ms.rollbackTransaction();
                    if (!madeDir) break block16;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                        if (madeDir) {
                            this.wh.deleteDir(tblPath, true);
                        }
                    }
                    for (MetaStoreEventListener listener : this.listeners) {
                        listener.onCreateTable(new CreateTableEvent(tbl, success, this));
                    }
                    throw throwable;
                }
                this.wh.deleteDir(tblPath, true);
            }
            for (MetaStoreEventListener listener : this.listeners) {
                listener.onCreateTable(new CreateTableEvent(tbl, success, this));
            }
        }

        @Override
        public void create_table(final Table tbl) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.startFunction("create_table", ": db=" + tbl.getDbName() + " tbl=" + tbl.getTableName());
            boolean success = false;
            try {
                success = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.create_table_core(ms, tbl);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw new InvalidObjectException(e.getMessage());
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("create_table", success);
            }
        }

        private boolean is_table_exists(RawStore ms, String dbname, String name) throws MetaException {
            return ms.getTable(dbname, name) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_table_core(RawStore ms, String dbname, String name, boolean deleteData) throws NoSuchObjectException, MetaException, IOException {
            Table tbl;
            boolean success;
            block18: {
                success = false;
                boolean isExternal = false;
                Path tblPath = null;
                tbl = null;
                isExternal = false;
                boolean isIndexTable = false;
                try {
                    ms.openTransaction();
                    tbl = this.get_table(dbname, name);
                    if (tbl == null) {
                        throw new NoSuchObjectException(name + " doesn't exist");
                    }
                    if (tbl.getSd() == null) {
                        throw new MetaException("Table metadata is corrupted");
                    }
                    isIndexTable = this.isIndexTable(tbl);
                    if (isIndexTable) {
                        throw new RuntimeException("The table " + name + " is an index table. Please do drop index instead.");
                    }
                    if (!isIndexTable) {
                        try {
                            List<Index> indexes = ms.getIndexes(dbname, name, Short.MAX_VALUE);
                            while (indexes != null && indexes.size() > 0) {
                                for (Index idx : indexes) {
                                    this.drop_index_by_name(dbname, name, idx.getIndexName(), true);
                                }
                                indexes = ms.getIndexes(dbname, name, Short.MAX_VALUE);
                            }
                        }
                        catch (TException e) {
                            throw new MetaException(e.getMessage());
                        }
                    }
                    isExternal = this.isExternal(tbl);
                    if (tbl.getSd().getLocation() != null && !this.wh.isWritable((tblPath = new Path(tbl.getSd().getLocation())).getParent())) {
                        throw new MetaException("Table metadata not deleted since " + tblPath.getParent() + " is not writable by " + this.hiveConf.getUser());
                    }
                    if (!ms.dropTable(dbname, name)) {
                        throw new MetaException("Unable to drop table");
                    }
                    success = ms.commitTransaction();
                    if (!success) {
                        ms.rollbackTransaction();
                        break block18;
                    }
                    if (!deleteData || tblPath == null || isExternal) break block18;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else if (deleteData && tblPath != null && !isExternal) {
                        this.wh.deleteDir(tblPath, true);
                    }
                    for (MetaStoreEventListener listener : this.listeners) {
                        listener.onDropTable(new DropTableEvent(tbl, success, this));
                    }
                    throw throwable;
                }
                this.wh.deleteDir(tblPath, true);
            }
            for (MetaStoreEventListener listener : this.listeners) {
                listener.onDropTable(new DropTableEvent(tbl, success, this));
            }
        }

        @Override
        public void drop_table(final String dbname, final String name, final boolean deleteData) throws NoSuchObjectException, MetaException {
            this.startTableFunction("drop_table", dbname, name);
            boolean success = false;
            try {
                success = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.drop_table_core(ms, dbname, name, deleteData);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_table", success);
            }
        }

        private boolean isExternal(Table table) {
            return MetaStoreUtils.isExternalTable(table);
        }

        private boolean isIndexTable(Table table) {
            return MetaStoreUtils.isIndexTable(table);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Table get_table(final String dbname, final String name) throws MetaException, NoSuchObjectException {
            Table t = null;
            this.startTableFunction("get_table", dbname, name);
            try {
                t = this.executeWithRetry(new Command<Table>(){

                    @Override
                    public Table run(RawStore ms) throws Exception {
                        Table t = ms.getTable(dbname, name);
                        if (t == null) {
                            throw new NoSuchObjectException(dbname + "." + name + " table not found");
                        }
                        return t;
                    }
                });
                this.endFunction("get_table", t != null);
                return t;
            }
            catch (NoSuchObjectException e) {
                try {
                    throw e;
                    catch (MetaException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        if ($assertionsDisabled) throw (RuntimeException)e3;
                        if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_table", t != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Table> get_table_objects_by_name(final String dbname, final List<String> names) throws MetaException, InvalidOperationException, UnknownDBException {
            List<Table> tables = null;
            this.startMultiTableFunction("get_multi_table", dbname, names);
            try {
                tables = this.executeWithRetry(new Command<List<Table>>(){

                    @Override
                    public List<Table> run(RawStore ms) throws Exception {
                        if (dbname == null || dbname.isEmpty()) {
                            throw new UnknownDBException("DB name is null or empty");
                        }
                        if (names == null) {
                            throw new InvalidOperationException(dbname + " cannot find null tables");
                        }
                        List<Table> foundTables = ms.getTableObjectsByName(dbname, names);
                        return foundTables;
                    }
                });
                this.endFunction("get_multi_table", tables != null);
                return tables;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (InvalidOperationException e2) {
                        throw e2;
                    }
                    catch (UnknownDBException e3) {
                        throw e3;
                    }
                    catch (Exception e4) {
                        throw new MetaException(e4.toString());
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_multi_table", tables != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<String> get_table_names_by_filter(final String dbName, final String filter, final short maxTables) throws MetaException, InvalidOperationException, UnknownDBException {
            List<String> tables = null;
            this.startFunction("get_table_names_by_filter", ": db = " + dbName + ", filter = " + filter);
            try {
                tables = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    public List<String> run(RawStore ms) throws Exception {
                        if (dbName == null || dbName.isEmpty()) {
                            throw new UnknownDBException("DB name is null or empty");
                        }
                        if (filter == null) {
                            throw new InvalidOperationException(filter + " cannot apply null filter");
                        }
                        List<String> tables = ms.listTableNamesByFilter(dbName, filter, maxTables);
                        return tables;
                    }
                });
                this.endFunction("get_table_names_by_filter", tables != null);
                return tables;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (InvalidOperationException e2) {
                        throw e2;
                    }
                    catch (UnknownDBException e3) {
                        throw e3;
                    }
                    catch (Exception e4) {
                        throw new MetaException(e4.toString());
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_table_names_by_filter", tables != null);
                    throw throwable;
                }
            }
        }

        public boolean set_table_parameters(String dbname, String name, Map<String, String> params) throws NoSuchObjectException, MetaException {
            this.endFunction(this.startTableFunction("set_table_parameters", dbname, name), false);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Partition append_partition_common(RawStore ms, String dbName, String tableName, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
            Partition part = new Partition();
            boolean success = false;
            boolean madeDir = false;
            Path partLocation = null;
            try {
                ms.openTransaction();
                part.setDbName(dbName);
                part.setTableName(tableName);
                part.setValues(part_vals);
                Table tbl = ms.getTable(part.getDbName(), part.getTableName());
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                }
                if (tbl.getSd().getLocation() == null) {
                    throw new MetaException("Cannot append a partition to a view");
                }
                part.setSd(tbl.getSd());
                partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part_vals));
                part.getSd().setLocation(partLocation.toString());
                Partition old_part = null;
                try {
                    old_part = ms.getPartition(part.getDbName(), part.getTableName(), part.getValues());
                }
                catch (NoSuchObjectException e) {
                    old_part = null;
                }
                if (old_part != null) {
                    throw new AlreadyExistsException("Partition already exists:" + part);
                }
                if (!this.wh.isDir(partLocation)) {
                    if (!this.wh.mkdirs(partLocation)) {
                        throw new MetaException(partLocation + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                long time = System.currentTimeMillis() / 1000L;
                part.setCreateTime((int)time);
                part.putToParameters("transient_lastDdlTime", Long.toString(time));
                success = ms.addPartition(part);
                if (success) {
                    success = ms.commitTransaction();
                }
                if (success) return part;
                ms.rollbackTransaction();
                if (!madeDir) return part;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                ms.rollbackTransaction();
                if (!madeDir) throw throwable;
                this.wh.deleteDir(partLocation, true);
                throw throwable;
            }
            this.wh.deleteDir(partLocation, true);
            return part;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Partition append_partition(final String dbName, final String tableName, final List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.startPartitionFunction("append_partition", dbName, tableName, part_vals);
            if (LOG.isDebugEnabled()) {
                for (String part : part_vals) {
                    LOG.debug((Object)part);
                }
            }
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    public Partition run(RawStore ms) throws Exception {
                        return HMSHandler.this.append_partition_common(ms, dbName, tableName, part_vals);
                    }
                });
                this.endFunction("append_partition", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (InvalidObjectException e2) {
                        throw e2;
                    }
                    catch (AlreadyExistsException e3) {
                        throw e3;
                    }
                    catch (Exception e4) {
                        if ($assertionsDisabled) throw (RuntimeException)e4;
                        if (e4 instanceof RuntimeException) throw (RuntimeException)e4;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("append_partition", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int add_partitions_core(RawStore ms, List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
            block6: {
                String db = parts.get(0).getDbName();
                String tbl = parts.get(0).getTableName();
                this.logInfo("add_partitions : db=" + db + " tbl=" + tbl);
                boolean success = false;
                HashMap<Partition, Boolean> addedPartitions = new HashMap<Partition, Boolean>();
                try {
                    ms.openTransaction();
                    for (Partition partition : parts) {
                        Map.Entry<Partition, Boolean> e = this.add_partition_core_notxn(ms, partition);
                        addedPartitions.put(e.getKey(), e.getValue());
                    }
                    success = true;
                    ms.commitTransaction();
                    if (success) break block6;
                    ms.rollbackTransaction();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                        for (Map.Entry e : addedPartitions.entrySet()) {
                            if (!((Boolean)e.getValue()).booleanValue()) continue;
                            this.wh.deleteDir(new Path(((Partition)e.getKey()).getSd().getLocation()), true);
                        }
                    }
                    throw throwable;
                }
                for (Map.Entry entry : addedPartitions.entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    this.wh.deleteDir(new Path(((Partition)entry.getKey()).getSd().getLocation()), true);
                }
            }
            return parts.size();
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int add_partitions(final List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
            this.startFunction("add_partition");
            if (parts.size() == 0) {
                return 0;
            }
            Integer ret = null;
            try {
                ret = this.executeWithRetry(new Command<Integer>(){

                    @Override
                    public Integer run(RawStore ms) throws Exception {
                        int ret = HMSHandler.this.add_partitions_core(ms, parts);
                        return ret;
                    }
                });
                this.endFunction("add_partition", ret != null);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    throw e;
                    catch (AlreadyExistsException e2) {
                        throw e2;
                    }
                    catch (MetaException e3) {
                        throw e3;
                    }
                    catch (Exception e4) {
                        if ($assertionsDisabled) throw (RuntimeException)e4;
                        if (e4 instanceof RuntimeException) throw (RuntimeException)e4;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("add_partition", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map.Entry<Partition, Boolean> add_partition_core_notxn(RawStore ms, Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
            boolean madeDir;
            boolean success;
            block20: {
                success = false;
                madeDir = false;
                Path partLocation = null;
                try {
                    Partition old_part = null;
                    try {
                        old_part = ms.getPartition(part.getDbName(), part.getTableName(), part.getValues());
                    }
                    catch (NoSuchObjectException e) {
                        old_part = null;
                    }
                    if (old_part != null) {
                        throw new AlreadyExistsException("Partition already exists:" + part);
                    }
                    Table tbl = ms.getTable(part.getDbName(), part.getTableName());
                    if (tbl == null) {
                        throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                    }
                    String partLocationStr = null;
                    if (part.getSd() != null) {
                        partLocationStr = part.getSd().getLocation();
                    }
                    if (partLocationStr == null || partLocationStr.isEmpty()) {
                        if (tbl.getSd().getLocation() != null) {
                            partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part.getValues()));
                        }
                    } else {
                        if (tbl.getSd().getLocation() == null) {
                            throw new MetaException("Cannot specify location for a view partition");
                        }
                        partLocation = this.wh.getDnsPath(new Path(partLocationStr));
                    }
                    if (partLocation != null) {
                        part.getSd().setLocation(partLocation.toString());
                        if (!this.wh.isDir(partLocation)) {
                            if (!this.wh.mkdirs(partLocation)) {
                                throw new MetaException(partLocation + " is not a directory or unable to create one");
                            }
                            madeDir = true;
                        }
                    }
                    long time = System.currentTimeMillis() / 1000L;
                    part.setCreateTime((int)time);
                    if (part.getParameters() == null || part.getParameters().get("transient_lastDdlTime") == null) {
                        part.putToParameters("transient_lastDdlTime", Long.toString(time));
                    }
                    Map<String, String> tblParams = tbl.getParameters();
                    String inheritProps = this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_PART_INHERIT_TBL_PROPS).trim();
                    Set<String> inheritKeys = new HashSet<String>(Arrays.asList(inheritProps.split(",")));
                    if (inheritKeys.contains("*")) {
                        inheritKeys = tblParams.keySet();
                    }
                    for (String key : inheritKeys) {
                        String paramVal = tblParams.get(key);
                        if (null == paramVal) continue;
                        part.putToParameters(key, paramVal);
                    }
                    success = ms.addPartition(part);
                    if (success || !madeDir) break block20;
                }
                catch (Throwable throwable) {
                    if (!success && madeDir) {
                        this.wh.deleteDir(partLocation, true);
                    }
                    for (MetaStoreEventListener listener : this.listeners) {
                        listener.onAddPartition(new AddPartitionEvent(part, success, this));
                    }
                    throw throwable;
                }
                this.wh.deleteDir(partLocation, true);
            }
            for (MetaStoreEventListener listener : this.listeners) {
                listener.onAddPartition(new AddPartitionEvent(part, success, this));
            }
            HashMap<Partition, Boolean> returnVal = new HashMap<Partition, Boolean>();
            returnVal.put(part, madeDir);
            return returnVal.entrySet().iterator().next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Partition add_partition_core(RawStore ms, Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
            boolean success = false;
            Partition retPtn = null;
            try {
                ms.openTransaction();
                retPtn = this.add_partition_core_notxn(ms, part).getKey();
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
            return retPtn;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Partition add_partition(final Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.startTableFunction("add_partition", part.getDbName(), part.getTableName());
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    public Partition run(RawStore ms) throws Exception {
                        return HMSHandler.this.add_partition_core(ms, part);
                    }
                });
                this.endFunction("add_partition", ret != null);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    throw e;
                    catch (AlreadyExistsException e2) {
                        throw e2;
                    }
                    catch (MetaException e3) {
                        throw e3;
                    }
                    catch (Exception e4) {
                        if ($assertionsDisabled) throw (RuntimeException)e4;
                        if (e4 instanceof RuntimeException) throw (RuntimeException)e4;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("add_partition", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drop_partition_common(RawStore ms, String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws MetaException, NoSuchObjectException, IOException {
            Partition part;
            boolean success;
            block17: {
                Path partPath;
                block18: {
                    Path archiveParentDir;
                    block19: {
                        success = false;
                        partPath = null;
                        Table tbl = null;
                        part = null;
                        boolean isArchived = false;
                        archiveParentDir = null;
                        try {
                            ms.openTransaction();
                            part = ms.getPartition(db_name, tbl_name, part_vals);
                            if (part == null) {
                                throw new NoSuchObjectException("Partition doesn't exist. " + part_vals);
                            }
                            isArchived = MetaStoreUtils.isArchived(part);
                            if (isArchived && !this.wh.isWritable((archiveParentDir = MetaStoreUtils.getOriginalLocation(part)).getParent())) {
                                throw new MetaException("Table partition not deleted since " + archiveParentDir.getParent() + " is not writable by " + this.hiveConf.getUser());
                            }
                            if (!ms.dropPartition(db_name, tbl_name, part_vals)) {
                                throw new MetaException("Unable to drop partition");
                            }
                            success = ms.commitTransaction();
                            if (part.getSd() != null && part.getSd().getLocation() != null && !this.wh.isWritable((partPath = new Path(part.getSd().getLocation())).getParent())) {
                                throw new MetaException("Table partition not deleted since " + partPath.getParent() + " is not writable by " + this.hiveConf.getUser());
                            }
                            tbl = this.get_table(db_name, tbl_name);
                            if (!success) {
                                ms.rollbackTransaction();
                                break block17;
                            }
                            if (!deleteData || partPath == null && archiveParentDir == null || tbl == null || this.isExternal(tbl)) break block17;
                            if (!isArchived) break block18;
                            if ($assertionsDisabled || archiveParentDir != null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (!success) {
                                ms.rollbackTransaction();
                            } else if (deleteData && (partPath != null || archiveParentDir != null) && tbl != null && !this.isExternal(tbl)) {
                                if (isArchived) {
                                    assert (archiveParentDir != null);
                                    this.wh.deleteDir(archiveParentDir, true);
                                } else {
                                    assert (partPath != null);
                                    this.wh.deleteDir(partPath, true);
                                }
                            }
                            for (MetaStoreEventListener listener : this.listeners) {
                                listener.onDropPartition(new DropPartitionEvent(part, success, this));
                            }
                            throw throwable;
                        }
                        throw new AssertionError();
                    }
                    this.wh.deleteDir(archiveParentDir, true);
                    break block17;
                }
                assert (partPath != null);
                this.wh.deleteDir(partPath, true);
            }
            for (MetaStoreEventListener listener : this.listeners) {
                listener.onDropPartition(new DropPartitionEvent(part, success, this));
            }
            return true;
        }

        @Override
        public boolean drop_partition(final String db_name, final String tbl_name, final List<String> part_vals, final boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.startPartitionFunction("drop_partition", db_name, tbl_name, part_vals);
            LOG.info((Object)("Partition values:" + part_vals));
            boolean ret = false;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        return HMSHandler.this.drop_partition_common(ms, db_name, tbl_name, part_vals, deleteData);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_partition", ret);
            }
            return ret;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Partition get_partition(final String db_name, final String tbl_name, final List<String> part_vals) throws MetaException, NoSuchObjectException {
            this.startPartitionFunction("get_partition", db_name, tbl_name, part_vals);
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    public Partition run(RawStore ms) throws Exception {
                        return ms.getPartition(db_name, tbl_name, part_vals);
                    }
                });
                this.endFunction("get_partition", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (NoSuchObjectException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        if ($assertionsDisabled) throw (RuntimeException)e3;
                        if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Partition get_partition_with_auth(final String db_name, final String tbl_name, final List<String> part_vals, final String user_name, final List<String> group_names) throws MetaException, NoSuchObjectException, TException {
            this.startPartitionFunction("get_partition_with_auth", db_name, tbl_name, part_vals);
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    public Partition run(RawStore ms) throws Exception {
                        return ms.getPartitionWithAuth(db_name, tbl_name, part_vals, user_name, group_names);
                    }
                });
                this.endFunction("get_partition_with_auth", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (NoSuchObjectException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        if ($assertionsDisabled) throw (RuntimeException)e3;
                        if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_with_auth", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Partition> get_partitions(final String db_name, final String tbl_name, final short max_parts) throws NoSuchObjectException, MetaException {
            this.startTableFunction("get_partitions", db_name, tbl_name);
            List<Partition> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Partition>>(){

                    @Override
                    public List<Partition> run(RawStore ms) throws Exception {
                        return ms.getPartitions(db_name, tbl_name, max_parts);
                    }
                });
                this.endFunction("get_partitions", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (NoSuchObjectException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        if ($assertionsDisabled) throw (RuntimeException)e3;
                        if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Partition> get_partitions_with_auth(final String dbName, final String tblName, final short maxParts, final String userName, final List<String> groupNames) throws NoSuchObjectException, MetaException, TException {
            this.startTableFunction("get_partitions_with_auth", dbName, tblName);
            List<Partition> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Partition>>(){

                    @Override
                    public List<Partition> run(RawStore ms) throws Exception {
                        return ms.getPartitionsWithAuth(dbName, tblName, maxParts, userName, groupNames);
                    }
                });
                this.endFunction("get_partitions_with_auth", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (NoSuchObjectException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        if ($assertionsDisabled) throw (RuntimeException)e3;
                        if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_with_auth", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<String> get_partition_names(final String db_name, final String tbl_name, final short max_parts) throws MetaException {
            this.startTableFunction("get_partition_names", db_name, tbl_name);
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    public List<String> run(RawStore ms) throws Exception {
                        return ms.listPartitionNames(db_name, tbl_name, max_parts);
                    }
                });
                this.endFunction("get_partition_names", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        if ($assertionsDisabled) throw (RuntimeException)e2;
                        if (e2 instanceof RuntimeException) throw (RuntimeException)e2;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_names", ret != null);
                    throw throwable;
                }
            }
        }

        @Override
        public void alter_partition(String db_name, String tbl_name, Partition new_part) throws InvalidOperationException, MetaException, TException {
            this.rename_partition(db_name, tbl_name, null, new_part);
        }

        @Override
        public void rename_partition(final String db_name, final String tbl_name, final List<String> part_vals, final Partition new_part) throws InvalidOperationException, MetaException, TException {
            this.startTableFunction("alter_partition", db_name, tbl_name);
            LOG.info((Object)("New partition values:" + new_part.getValues()));
            if (part_vals != null && part_vals.size() > 0) {
                LOG.info((Object)("Old Partition values:" + part_vals));
            }
            boolean success = false;
            try {
                success = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.alter_partition_core(ms, db_name, tbl_name, part_vals, new_part);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (InvalidObjectException e) {
                throw new InvalidOperationException(e.getMessage());
            }
            catch (AlreadyExistsException e) {
                throw new InvalidOperationException(e.getMessage());
            }
            catch (MetaException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("alter_partition", success);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void alter_partition_core(RawStore ms, String dbname, String name, List<String> part_vals, Partition new_part) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
            Partition oldPart;
            block38: {
                boolean success = false;
                Path srcPath = null;
                Path destPath = null;
                FileSystem srcFs = null;
                FileSystem destFs = null;
                Table tbl = null;
                oldPart = null;
                String oldPartLoc = null;
                String newPartLoc = null;
                if (new_part.getParameters() == null || new_part.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt(new_part.getParameters().get("transient_lastDdlTime")) == 0) {
                    new_part.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
                }
                if (part_vals == null || part_vals.size() == 0) {
                    try {
                        oldPart = ms.getPartition(dbname, name, new_part.getValues());
                        ms.alterPartition(dbname, name, new_part.getValues(), new_part);
                        Iterator<MetaStoreEventListener> i$ = this.listeners.iterator();
                        while (i$.hasNext()) {
                            MetaStoreEventListener listener = i$.next();
                            listener.onAlterPartition(new AlterPartitionEvent(oldPart, new_part, true, this));
                        }
                        return;
                    }
                    catch (InvalidObjectException e) {
                        throw new InvalidOperationException("alter is not possible");
                    }
                    catch (NoSuchObjectException e) {
                        throw new InvalidOperationException("alter is not possible");
                    }
                }
                try {
                    ms.openTransaction();
                    try {
                        oldPart = ms.getPartition(dbname, name, part_vals);
                    }
                    catch (NoSuchObjectException e) {
                        throw new InvalidObjectException("Unable to rename partition because old partition does not exist");
                    }
                    Partition check_part = null;
                    try {
                        check_part = ms.getPartition(dbname, name, new_part.getValues());
                    }
                    catch (NoSuchObjectException e) {
                        check_part = null;
                    }
                    if (check_part != null) {
                        throw new AlreadyExistsException("Partition already exists:" + dbname + "." + name + "." + new_part.getValues());
                    }
                    tbl = ms.getTable(dbname, name);
                    if (tbl == null) {
                        throw new InvalidObjectException("Unable to rename partition because table or database do not exist");
                    }
                    try {
                        destPath = new Path(this.wh.getTablePath(ms.getDatabase(dbname), name), Warehouse.makePartName(tbl.getPartitionKeys(), new_part.getValues()));
                    }
                    catch (NoSuchObjectException e) {
                        LOG.debug((Object)e);
                        throw new InvalidOperationException("Unable to change partition or table. Database " + dbname + " does not exist" + " Check metastore logs for detailed stack." + e.getMessage());
                    }
                    if (destPath != null) {
                        newPartLoc = destPath.toString();
                        oldPartLoc = oldPart.getSd().getLocation();
                        srcPath = new Path(oldPartLoc);
                        LOG.info((Object)("srcPath:" + oldPartLoc));
                        LOG.info((Object)("descPath:" + newPartLoc));
                        srcFs = this.wh.getFs(srcPath);
                        destFs = this.wh.getFs(destPath);
                        if (srcFs != destFs) {
                            throw new InvalidOperationException("table new location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported");
                        }
                        try {
                            srcFs.exists(srcPath);
                            if (newPartLoc.compareTo(oldPartLoc) != 0 && destFs.exists(destPath)) {
                                throw new InvalidOperationException("New location for this table " + tbl.getDbName() + "." + tbl.getTableName() + " already exists : " + destPath);
                            }
                        }
                        catch (IOException e) {
                            Warehouse.closeFs(srcFs);
                            Warehouse.closeFs(destFs);
                            throw new InvalidOperationException("Unable to access new location " + destPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + new_part.getValues());
                        }
                        new_part.getSd().setLocation(newPartLoc);
                        ms.alterPartition(dbname, name, part_vals, new_part);
                    }
                    if (!(success = ms.commitTransaction())) {
                        ms.rollbackTransaction();
                    }
                    if (!success || newPartLoc.compareTo(oldPartLoc) == 0) break block38;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    }
                    if (success && newPartLoc.compareTo(oldPartLoc) != 0) {
                        try {
                            if (srcFs.exists(srcPath)) {
                                Path destParentPath = destPath.getParent();
                                if (!this.wh.mkdirs(destParentPath)) {
                                    throw new IOException("Unable to create path " + destParentPath);
                                }
                                srcFs.rename(srcPath, destPath);
                                LOG.info((Object)"rename done!");
                            }
                        }
                        catch (IOException e) {
                            boolean revertMetaDataTransaction = false;
                            try {
                                ms.openTransaction();
                                ms.alterPartition(dbname, name, new_part.getValues(), oldPart);
                                revertMetaDataTransaction = ms.commitTransaction();
                                throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                            }
                            catch (Exception e1) {
                                LOG.error((Object)"Reverting metadata opeation failed During HDFS operation failed", (Throwable)e1);
                                if (revertMetaDataTransaction) throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                                ms.rollbackTransaction();
                            }
                            throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                        }
                    }
                    Iterator<MetaStoreEventListener> i$ = this.listeners.iterator();
                    while (i$.hasNext()) {
                        MetaStoreEventListener listener = i$.next();
                        listener.onAlterPartition(new AlterPartitionEvent(oldPart, new_part, true, this));
                    }
                    throw throwable;
                }
                try {
                    if (srcFs.exists(srcPath)) {
                        Path destParentPath = destPath.getParent();
                        if (!this.wh.mkdirs(destParentPath)) {
                            throw new IOException("Unable to create path " + destParentPath);
                        }
                        srcFs.rename(srcPath, destPath);
                        LOG.info((Object)"rename done!");
                    }
                }
                catch (IOException e) {
                    boolean revertMetaDataTransaction = false;
                    try {
                        ms.openTransaction();
                        ms.alterPartition(dbname, name, new_part.getValues(), oldPart);
                        revertMetaDataTransaction = ms.commitTransaction();
                        throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                    }
                    catch (Exception e1) {
                        LOG.error((Object)"Reverting metadata opeation failed During HDFS operation failed", (Throwable)e1);
                        if (revertMetaDataTransaction) throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                        ms.rollbackTransaction();
                    }
                    throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                }
            }
            Iterator<MetaStoreEventListener> i$ = this.listeners.iterator();
            while (i$.hasNext()) {
                MetaStoreEventListener listener = i$.next();
                listener.onAlterPartition(new AlterPartitionEvent(oldPart, new_part, true, this));
            }
        }

        public boolean create_index(Index index_def) throws IndexAlreadyExistsException, MetaException {
            this.endFunction(this.startFunction("create_index"), false);
            throw new MetaException("Not yet implemented");
        }

        @Override
        public void alter_index(final String dbname, final String base_table_name, final String index_name, final Index newIndex) throws InvalidOperationException, MetaException {
            this.startFunction("alter_index", ": db=" + dbname + " base_tbl=" + base_table_name + " idx=" + index_name + " newidx=" + newIndex.getIndexName());
            newIndex.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            boolean success = false;
            try {
                success = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        ms.alterIndex(dbname, base_table_name, index_name, newIndex);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidOperationException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("alter_index", false);
            }
        }

        public String getVersion() throws TException {
            this.endFunction(this.startFunction("getVersion"), true);
            return "3.0";
        }

        @Override
        public void alter_table(final String dbname, final String name, final Table newTable) throws InvalidOperationException, MetaException {
            this.startFunction("alter_table", ": db=" + dbname + " tbl=" + name + " newtbl=" + newTable.getTableName());
            if (newTable.getParameters() == null || newTable.getParameters().get("transient_lastDdlTime") == null) {
                newTable.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            }
            boolean success = false;
            try {
                Table oldt = this.get_table(dbname, name);
                success = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.alterHandler.alterTable(ms, HMSHandler.this.wh, dbname, name, newTable);
                        return Boolean.TRUE;
                    }
                });
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onAlterTable(new AlterTableEvent(oldt, newTable, success, this));
                }
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidOperationException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw new InvalidOperationException(e.getMessage());
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("alter_table", success);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<String> get_tables(final String dbname, final String pattern) throws MetaException {
            this.startFunction("get_tables", ": db=" + dbname + " pat=" + pattern);
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    public List<String> run(RawStore ms) throws Exception {
                        return ms.getTables(dbname, pattern);
                    }
                });
                this.endFunction("get_tables", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        if ($assertionsDisabled) throw (RuntimeException)e2;
                        if (e2 instanceof RuntimeException) throw (RuntimeException)e2;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_tables", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<String> get_all_tables(final String dbname) throws MetaException {
            this.startFunction("get_all_tables", ": db=" + dbname);
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    public List<String> run(RawStore ms) throws Exception {
                        return ms.getAllTables(dbname);
                    }
                });
                this.endFunction("get_all_tables", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        if ($assertionsDisabled) throw (RuntimeException)e2;
                        if (e2 instanceof RuntimeException) throw (RuntimeException)e2;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_all_tables", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FieldSchema> get_fields(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            this.startFunction("get_fields", ": db=" + db + "tbl=" + tableName);
            String[] names = tableName.split("\\.");
            String base_table_name = names[0];
            List<FieldSchema> ret = null;
            try {
                Table tbl;
                try {
                    tbl = this.get_table(db, base_table_name);
                }
                catch (NoSuchObjectException e) {
                    throw new UnknownTableException(e.getMessage());
                }
                boolean getColsFromSerDe = SerDeUtils.shouldGetColsFromSerDe(tbl.getSd().getSerdeInfo().getSerializationLib());
                if (!getColsFromSerDe) {
                    ret = tbl.getSd().getCols();
                } else {
                    try {
                        Deserializer s = MetaStoreUtils.getDeserializer((Configuration)this.hiveConf, tbl);
                        ret = MetaStoreUtils.getFieldsFromDeserializer(tableName, s);
                    }
                    catch (SerDeException e) {
                        org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e);
                        throw new MetaException(e.getMessage());
                    }
                }
                this.endFunction("get_fields", ret != null);
            }
            catch (Throwable throwable) {
                this.endFunction("get_fields", ret != null);
                throw throwable;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FieldSchema> get_schema(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            this.startFunction("get_schema", ": db=" + db + "tbl=" + tableName);
            boolean success = false;
            try {
                Table tbl;
                String[] names = tableName.split("\\.");
                String base_table_name = names[0];
                try {
                    tbl = this.get_table(db, base_table_name);
                }
                catch (NoSuchObjectException e) {
                    throw new UnknownTableException(e.getMessage());
                }
                List<FieldSchema> fieldSchemas = this.get_fields(db, base_table_name);
                if (tbl == null || fieldSchemas == null) {
                    throw new UnknownTableException(tableName + " doesn't exist");
                }
                if (tbl.getPartitionKeys() != null) {
                    fieldSchemas.addAll(tbl.getPartitionKeys());
                }
                success = true;
                List<FieldSchema> list = fieldSchemas;
                return list;
            }
            finally {
                this.endFunction("get_schema", success);
            }
        }

        public String getCpuProfile(int profileDurationInSec) throws TException {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get_config_value(String name, String defaultValue) throws TException, ConfigValSecurityException {
            this.startFunction("get_config_value", ": name=" + name + " defaultValue=" + defaultValue);
            boolean success = false;
            try {
                if (name == null) {
                    success = true;
                    String string = defaultValue;
                    return string;
                }
                if (!Pattern.matches("(hive|hdfs|mapred).*", name)) {
                    throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
                }
                String toReturn = defaultValue;
                try {
                    toReturn = this.hiveConf.get(name, defaultValue);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)(threadLocalId.get().toString() + ": " + "RuntimeException thrown in get_config_value - msg: " + e.getMessage() + " cause: " + e.getCause()));
                }
                success = true;
                String string = toReturn;
                return string;
            }
            finally {
                this.endFunction("get_config_value", success);
            }
        }

        private List<String> getPartValsFromName(RawStore ms, String dbName, String tblName, String partName) throws MetaException, InvalidObjectException {
            LinkedHashMap<String, String> hm = Warehouse.makeSpecFromName(partName);
            Table t = ms.getTable(dbName, tblName);
            if (t == null) {
                throw new InvalidObjectException(dbName + "." + tblName + " table not found");
            }
            ArrayList<String> partVals = new ArrayList<String>();
            for (FieldSchema field : t.getPartitionKeys()) {
                String key = field.getName();
                String val = hm.get(key);
                if (val == null) {
                    throw new InvalidObjectException("incomplete partition name - missing " + key);
                }
                partVals.add(val);
            }
            return partVals;
        }

        private Partition get_partition_by_name_core(RawStore ms, String db_name, String tbl_name, String part_name) throws MetaException, NoSuchObjectException, TException {
            List<String> partVals = null;
            try {
                partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            Partition p = ms.getPartition(db_name, tbl_name, partVals);
            if (p == null) {
                throw new NoSuchObjectException(db_name + "." + tbl_name + " partition (" + part_name + ") not found");
            }
            return p;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Partition get_partition_by_name(final String db_name, final String tbl_name, final String part_name) throws MetaException, NoSuchObjectException, TException {
            this.startFunction("get_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    public Partition run(RawStore ms) throws Exception {
                        return HMSHandler.this.get_partition_by_name_core(ms, db_name, tbl_name, part_name);
                    }
                });
                this.endFunction("get_partition_by_name", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (NoSuchObjectException e2) {
                        throw e2;
                    }
                    catch (TException e3) {
                        throw e3;
                    }
                    catch (Exception e4) {
                        if ($assertionsDisabled) throw (RuntimeException)e4;
                        if (e4 instanceof RuntimeException) throw (RuntimeException)e4;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_by_name", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Partition append_partition_by_name(final String db_name, final String tbl_name, final String part_name) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            this.startFunction("append_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    public Partition run(RawStore ms) throws Exception {
                        List partVals = HMSHandler.this.getPartValsFromName(ms, db_name, tbl_name, part_name);
                        return HMSHandler.this.append_partition_common(ms, db_name, tbl_name, partVals);
                    }
                });
                this.endFunction("append_partition_by_name", ret != null);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    throw e;
                    catch (AlreadyExistsException e2) {
                        throw e2;
                    }
                    catch (MetaException e3) {
                        throw e3;
                    }
                    catch (TException e4) {
                        throw e4;
                    }
                    catch (Exception e5) {
                        if ($assertionsDisabled) throw (RuntimeException)e5;
                        if (e5 instanceof RuntimeException) throw (RuntimeException)e5;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("append_partition_by_name", ret != null);
                    throw throwable;
                }
            }
        }

        private boolean drop_partition_by_name_core(RawStore ms, String db_name, String tbl_name, String part_name, boolean deleteData) throws NoSuchObjectException, MetaException, TException, IOException {
            List<String> partVals = null;
            try {
                partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            return this.drop_partition_common(ms, db_name, tbl_name, partVals, deleteData);
        }

        @Override
        public boolean drop_partition_by_name(final String db_name, final String tbl_name, final String part_name, final boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.startFunction("drop_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            boolean ret = false;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        return HMSHandler.this.drop_partition_by_name_core(ms, db_name, tbl_name, part_name, deleteData);
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_partition_by_name", ret);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> get_partitions_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException {
            this.startPartitionFunction("get_partitions_ps", db_name, tbl_name, part_vals);
            List<Partition> ret = null;
            try {
                ret = this.get_partitions_ps_with_auth(db_name, tbl_name, part_vals, max_parts, null, null);
                this.endFunction("get_partitions_ps", ret != null);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_ps", ret != null);
                throw throwable;
            }
            return ret;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Partition> get_partitions_ps_with_auth(final String db_name, final String tbl_name, final List<String> part_vals, final short max_parts, final String userName, final List<String> groupNames) throws MetaException, TException {
            this.startPartitionFunction("get_partitions_ps_with_auth", db_name, tbl_name, part_vals);
            List<Partition> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Partition>>(){

                    @Override
                    public List<Partition> run(RawStore ms) throws Exception {
                        return ms.listPartitionsPsWithAuth(db_name, tbl_name, part_vals, max_parts, userName, groupNames);
                    }
                });
                this.endFunction("get_partitions_ps_with_auth", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (InvalidObjectException e2) {
                        throw new MetaException(e2.getMessage());
                    }
                    catch (Exception e3) {
                        if ($assertionsDisabled) throw (RuntimeException)e3;
                        if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_ps_with_auth", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<String> get_partition_names_ps(final String db_name, final String tbl_name, final List<String> part_vals, final short max_parts) throws MetaException, TException {
            this.startPartitionFunction("get_partitions_names_ps", db_name, tbl_name, part_vals);
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    public List<String> run(RawStore ms) throws Exception {
                        return ms.listPartitionNamesPs(db_name, tbl_name, part_vals, max_parts);
                    }
                });
                this.endFunction("get_partitions_names_ps", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        if ($assertionsDisabled) throw (RuntimeException)e2;
                        if (e2 instanceof RuntimeException) throw (RuntimeException)e2;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_names_ps", ret != null);
                    throw throwable;
                }
            }
        }

        @Override
        public List<String> partition_name_to_vals(String part_name) throws MetaException, TException {
            if (part_name.length() == 0) {
                return new ArrayList<String>();
            }
            LinkedHashMap<String, String> map = Warehouse.makeSpecFromName(part_name);
            ArrayList<String> part_vals = new ArrayList<String>();
            part_vals.addAll(map.values());
            return part_vals;
        }

        @Override
        public Map<String, String> partition_name_to_spec(String part_name) throws MetaException, TException {
            if (part_name.length() == 0) {
                return new HashMap<String, String>();
            }
            return Warehouse.makeSpecFromName(part_name);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Index add_index(final Index newIndex, final Table indexTable) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            this.startFunction("add_index", ": db=" + newIndex.getDbName() + " tbl=" + newIndex.getOrigTableName() + " index=" + newIndex.getIndexName());
            Index ret = null;
            try {
                ret = this.executeWithRetry(new Command<Index>(){

                    @Override
                    public Index run(RawStore ms) throws Exception {
                        return HMSHandler.this.add_index_core(ms, newIndex, indexTable);
                    }
                });
                this.endFunction("add_index", ret != null);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    throw e;
                    catch (AlreadyExistsException e2) {
                        throw e2;
                    }
                    catch (MetaException e3) {
                        throw e3;
                    }
                    catch (Exception e4) {
                        if ($assertionsDisabled) throw (RuntimeException)e4;
                        if (e4 instanceof RuntimeException) throw (RuntimeException)e4;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("add_index", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Index add_index_core(RawStore ms, Index index, Table indexTable) throws InvalidObjectException, AlreadyExistsException, MetaException {
            boolean success = false;
            boolean indexTableCreated = false;
            try {
                ms.openTransaction();
                Index old_index = null;
                try {
                    old_index = this.get_index_by_name(index.getDbName(), index.getOrigTableName(), index.getIndexName());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (old_index != null) {
                    throw new AlreadyExistsException("Index already exists:" + index);
                }
                Table origTbl = ms.getTable(index.getDbName(), index.getOrigTableName());
                if (origTbl == null) {
                    throw new InvalidObjectException("Unable to add index because database or the orginal table do not exist");
                }
                long time = System.currentTimeMillis() / 1000L;
                Table indexTbl = indexTable;
                if (indexTbl != null) {
                    try {
                        indexTbl = ms.getTable(index.getDbName(), index.getIndexTableName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (indexTbl != null) {
                        throw new InvalidObjectException("Unable to add index because index table already exists");
                    }
                    this.create_table(indexTable);
                    indexTableCreated = true;
                }
                index.setCreateTime((int)time);
                index.putToParameters("transient_lastDdlTime", Long.toString(time));
                ms.addIndex(index);
                success = ms.commitTransaction();
                Index index2 = index;
                return index2;
            }
            finally {
                if (!success) {
                    if (indexTableCreated) {
                        try {
                            this.drop_table(index.getDbName(), index.getIndexTableName(), false);
                        }
                        catch (Exception e) {}
                    }
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean drop_index_by_name(final String dbName, final String tblName, final String indexName, final boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.startFunction("drop_index_by_name", ": db=" + dbName + " tbl=" + tblName + " index=" + indexName);
            boolean ret = false;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        return HMSHandler.this.drop_index_by_name_core(ms, dbName, tblName, indexName, deleteData);
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_index_by_name", ret);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drop_index_by_name_core(RawStore ms, String dbName, String tblName, String indexName, boolean deleteData) throws NoSuchObjectException, MetaException, TException, IOException {
            boolean success = false;
            Path tblPath = null;
            try {
                ms.openTransaction();
                Index index = this.get_index_by_name(dbName, tblName, indexName);
                if (index == null) {
                    throw new NoSuchObjectException(indexName + " doesn't exist");
                }
                ms.dropIndex(dbName, tblName, indexName);
                String idxTblName = index.getIndexTableName();
                if (idxTblName != null) {
                    Table tbl = null;
                    tbl = this.get_table(dbName, idxTblName);
                    if (tbl.getSd() == null) {
                        throw new MetaException("Table metadata is corrupted");
                    }
                    if (tbl.getSd().getLocation() != null && !this.wh.isWritable((tblPath = new Path(tbl.getSd().getLocation())).getParent())) {
                        throw new MetaException("Index table metadata not deleted since " + tblPath.getParent() + " is not writable by " + this.hiveConf.getUser());
                    }
                    if (!ms.dropTable(dbName, idxTblName)) {
                        throw new MetaException("Unable to drop underlying data table " + idxTblName + " for index " + idxTblName);
                    }
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                    return false;
                }
                if (deleteData && tblPath != null) {
                    this.wh.deleteDir(tblPath, true);
                }
            }
            return true;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Index get_index_by_name(final String dbName, final String tblName, final String indexName) throws MetaException, NoSuchObjectException, TException {
            this.startFunction("get_index_by_name", ": db=" + dbName + " tbl=" + tblName + " index=" + indexName);
            Index ret = null;
            try {
                ret = this.executeWithRetry(new Command<Index>(){

                    @Override
                    public Index run(RawStore ms) throws Exception {
                        return HMSHandler.this.get_index_by_name_core(ms, dbName, tblName, indexName);
                    }
                });
                this.endFunction("drop_index_by_name", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (NoSuchObjectException e2) {
                        throw e2;
                    }
                    catch (TException e3) {
                        throw e3;
                    }
                    catch (Exception e4) {
                        if ($assertionsDisabled) throw (RuntimeException)e4;
                        if (e4 instanceof RuntimeException) throw (RuntimeException)e4;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("drop_index_by_name", ret != null);
                    throw throwable;
                }
            }
        }

        private Index get_index_by_name_core(RawStore ms, String db_name, String tbl_name, String index_name) throws MetaException, NoSuchObjectException, TException {
            Index index = ms.getIndex(db_name, tbl_name, index_name);
            if (index == null) {
                throw new NoSuchObjectException(db_name + "." + tbl_name + " index=" + index_name + " not found");
            }
            return index;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<String> get_index_names(final String dbName, final String tblName, final short maxIndexes) throws MetaException, TException {
            this.startTableFunction("get_index_names", dbName, tblName);
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    public List<String> run(RawStore ms) throws Exception {
                        return ms.listIndexNames(dbName, tblName, maxIndexes);
                    }
                });
                this.endFunction("get_index_names", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        if ($assertionsDisabled) throw (RuntimeException)e2;
                        if (e2 instanceof RuntimeException) throw (RuntimeException)e2;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_index_names", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Index> get_indexes(final String dbName, final String tblName, final short maxIndexes) throws NoSuchObjectException, MetaException, TException {
            this.startTableFunction("get_indexes", dbName, tblName);
            List<Index> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Index>>(){

                    @Override
                    public List<Index> run(RawStore ms) throws Exception {
                        return ms.getIndexes(dbName, tblName, maxIndexes);
                    }
                });
                this.endFunction("get_indexes", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        if ($assertionsDisabled) throw (RuntimeException)e2;
                        if (e2 instanceof RuntimeException) throw (RuntimeException)e2;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_indexes", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Partition> get_partitions_by_filter(final String dbName, final String tblName, final String filter, final short maxParts) throws MetaException, NoSuchObjectException, TException {
            this.startTableFunction("get_partitions_by_filter", dbName, tblName);
            List<Partition> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Partition>>(){

                    @Override
                    public List<Partition> run(RawStore ms) throws Exception {
                        return ms.getPartitionsByFilter(dbName, tblName, filter, maxParts);
                    }
                });
                this.endFunction("get_partitions_by_filter", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (NoSuchObjectException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        if ($assertionsDisabled) throw (RuntimeException)e3;
                        if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_by_filter", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Partition> get_partitions_by_names(final String dbName, final String tblName, final List<String> partNames) throws MetaException, NoSuchObjectException, TException {
            this.startTableFunction("get_partitions_by_names", dbName, tblName);
            List<Partition> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Partition>>(){

                    @Override
                    public List<Partition> run(RawStore ms) throws Exception {
                        return ms.getPartitionsByNames(dbName, tblName, partNames);
                    }
                });
                this.endFunction("get_partitions_by_names", ret != null);
                return ret;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (NoSuchObjectException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        if ($assertionsDisabled) throw (RuntimeException)e3;
                        if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_by_names", ret != null);
                    throw throwable;
                }
            }
        }

        @Override
        public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
            if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
                String partName = this.getPartName(hiveObject);
                return this.get_column_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), partName, hiveObject.getColumnName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                String partName = this.getPartName(hiveObject);
                return this.get_partition_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), partName, userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                return this.get_db_privilege_set(hiveObject.getDbName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                return this.get_table_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                return this.get_user_privilege_set(userName, groupNames);
            }
            return null;
        }

        private String getPartName(HiveObjectRef hiveObject) throws MetaException {
            String partName = null;
            List<String> partValue = hiveObject.getPartValues();
            if (partValue != null && partValue.size() > 0) {
                try {
                    Table table = this.get_table(hiveObject.getDbName(), hiveObject.getObjectName());
                    partName = Warehouse.makePartName(table.getPartitionKeys(), partValue);
                }
                catch (NoSuchObjectException e) {
                    throw new MetaException(e.getMessage());
                }
            }
            return partName;
        }

        public PrincipalPrivilegeSet get_column_privilege_set(final String dbName, final String tableName, final String partName, final String columnName, final String userName, final List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_column_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.executeWithRetry(new Command<PrincipalPrivilegeSet>(){

                    @Override
                    public PrincipalPrivilegeSet run(RawStore ms) throws Exception {
                        return ms.getColumnPrivilegeSet(dbName, tableName, partName, columnName, userName, groupNames);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_db_privilege_set(final String dbName, final String userName, final List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_db_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.executeWithRetry(new Command<PrincipalPrivilegeSet>(){

                    @Override
                    public PrincipalPrivilegeSet run(RawStore ms) throws Exception {
                        return ms.getDBPrivilegeSet(dbName, userName, groupNames);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_partition_privilege_set(final String dbName, final String tableName, final String partName, final String userName, final List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_partition_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.executeWithRetry(new Command<PrincipalPrivilegeSet>(){

                    @Override
                    public PrincipalPrivilegeSet run(RawStore ms) throws Exception {
                        return ms.getPartitionPrivilegeSet(dbName, tableName, partName, userName, groupNames);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_table_privilege_set(final String dbName, final String tableName, final String userName, final List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_table_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.executeWithRetry(new Command<PrincipalPrivilegeSet>(){

                    @Override
                    public PrincipalPrivilegeSet run(RawStore ms) throws Exception {
                        return ms.getTablePrivilegeSet(dbName, tableName, userName, groupNames);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean grant_role(final String roleName, final String userName, final PrincipalType principalType, final String grantor, final PrincipalType grantorType, final boolean grantOption) throws MetaException, TException {
            this.incrementCounter("add_role_member");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        Role role = ms.getRole(roleName);
                        return ms.grantRole(role, userName, principalType, grantor, grantorType, grantOption);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public List<Role> list_roles(final String principalName, final PrincipalType principalType) throws MetaException, TException {
            this.incrementCounter("list_roles");
            List<Role> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Role>>(){

                    @Override
                    public List<Role> run(RawStore ms) throws Exception {
                        ArrayList<Role> result = new ArrayList<Role>();
                        List<MRoleMap> roleMap = ms.listRoles(principalName, principalType);
                        if (roleMap != null) {
                            for (MRoleMap role : roleMap) {
                                MRole r = role.getRole();
                                result.add(new Role(r.getRoleName(), r.getCreateTime(), r.getOwnerName()));
                            }
                        }
                        return result;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean create_role(final Role role) throws MetaException, TException {
            this.incrementCounter("create_role");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        return ms.addRole(role.getRoleName(), role.getOwnerName());
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean drop_role(final String roleName) throws MetaException, TException {
            this.incrementCounter("drop_role");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        return ms.removeRole(roleName);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public List<String> get_role_names() throws MetaException, TException {
            this.incrementCounter("get_role_names");
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    public List<String> run(RawStore ms) throws Exception {
                        return ms.listRoleNames();
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public boolean grant_privileges(final PrivilegeBag privileges) throws MetaException, TException {
            this.incrementCounter("grant_privileges");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        return ms.grantPrivileges(privileges);
                    }
                });
            }
            catch (MetaException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean revoke_role(final String roleName, final String userName, final PrincipalType principalType) throws MetaException, TException {
            this.incrementCounter("remove_role_member");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        Role mRole = ms.getRole(roleName);
                        return ms.revokeRole(mRole, userName, principalType);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean revoke_privileges(final PrivilegeBag privileges) throws MetaException, TException {
            this.incrementCounter("revoke_privileges");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        return ms.revokePrivileges(privileges);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_user_privilege_set(final String userName, final List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_user_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.executeWithRetry(new Command<PrincipalPrivilegeSet>(){

                    @Override
                    public PrincipalPrivilegeSet run(RawStore ms) throws Exception {
                        return ms.getUserPrivilegeSet(userName, groupNames);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalType getPrincipalType(String principalType) {
            return PrincipalType.valueOf(principalType);
        }

        @Override
        public List<HiveObjectPrivilege> list_privileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObject) throws MetaException, TException {
            if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                return this.list_global_privileges(principalName, principalType);
            }
            if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                return this.list_db_privileges(principalName, principalType, hiveObject.getDbName());
            }
            if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                return this.list_table_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName());
            }
            if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                return this.list_partition_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues());
            }
            if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
                return this.list_column_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues(), hiveObject.getColumnName());
            }
            return null;
        }

        public List<HiveObjectPrivilege> list_column_privileges(final String principalName, final PrincipalType principalType, final String dbName, final String tableName, final List<String> partValues, final String columnName) throws MetaException, TException {
            this.incrementCounter("list_security_column_grant");
            List<HiveObjectPrivilege> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<HiveObjectPrivilege>>(){

                    @Override
                    public List<HiveObjectPrivilege> run(RawStore ms) throws Exception {
                        List<HiveObjectPrivilege> result;
                        block5: {
                            block4: {
                                String partName = null;
                                if (partValues != null && partValues.size() > 0) {
                                    Table tbl = HMSHandler.this.get_table(dbName, tableName);
                                    partName = Warehouse.makePartName(tbl.getPartitionKeys(), partValues);
                                }
                                result = Collections.emptyList();
                                if (partName == null) break block4;
                                Partition part = null;
                                part = HMSHandler.this.get_partition_by_name(dbName, tableName, partName);
                                List<MPartitionColumnPrivilege> mPartitionCols = ms.listPrincipalPartitionColumnGrants(principalName, principalType, dbName, tableName, partName, columnName);
                                if (mPartitionCols.size() <= 0) break block5;
                                result = new ArrayList<HiveObjectPrivilege>();
                                for (int i = 0; i < mPartitionCols.size(); ++i) {
                                    MPartitionColumnPrivilege sCol = mPartitionCols.get(i);
                                    HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, part == null ? null : part.getValues(), sCol.getColumnName());
                                    HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sCol.getPrincipalName(), principalType, new PrivilegeGrantInfo(sCol.getPrivilege(), sCol.getCreateTime(), sCol.getGrantor(), PrincipalType.valueOf(sCol.getGrantorType()), sCol.getGrantOption()));
                                    result.add(secObj);
                                }
                                break block5;
                            }
                            List<MTableColumnPrivilege> mTableCols = ms.listPrincipalTableColumnGrants(principalName, principalType, dbName, tableName, columnName);
                            if (mTableCols.size() > 0) {
                                result = new ArrayList<HiveObjectPrivilege>();
                                for (int i = 0; i < mTableCols.size(); ++i) {
                                    MTableColumnPrivilege sCol = mTableCols.get(i);
                                    HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, null, sCol.getColumnName());
                                    HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sCol.getPrincipalName(), principalType, new PrivilegeGrantInfo(sCol.getPrivilege(), sCol.getCreateTime(), sCol.getGrantor(), PrincipalType.valueOf(sCol.getGrantorType()), sCol.getGrantOption()));
                                    result.add(secObj);
                                }
                            }
                        }
                        return result;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public List<HiveObjectPrivilege> list_db_privileges(final String principalName, final PrincipalType principalType, final String dbName) throws MetaException, TException {
            this.incrementCounter("list_security_db_grant");
            List<HiveObjectPrivilege> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<HiveObjectPrivilege>>(){

                    @Override
                    public List<HiveObjectPrivilege> run(RawStore ms) throws Exception {
                        List<MDBPrivilege> mDbs = ms.listPrincipalDBGrants(principalName, principalType, dbName);
                        if (mDbs.size() > 0) {
                            ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                            for (int i = 0; i < mDbs.size(); ++i) {
                                MDBPrivilege sDB = mDbs.get(i);
                                HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null);
                                HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sDB.getPrincipalName(), principalType, new PrivilegeGrantInfo(sDB.getPrivilege(), sDB.getCreateTime(), sDB.getGrantor(), PrincipalType.valueOf(sDB.getGrantorType()), sDB.getGrantOption()));
                                result.add(secObj);
                            }
                            return result;
                        }
                        return Collections.emptyList();
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public List<HiveObjectPrivilege> list_partition_privileges(final String principalName, final PrincipalType principalType, final String dbName, final String tableName, final List<String> partValues) throws MetaException, TException {
            this.incrementCounter("list_security_partition_grant");
            List<HiveObjectPrivilege> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<HiveObjectPrivilege>>(){

                    @Override
                    public List<HiveObjectPrivilege> run(RawStore ms) throws Exception {
                        Table tbl = HMSHandler.this.get_table(dbName, tableName);
                        String partName = Warehouse.makePartName(tbl.getPartitionKeys(), partValues);
                        List<MPartitionPrivilege> mParts = ms.listPrincipalPartitionGrants(principalName, principalType, dbName, tableName, partName);
                        if (mParts.size() > 0) {
                            ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                            for (int i = 0; i < mParts.size(); ++i) {
                                MPartitionPrivilege sPart = mParts.get(i);
                                HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.PARTITION, dbName, tableName, partValues, null);
                                HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sPart.getPrincipalName(), principalType, new PrivilegeGrantInfo(sPart.getPrivilege(), sPart.getCreateTime(), sPart.getGrantor(), PrincipalType.valueOf(sPart.getGrantorType()), sPart.getGrantOption()));
                                result.add(secObj);
                            }
                            return result;
                        }
                        return Collections.emptyList();
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public List<HiveObjectPrivilege> list_table_privileges(final String principalName, final PrincipalType principalType, final String dbName, final String tableName) throws MetaException, TException {
            this.incrementCounter("list_security_table_grant");
            List<HiveObjectPrivilege> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<HiveObjectPrivilege>>(){

                    @Override
                    public List<HiveObjectPrivilege> run(RawStore ms) throws Exception {
                        List<MTablePrivilege> mTbls = ms.listAllTableGrants(principalName, principalType, dbName, tableName);
                        if (mTbls.size() > 0) {
                            ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                            for (int i = 0; i < mTbls.size(); ++i) {
                                MTablePrivilege sTbl = mTbls.get(i);
                                HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.TABLE, dbName, tableName, null, null);
                                HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sTbl.getPrincipalName(), principalType, new PrivilegeGrantInfo(sTbl.getPrivilege(), sTbl.getCreateTime(), sTbl.getGrantor(), PrincipalType.valueOf(sTbl.getGrantorType()), sTbl.getGrantOption()));
                                result.add(secObj);
                            }
                            return result;
                        }
                        return Collections.emptyList();
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public List<HiveObjectPrivilege> list_global_privileges(final String principalName, final PrincipalType principalType) throws MetaException, TException {
            this.incrementCounter("list_security_user_grant");
            List<HiveObjectPrivilege> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<HiveObjectPrivilege>>(){

                    @Override
                    public List<HiveObjectPrivilege> run(RawStore ms) throws Exception {
                        List<MGlobalPrivilege> mUsers = ms.listPrincipalGlobalGrants(principalName, principalType);
                        if (mUsers.size() > 0) {
                            ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                            for (int i = 0; i < mUsers.size(); ++i) {
                                MGlobalPrivilege sUsr = mUsers.get(i);
                                HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null);
                                HiveObjectPrivilege secUser = new HiveObjectPrivilege(objectRef, sUsr.getPrincipalName(), principalType, new PrivilegeGrantInfo(sUsr.getPrivilege(), sUsr.getCreateTime(), sUsr.getGrantor(), PrincipalType.valueOf(sUsr.getGrantorType()), sUsr.getGrantOption()));
                                result.add(secUser);
                            }
                            return result;
                        }
                        return Collections.emptyList();
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public void cancel_delegation_token(String token_str_form) throws MetaException, TException {
            this.startFunction("cancel_delegation_token");
            boolean success = false;
            try {
                HiveMetaStore.cancelDelegationToken(token_str_form);
                success = true;
            }
            catch (IOException e) {
                throw new MetaException(e.getMessage());
            }
            finally {
                this.endFunction("cancel_delegation_token", success);
            }
        }

        @Override
        public long renew_delegation_token(String token_str_form) throws MetaException, TException {
            this.startFunction("renew_delegation_token");
            Long ret = null;
            try {
                ret = HiveMetaStore.renewDelegationToken(token_str_form);
                this.endFunction("renew_delegation_token", ret != null);
            }
            catch (IOException e) {
                try {
                    throw new MetaException(e.getMessage());
                }
                catch (Throwable throwable) {
                    this.endFunction("renew_delegation_token", ret != null);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String get_delegation_token(String token_owner, String renewer_kerberos_principal_name) throws MetaException, TException {
            this.startFunction("get_delegation_token");
            String ret = null;
            try {
                ret = HiveMetaStore.getDelegationToken(token_owner, renewer_kerberos_principal_name);
                this.endFunction("get_delegation_token", ret != null);
                return ret;
            }
            catch (IOException e) {
                try {
                    throw new MetaException(e.getMessage());
                    catch (InterruptedException e2) {
                        throw new MetaException(e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_delegation_token", ret != null);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void markPartitionForEvent(final String db_name, final String tbl_name, final Map<String, String> partName, final PartitionEventType evtType) throws MetaException, TException, NoSuchObjectException, UnknownDBException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
            Table tbl = null;
            try {
                this.startPartitionFunction("markPartitionForEvent", db_name, tbl_name, partName);
                try {
                    tbl = this.executeWithRetry(new Command<Table>(){

                        @Override
                        public Table run(RawStore ms) throws Exception {
                            return ms.markPartitionForEvent(db_name, tbl_name, partName, evtType);
                        }
                    });
                }
                catch (Exception original) {
                    LOG.error((Object)original);
                    if (original instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)original;
                    }
                    if (original instanceof UnknownTableException) {
                        throw (UnknownTableException)original;
                    }
                    if (original instanceof UnknownDBException) {
                        throw (UnknownDBException)original;
                    }
                    if (original instanceof UnknownPartitionException) {
                        throw (UnknownPartitionException)original;
                    }
                    if (original instanceof InvalidPartitionException) {
                        throw (InvalidPartitionException)original;
                    }
                    if (original instanceof MetaException) {
                        throw (MetaException)original;
                    }
                    MetaException me = new MetaException(original.toString());
                    me.initCause(original);
                    throw me;
                }
                if (null == tbl) {
                    throw new UnknownTableException("Table: " + tbl_name + " not found.");
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onLoadPartitionDone(new LoadPartitionDoneEvent(true, this, tbl, partName));
                }
                this.endFunction("markPartitionForEvent", tbl != null);
            }
            catch (Throwable throwable) {
                this.endFunction("markPartitionForEvent", tbl != null);
                throw throwable;
            }
        }

        @Override
        public boolean isPartitionMarkedForEvent(final String db_name, final String tbl_name, final Map<String, String> partName, final PartitionEventType evtType) throws MetaException, NoSuchObjectException, UnknownDBException, UnknownTableException, TException, UnknownPartitionException, InvalidPartitionException {
            this.startPartitionFunction("isPartitionMarkedForEvent", db_name, tbl_name, partName);
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    public Boolean run(RawStore ms) throws Exception {
                        return ms.isPartitionMarkedForEvent(db_name, tbl_name, partName, evtType);
                    }
                });
                this.endFunction("isPartitionMarkedForEvent", ret != null);
            }
            catch (Exception original) {
                try {
                    LOG.error((Object)original);
                    if (original instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)original;
                    }
                    if (original instanceof UnknownTableException) {
                        throw (UnknownTableException)original;
                    }
                    if (original instanceof UnknownDBException) {
                        throw (UnknownDBException)original;
                    }
                    if (original instanceof UnknownPartitionException) {
                        throw (UnknownPartitionException)original;
                    }
                    if (original instanceof InvalidPartitionException) {
                        throw (InvalidPartitionException)original;
                    }
                    if (original instanceof MetaException) {
                        throw (MetaException)original;
                    }
                    MetaException me = new MetaException(original.toString());
                    me.initCause(original);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("isPartitionMarkedForEvent", ret != null);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> set_ugi(String username, List<String> groupNames) throws MetaException, TException {
            Collections.addAll(groupNames, username);
            return groupNames;
        }

        @InterfaceAudience.LimitedPrivate(value={"HCATALOG"})
        @InterfaceStability.Evolving
        public static class Command<T> {
            @InterfaceAudience.LimitedPrivate(value={"HCATALOG"})
            @InterfaceStability.Evolving
            public T run(RawStore ms) throws Exception {
                return null;
            }
        }
    }
}

